/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.OperatingSystem;
import io.github.bonigarcia.wdm.Shell;
import io.github.bonigarcia.wdm.VersionComparator;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EdgeDriverManager
extends WebDriverManager {
    @Override
    protected DriverManagerType getDriverManagerType() {
        return DriverManagerType.EDGE;
    }

    @Override
    protected String getDriverName() {
        return "msedgedriver";
    }

    @Override
    protected String getDriverVersion() {
        return this.config().getEdgeDriverVersion();
    }

    @Override
    protected URL getDriverUrl() {
        return this.config().getEdgeDriverUrl();
    }

    @Override
    protected Optional<URL> getMirrorUrl() {
        return Optional.empty();
    }

    @Override
    protected Optional<String> getExportParameter() {
        return Optional.of(this.config().getEdgeDriverExport());
    }

    @Override
    protected void setDriverVersion(String version) {
        this.config().setEdgeDriverVersion(version);
    }

    @Override
    protected void setDriverUrl(URL url) {
        this.config().setEdgeDriverUrl(url);
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        this.listVersions = new ArrayList();
        ArrayList<URL> urlList = new ArrayList<URL>();
        URL driverUrl = this.getDriverUrl();
        log.debug("Reading {} to find out the latest version of Edge driver", (Object)driverUrl);
        try (InputStream in = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl)).getEntity().getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Elements downloadLink = doc.select("ul.driver-downloads li.driver-download > a");
            Elements versionParagraph = doc.select("ul.driver-downloads li.driver-download p.driver-download__meta");
            log.trace("[Original] Download links:\n{}", (Object)downloadLink);
            log.trace("[Original] Version paragraphs:\n{}", (Object)versionParagraph);
            downloadLink.remove(0);
            versionParagraph.remove(0);
            versionParagraph.remove(0);
            versionParagraph.remove(3);
            versionParagraph.remove(3);
            versionParagraph.remove(3);
            versionParagraph.remove(3);
            log.trace("[Clean] Download links:\n{}", (Object)downloadLink);
            log.trace("[Clean] Version paragraphs:\n{}", (Object)versionParagraph);
            int shiftLinks = versionParagraph.size() - downloadLink.size();
            log.trace("The difference between the size of versions and links is {}", (Object)shiftLinks);
            for (int i = 0; i < versionParagraph.size(); ++i) {
                Element paragraph = (Element)versionParagraph.get(i);
                String[] version = paragraph.text().split(" ");
                String v = version[1];
                this.listVersions.add(v);
                if (this.isChromiumBased(v)) {
                    int childIndex = 0;
                    if (!paragraph.text().contains("76.0.174.0")) {
                        if (this.config().getOs().equals(OperatingSystem.MAC.name())) {
                            childIndex = 2;
                        } else if (this.config().getArchitecture() == Architecture.X64) {
                            childIndex = 1;
                        }
                    }
                    urlList.add(new URL(paragraph.child(childIndex).attr("href")));
                    continue;
                }
                if (v.equalsIgnoreCase("version")) continue;
                urlList.add(new URL(((Element)downloadLink.get(i - shiftLinks)).attr("href")));
            }
            log.trace("Edge driver URL list {}", urlList);
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    @Override
    public List<String> getVersions() {
        this.httpClient = new HttpClient(this.config());
        try {
            this.getDrivers();
            Collections.sort(this.listVersions, new VersionComparator());
            return this.listVersions;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    @Override
    protected List<URL> checkLatest(List<URL> list, String driver) {
        log.trace("Checking the lastest version of {} with URL list {}", (Object)driver, list);
        ArrayList<URL> out = new ArrayList<URL>();
        this.versionToDownload = (String)this.listVersions.iterator().next();
        out.add(list.iterator().next());
        log.info("Latest version of Edge driver is {}", (Object)this.versionToDownload);
        return out;
    }

    @Override
    protected String preDownload(String target, String version) {
        int iVersion;
        if (this.isChromiumBased(version) && (iVersion = target.indexOf(version)) != -1) {
            target = target.substring(0, iVersion) + this.config().getArchitecture().name().toLowerCase() + File.separator + target.substring(iVersion);
        }
        log.trace("Pre-download in EdgeDriver -- target={}, version={}", (Object)target, (Object)version);
        return target;
    }

    @Override
    protected File postDownload(File archive) {
        Collection listFiles = FileUtils.listFiles((File)new File(archive.getParent()), null, (boolean)true);
        return (File)listFiles.iterator().next();
    }

    @Override
    protected Optional<String> getBrowserVersion() {
        if (SystemUtils.IS_OS_WINDOWS) {
            String browserVersionOutput;
            Optional<String> msedgeVersion = this.getDefaultBrowserVersion(this.getProgramFilesEnv(), "\\\\Microsoft\\\\Edge Dev\\\\Application\\\\msedge.exe", "", "", "--version", this.getDriverManagerType().toString());
            if (msedgeVersion.isPresent()) {
                browserVersionOutput = msedgeVersion.get();
                log.debug("Edge Dev (based on Chromium) version {} found", (Object)browserVersionOutput);
            } else {
                browserVersionOutput = Shell.runAndWait("powershell", "get-appxpackage Microsoft.MicrosoftEdge");
            }
            if (!Config.isNullOrEmpty(browserVersionOutput)) {
                return Optional.of(Shell.getVersionFromPowerShellOutput(browserVersionOutput));
            }
        }
        return Optional.empty();
    }

    private boolean isChromiumBased(String version) {
        long countDot = version.chars().filter(ch -> ch == 46).count();
        log.trace("Edge driver version {} ({} dots)", (Object)version, (Object)countDot);
        return countDot > 1L;
    }
}

