/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.OperatingSystem;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.UrlFilter;
import io.github.bonigarcia.wdm.VersionComparator;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebDriverManager {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SLASH = "/";
    protected static Map<DriverManagerType, WebDriverManager> instanceMap = new EnumMap<DriverManagerType, WebDriverManager>(DriverManagerType.class);
    protected static Config config;
    protected boolean useBeta = WebDriverManager.config().isUseBetaVersions();
    protected HttpClient httpClient;
    protected Downloader downloader;
    protected UrlFilter urlFilter;
    protected String versionToDownload;
    protected String downloadedVersion;
    protected String latestVersion;
    protected DriverManagerType driverManagerType;
    protected String binaryPath;
    protected boolean mirrorLog;
    protected List<String> listVersions;
    protected List<String> driverName;
    protected String driverVersionKey;
    protected String driverUrlKey;
    protected String driverMirrorUrlKey;
    protected String exportParameterKey;
    protected boolean forcedArch;

    protected abstract List<URL> getDrivers() throws IOException;

    public static synchronized Config config() {
        if (config == null) {
            config = new Config();
        }
        return config;
    }

    public static synchronized WebDriverManager chromedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.CHROME)) {
            instanceMap.put(DriverManagerType.CHROME, new ChromeDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.CHROME);
    }

    public static synchronized WebDriverManager firefoxdriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.FIREFOX)) {
            instanceMap.put(DriverManagerType.FIREFOX, new FirefoxDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.FIREFOX);
    }

    public static synchronized WebDriverManager operadriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.OPERA)) {
            instanceMap.put(DriverManagerType.OPERA, new OperaDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.OPERA);
    }

    public static synchronized WebDriverManager edgedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.EDGE)) {
            instanceMap.put(DriverManagerType.EDGE, new EdgeDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.EDGE);
    }

    public static synchronized WebDriverManager iedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.IEXPLORER)) {
            instanceMap.put(DriverManagerType.IEXPLORER, new InternetExplorerDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.IEXPLORER);
    }

    public static synchronized WebDriverManager phantomjs() {
        if (!instanceMap.containsKey((Object)DriverManagerType.PHANTOMJS)) {
            instanceMap.put(DriverManagerType.PHANTOMJS, new PhantomJsDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.PHANTOMJS);
    }

    protected static synchronized WebDriverManager voiddriver() {
        return new WebDriverManager(){

            @Override
            protected List<URL> getDrivers() throws IOException {
                return Collections.emptyList();
            }
        };
    }

    public static synchronized WebDriverManager getInstance(DriverManagerType driverManagerType) {
        if (driverManagerType == null) {
            return WebDriverManager.voiddriver();
        }
        switch (driverManagerType) {
            case CHROME: {
                return WebDriverManager.chromedriver();
            }
            case FIREFOX: {
                return WebDriverManager.firefoxdriver();
            }
            case OPERA: {
                return WebDriverManager.operadriver();
            }
            case IEXPLORER: {
                return WebDriverManager.iedriver();
            }
            case EDGE: {
                return WebDriverManager.edgedriver();
            }
            case PHANTOMJS: {
                return WebDriverManager.phantomjs();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public static synchronized WebDriverManager getInstance(Class<?> webDriverClass) {
        switch (webDriverClass.getName()) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                return WebDriverManager.chromedriver();
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                return WebDriverManager.firefoxdriver();
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                return WebDriverManager.operadriver();
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                return WebDriverManager.iedriver();
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                return WebDriverManager.edgedriver();
            }
            case "org.openqa.selenium.phantomjs.PhantomJSDriver": {
                return WebDriverManager.phantomjs();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public synchronized void setup() {
        if (this.driverManagerType != null) {
            try {
                this.manage(WebDriverManager.config().getArchitecture(), WebDriverManager.config().getDriverVersion(this.driverVersionKey));
            }
            finally {
                this.reset();
            }
        }
    }

    public WebDriverManager version(String version) {
        WebDriverManager.config().setDriverVersion(version);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager architecture(Architecture architecture) {
        WebDriverManager.config().setArchitecture(architecture);
        this.forcedArch = true;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager arch32() {
        this.architecture(Architecture.X32);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager arch64() {
        this.architecture(Architecture.X64);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager operatingSystem(OperatingSystem os) {
        WebDriverManager.config().setOs(os.name());
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager forceCache() {
        WebDriverManager.config().setForceCache(true);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager forceDownload() {
        WebDriverManager.config().setOverride(true);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager driverRepositoryUrl(URL url) {
        WebDriverManager.config().setDriverUrl(url);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager useMirror() {
        WebDriverManager.config().setUseMirror(true);
        if (config.getUseMirror(this.driverMirrorUrlKey).booleanValue()) {
            WebDriverManager.config().setDriverUrl(WebDriverManager.config().getDriverUrl(this.driverMirrorUrlKey));
        }
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager proxy(String proxy) {
        WebDriverManager.config().setProxy(proxy);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager proxyUser(String proxyUser) {
        WebDriverManager.config().setProxyUser(proxyUser);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager proxyPass(String proxyPass) {
        WebDriverManager.config().setProxyPass(proxyPass);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager useBetaVersions() {
        WebDriverManager.config().setUseBetaVersions(true);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager ignoreVersions(String ... versions) {
        WebDriverManager.config().setIgnoreVersions(versions);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager gitHubTokenName(String gitHubTokenName) {
        WebDriverManager.config().setGitHubTokenName(gitHubTokenName);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager gitHubTokenSecret(String gitHubTokenSecret) {
        WebDriverManager.config().setGitHubTokenSecret(gitHubTokenSecret);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager timeout(int timeout) {
        WebDriverManager.config().setTimeout(timeout);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager properties(String properties) {
        WebDriverManager.config().setProperties(properties);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager targetPath(String targetPath) {
        WebDriverManager.config().setTargetPath(targetPath);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager avoidExport() {
        WebDriverManager.config().setAvoidExport(true);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager avoidOutputTree() {
        WebDriverManager.config().setAvoidOutputTree(true);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public String getBinaryPath() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.driverManagerType)).binaryPath;
    }

    public String getDownloadedVersion() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.driverManagerType)).downloadedVersion;
    }

    public List<String> getVersions() {
        this.httpClient = new HttpClient(WebDriverManager.config().getTimeout());
        try {
            List<URL> drivers = this.getDrivers();
            List<String> driverNames = this.getDriverName();
            ArrayList<String> versions = new ArrayList<String>();
            for (URL url : drivers) {
                for (String d : driverNames) {
                    String version = this.getCurrentVersion(url, d);
                    if (version.isEmpty() || version.equalsIgnoreCase("icons")) continue;
                    if (version.startsWith(".")) {
                        version = version.substring(1);
                    }
                    if (versions.contains(version)) continue;
                    versions.add(version);
                }
            }
            log.trace("Version list before sorting {}", versions);
            Collections.sort(versions, new VersionComparator());
            return versions;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    protected String preDownload(String target, String version) {
        log.trace("Pre-download. target={}, version={}", (Object)target, (Object)version);
        return target;
    }

    protected File postDownload(File archive) {
        File[] ls;
        File parentFolder = archive.getParentFile();
        for (File f : ls = parentFolder.listFiles()) {
            if (!this.getDriverName().contains(FilenameUtils.removeExtension((String)f.getName()))) continue;
            log.trace("Found binary in post-download: {}", (Object)f);
            return f;
        }
        throw new WebDriverManagerException("Driver " + Config.listToString(this.getDriverName()) + " not found (using temporal folder " + parentFolder + ")");
    }

    protected String getCurrentVersion(URL url, String driverName) {
        String currentVersion = "";
        try {
            currentVersion = url.getFile().substring(url.getFile().indexOf(SLASH) + 1, url.getFile().lastIndexOf(SLASH));
        }
        catch (StringIndexOutOfBoundsException e) {
            log.trace("Exception getting version of URL {} ({})", (Object)url, (Object)e.getMessage());
        }
        return currentVersion;
    }

    protected void manage(Architecture arch, String version) {
        this.httpClient = new HttpClient(WebDriverManager.config().getTimeout());
        try (HttpClient wdmHttpClient = this.httpClient;){
            String versionStr;
            this.downloader = new Downloader(this.driverManagerType);
            this.urlFilter = new UrlFilter();
            boolean getLatest = version == null || version.isEmpty() || version.equalsIgnoreCase("latest");
            boolean cache = WebDriverManager.config().isForceCache() || !this.isNetAvailable();
            String driverNameString = Config.listToString(this.getDriverName());
            String os = WebDriverManager.config().getOs();
            log.trace("Managing {} arch={} version={} getLatest={} cache={}", new Object[]{driverNameString, arch, version, getLatest, cache});
            if (getLatest && this.latestVersion != null) {
                log.debug("Latest version of {} is {} (recently resolved)", (Object)driverNameString, (Object)this.latestVersion);
                version = this.latestVersion;
                cache = true;
            }
            Optional<String> driverInCache = this.handleCache(arch, version, os, getLatest, cache);
            String string = versionStr = getLatest ? "(latest version)" : version;
            if (driverInCache.isPresent() && !WebDriverManager.config().isOverride()) {
                this.versionToDownload = version;
                this.downloadedVersion = version;
                log.debug("Driver for {} {} found in cache {}", new Object[]{driverNameString, versionStr, driverInCache.get()});
                this.exportDriver(driverInCache.get());
            } else {
                List<URL> candidateUrls = this.filterCandidateUrls(arch, version, getLatest);
                if (candidateUrls.isEmpty()) {
                    String errorMessage = driverNameString + " " + versionStr + " for " + os + arch.toString() + " not found in " + WebDriverManager.config().getDriverUrl(this.driverUrlKey);
                    log.error(errorMessage);
                    throw new WebDriverManagerException(errorMessage);
                }
                this.downloadCandidateUrls(candidateUrls);
            }
        }
        catch (Exception e) {
            this.handleException(e, arch, version);
        }
    }

    protected void handleException(Exception e, Architecture arch, String version) {
        String driverNameString = Config.listToString(this.getDriverName());
        String errorMessage = String.format("There was an error managing %s %s (%s)", driverNameString, version, e.getMessage());
        if (WebDriverManager.config().isForceCache()) {
            log.error("{}", (Object)errorMessage, (Object)e);
            throw new WebDriverManagerException(e);
        }
        WebDriverManager.config().setForceCache(true);
        log.warn("{} ... trying again forcing to use cache", (Object)errorMessage, (Object)e);
        this.manage(arch, version);
    }

    protected void downloadCandidateUrls(List<URL> candidateUrls) throws IOException, InterruptedException {
        URL url = candidateUrls.iterator().next();
        String exportValue = this.downloader.download(url, this.versionToDownload, this.getDriverName());
        this.exportDriver(exportValue);
        this.downloadedVersion = this.versionToDownload;
    }

    protected List<URL> filterCandidateUrls(Architecture arch, String version, boolean getLatest) throws IOException {
        List<URL> candidateUrls;
        boolean continueSearchingVersion;
        List<URL> urls = this.getDrivers();
        log.trace("All URLs: {}", urls);
        do {
            candidateUrls = getLatest ? this.getLatest(urls, this.getDriverName()) : this.getVersion(urls, this.getDriverName(), version);
            log.trace("Candidate URLs: {}", candidateUrls);
            if (this.versionToDownload == null || this.getClass().equals(EdgeDriverManager.class)) break;
            if (!this.getDriverName().contains("IEDriverServer")) {
                candidateUrls = this.urlFilter.filterByOs(candidateUrls, WebDriverManager.config().getOs());
            }
            candidateUrls = this.urlFilter.filterByArch(candidateUrls, arch, this.forcedArch);
            candidateUrls = this.filterByDistro(candidateUrls);
            boolean bl = continueSearchingVersion = (candidateUrls = this.filterByIgnoredVersions(candidateUrls)).isEmpty() && getLatest;
            if (!continueSearchingVersion) continue;
            String driverNameString = Config.listToString(this.getDriverName());
            log.info("No binary found for {} {} ... seeking another version", (Object)driverNameString, (Object)this.versionToDownload);
            urls = this.removeFromList(urls, this.versionToDownload);
            this.versionToDownload = null;
        } while (continueSearchingVersion);
        return candidateUrls;
    }

    protected List<URL> filterByIgnoredVersions(List<URL> candidateUrls) {
        if (WebDriverManager.config().getIgnoreVersions() != null && !candidateUrls.isEmpty()) {
            candidateUrls = this.urlFilter.filterByIgnoredVersions(candidateUrls, WebDriverManager.config().getIgnoreVersions());
        }
        return candidateUrls;
    }

    protected List<URL> filterByDistro(List<URL> candidateUrls) throws IOException {
        if (WebDriverManager.config().getOs().equalsIgnoreCase("linux") && this.getDriverName().contains("phantomjs")) {
            candidateUrls = this.urlFilter.filterByDistro(candidateUrls, "2.5.0");
        }
        return candidateUrls;
    }

    protected Optional<String> handleCache(Architecture arch, String version, String os, boolean getLatest, boolean cache) {
        Optional<String> driverInCache = Optional.empty();
        if (cache || !getLatest) {
            driverInCache = this.getDriverFromCache(version, arch, os);
        }
        if (!version.isEmpty()) {
            this.versionToDownload = version;
        }
        return driverInCache;
    }

    protected Optional<String> getDriverFromCache(String driverVersion, Architecture arch, String os) {
        for (String driver : this.getDriverName()) {
            log.trace("Checking if {} exists in cache", (Object)driver);
            List<File> filesInCache = this.getFilesInCache();
            filesInCache = this.filterCacheBy(filesInCache, driverVersion);
            if (filesInCache.size() == 1) {
                return Optional.of(filesInCache.get(0).toString());
            }
            if ((filesInCache = this.filterCacheBy(filesInCache, os.toLowerCase())).size() == 1) {
                return Optional.of(filesInCache.get(0).toString());
            }
            if ((filesInCache = this.filterCacheBy(filesInCache, arch.name())).isEmpty()) continue;
            return Optional.of(filesInCache.get(0).toString());
        }
        if (log.isDebugEnabled()) {
            log.debug("{} not found in cache", (Object)Config.listToString(this.getDriverName()));
        }
        return Optional.empty();
    }

    protected List<File> filterCacheBy(List<File> input, String key) {
        ArrayList<File> output = new ArrayList<File>(input);
        if (!key.isEmpty() && !input.isEmpty()) {
            for (File f : input) {
                if (f.toString().contains(key)) continue;
                output.remove(f);
            }
        }
        log.trace("Filter cache by {} -- input list {} -- output list {} ", new Object[]{key, input, output});
        return output;
    }

    protected List<File> getFilesInCache() {
        return (List)FileUtils.listFiles((File)new File(this.downloader.getTargetPath()), null, (boolean)true);
    }

    protected boolean isNetAvailable() {
        try {
            if (!this.httpClient.isValid(WebDriverManager.config().getDriverUrl(this.driverUrlKey))) {
                log.warn("Page not available. Forcing the use of cache");
                return false;
            }
        }
        catch (IOException e) {
            log.warn("Network not available. Forcing the use of cache");
            return false;
        }
        return true;
    }

    protected List<URL> removeFromList(List<URL> list, String version) {
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version)) continue;
            out.remove(url);
        }
        return out;
    }

    protected List<URL> getVersion(List<URL> list, List<String> match, String version) {
        int i;
        ArrayList<URL> out = new ArrayList<URL>();
        if (this.getDriverName().contains("MicrosoftWebDriver") && (i = this.listVersions.indexOf(version)) != -1) {
            out.add(list.get(i));
        }
        for (String s : match) {
            for (URL url : list) {
                if (!url.getFile().contains(s) || !url.getFile().contains(version) || url.getFile().contains("-symbols")) continue;
                out.add(url);
            }
        }
        this.versionToDownload = version;
        String matchString = Config.listToString(match);
        log.debug("Using {} {}", (Object)matchString, (Object)version);
        return out;
    }

    protected List<URL> getLatest(List<URL> list, List<String> match) {
        String matchString = Config.listToString(match);
        log.trace("Checking the lastest version of {} with URL list {}", (Object)matchString, list);
        ArrayList<URL> out = new ArrayList<URL>();
        ArrayList<URL> copyOfList = new ArrayList<URL>(list);
        for (URL url : copyOfList) {
            for (String driver : match) {
                try {
                    this.handleDriver(url, driver, out);
                }
                catch (Exception e) {
                    log.trace("There was a problem with URL {} : {}", (Object)url, (Object)e.getMessage());
                    list.remove(url);
                }
            }
        }
        if (this.versionToDownload != null && this.versionToDownload.startsWith(".")) {
            this.versionToDownload = this.versionToDownload.substring(1);
        }
        this.latestVersion = this.versionToDownload;
        log.info("Latest version of {} is {}", (Object)matchString, (Object)this.versionToDownload);
        return out;
    }

    protected void handleDriver(URL url, String driver, List<URL> out) {
        if (!this.useBeta && url.getFile().toLowerCase().contains("beta")) {
            return;
        }
        if (url.getFile().contains(driver)) {
            String currentVersion = this.getCurrentVersion(url, driver);
            if (currentVersion.equalsIgnoreCase(driver)) {
                return;
            }
            if (this.versionToDownload == null) {
                this.versionToDownload = currentVersion;
            }
            if (this.versionCompare(currentVersion, this.versionToDownload) > 0) {
                this.versionToDownload = currentVersion;
                out.clear();
            }
            if (url.getFile().contains(this.versionToDownload)) {
                out.add(url);
            }
        }
    }

    protected boolean isUsingTaobaoMirror() {
        return WebDriverManager.config().getDriverUrl(this.driverUrlKey).getHost().equalsIgnoreCase("npm.taobao.org");
    }

    protected Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.replaceAll("v", "").split("\\.");
        String[] vals2 = str2.replaceAll("v", "").split("\\.");
        if (vals1[0].equals("")) {
            vals1[0] = "0";
        }
        if (vals2[0].equals("")) {
            vals2[0] = "0";
        }
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            return Integer.signum(Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i])));
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    protected List<URL> getDriversFromMirror(URL driverUrl) throws IOException {
        if (this.mirrorLog) {
            log.info("Crawling driver list from mirror {}", (Object)driverUrl);
            this.mirrorLog = true;
        } else {
            log.trace("[Recursive call] Crawling driver list from mirror {}", (Object)driverUrl);
        }
        String driverStr = driverUrl.toString();
        String driverUrlContent = driverUrl.getPath();
        HttpResponse response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl));
        try (InputStream in = response.getEntity().getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Iterator iterator = doc.select("a").iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (iterator.hasNext()) {
                String link = ((org.jsoup.nodes.Element)iterator.next()).attr("href");
                if (link.contains("mirror") && link.endsWith(SLASH)) {
                    urlList.addAll(this.getDriversFromMirror(new URL(driverStr + link.replace(driverUrlContent, ""))));
                    continue;
                }
                if (!link.startsWith(driverUrlContent) || link.contains("icons")) continue;
                urlList.add(new URL(driverStr + link.replace(driverUrlContent, "")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    protected List<URL> getDriversFromXml(URL driverUrl) throws IOException {
        String driverNameString = Config.listToString(this.getDriverName());
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)driverNameString);
        ArrayList<URL> urls = new ArrayList<URL>();
        HttpResponse response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            org.w3c.dom.Document xml = this.loadXML(reader);
            NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                urls.add(new URL(driverUrl + e.getChildNodes().item(0).getNodeValue()));
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        return urls;
    }

    protected org.w3c.dom.Document loadXML(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }

    protected void exportDriver(String variableValue) {
        if (!config.isAvoidExport()) {
            String variableName = WebDriverManager.config().getDriverExport(this.exportParameterKey);
            log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
            this.binaryPath = variableValue;
            System.setProperty(variableName, variableValue);
        } else {
            log.info("Resulting binary {}", (Object)variableValue);
        }
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        HttpGet get = this.httpClient.createHttpGet(driverUrl);
        String gitHubTokenName = WebDriverManager.config().getGitHubTokenName();
        String gitHubTokenSecret = WebDriverManager.config().getGitHubTokenSecret();
        if (!Config.isNullOrEmpty(gitHubTokenName) && !Config.isNullOrEmpty(gitHubTokenSecret)) {
            String userpass = gitHubTokenName + ":" + gitHubTokenSecret;
            String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
            get.addHeader("Authorization", basicAuth);
        }
        return this.httpClient.execute((HttpRequestBase)get).getEntity().getContent();
    }

    protected List<URL> getDriversFromGitHub() throws IOException {
        List<URL> urls;
        URL driverUrl = WebDriverManager.config().getDriverUrl(this.driverUrlKey);
        String driverNameString = Config.listToString(this.getDriverName());
        log.info("Reading {} to seek {}", (Object)driverUrl, (Object)driverNameString);
        if (this.isUsingTaobaoMirror()) {
            urls = this.getDriversFromMirror(driverUrl);
        } else {
            String driverVersion = this.versionToDownload;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                if (driverVersion != null) {
                    releaseArray = new GitHubApi[]{this.getVersion(releaseArray, driverVersion)};
                }
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            log.trace("Get version {} of {}", (Object)version, (Object)release);
            if ((release.getName() == null || !release.getName().contains(version)) && (release.getTagName() == null || !release.getTagName().contains(version))) continue;
            out = release;
            break;
        }
        return out;
    }

    protected List<String> getDriverName() {
        return this.driverName;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected FilenameFilter getFolderFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return dir.isDirectory() && name.toLowerCase().contains(WebDriverManager.this.getDriverName().get(0));
            }
        };
    }

    protected void reset() {
        WebDriverManager.config().reset();
        this.mirrorLog = false;
        this.listVersions = null;
        this.versionToDownload = null;
        this.forcedArch = false;
        this.useBeta = WebDriverManager.config().isUseBetaVersions();
    }

    public static void main(String[] args) {
        String validBrowsers = "chrome|firefox|opera|edge|phantomjs|iexplorer";
        if (args.length <= 0) {
            log.error("Usage: WebDriverManager <browserName> ... where browserName={}", (Object)validBrowsers);
        } else {
            String browser = args[0];
            log.info("Using WebDriverManager to resolve {}", (Object)browser);
            try {
                DriverManagerType driverManagerType = DriverManagerType.valueOf(browser.toUpperCase());
                WebDriverManager wdm = WebDriverManager.getInstance(driverManagerType).avoidExport().targetPath(".").forceDownload();
                if (browser.equalsIgnoreCase("edge") || browser.equalsIgnoreCase("iexplorer")) {
                    wdm.operatingSystem(OperatingSystem.WIN);
                }
                wdm.avoidOutputTree().setup();
            }
            catch (Exception e) {
                log.error("Driver for {} not found (valid browsers {})", (Object)browser, (Object)validBrowsers);
            }
        }
    }
}

