/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.VersionComparator;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

public class EdgeDriverManager
extends WebDriverManager {
    public static synchronized WebDriverManager getInstance() {
        return EdgeDriverManager.edgedriver();
    }

    public EdgeDriverManager() {
        this.driverManagerType = DriverManagerType.EDGE;
        this.exportParameterKey = "wdm.edgeDriverExport";
        this.driverVersionKey = "wdm.edgeDriverVersion";
        this.driverUrlKey = "wdm.edgeDriverUrl";
        this.driverName = Arrays.asList("MicrosoftWebDriver");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        this.listVersions = new ArrayList();
        ArrayList<URL> urlList = new ArrayList<URL>();
        URL driverUrl = EdgeDriverManager.config().getDriverUrl(this.driverUrlKey);
        log.debug("Reading {} to find out the latest version of Edge driver", (Object)driverUrl);
        try (InputStream in = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl)).getEntity().getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Elements downloadLink = doc.select("ul.driver-downloads li.driver-download > a");
            Elements versionParagraph = doc.select("ul.driver-downloads li.driver-download p.driver-download__meta");
            for (int i = 0; i < downloadLink.size(); ++i) {
                String[] version = ((Element)versionParagraph.get(i)).text().split(" ");
                String v = version[1];
                if (v.equalsIgnoreCase("version")) continue;
                this.listVersions.add(v);
                urlList.add(new URL(((Element)downloadLink.get(i)).attr("href")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    @Override
    public List<String> getVersions() {
        this.httpClient = new HttpClient(EdgeDriverManager.config().getTimeout());
        try {
            this.getDrivers();
            Collections.sort(this.listVersions, new VersionComparator());
            return this.listVersions;
        }
        catch (IOException e) {
            throw new WebDriverManagerException(e);
        }
    }

    @Override
    protected List<URL> getLatest(List<URL> list, List<String> match) {
        String matchString = Config.listToString(match);
        log.trace("Checking the lastest version of {} with URL list {}", (Object)matchString, list);
        ArrayList<URL> out = new ArrayList<URL>();
        this.versionToDownload = (String)this.listVersions.iterator().next();
        out.add(list.iterator().next());
        log.info("Latest version of MicrosoftWebDriver is {}", (Object)this.versionToDownload);
        return out;
    }
}

