/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.versions;

import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.io.File;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Shell {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private Shell() {
        throw new IllegalStateException("Utility class");
    }

    public static String runAndWait(int timeoutSeconds, String ... command) {
        return Shell.runAndWait(timeoutSeconds, true, command);
    }

    public static String runAndWait(int timeoutSeconds, File folder, String ... command) {
        return Shell.runAndWaitArray(timeoutSeconds, true, folder, command);
    }

    public static String runAndWait(int timeoutSeconds, boolean logCommand, String ... command) {
        return Shell.runAndWaitArray(timeoutSeconds, logCommand, new File("."), command);
    }

    public static String runAndWait(int timeoutSeconds, boolean logCommand, File folder, String ... command) {
        return Shell.runAndWaitArray(timeoutSeconds, logCommand, folder, command);
    }

    public static String runAndWaitArray(int timeoutSeconds, boolean logCommand, File folder, String[] command) {
        String commandStr = Arrays.toString(command);
        if (logCommand) {
            log.debug("Running command on the shell: {}", (Object)commandStr);
        }
        String result = Shell.runAndWaitNoLog(timeoutSeconds, folder, command);
        if (logCommand) {
            log.trace("Result: {}", (Object)result);
        }
        return result;
    }

    public static String runAndWaitNoLog(int timeoutSeconds, File folder, String ... command) {
        try {
            Process process = new ProcessBuilder(command).directory(folder).redirectErrorStream(false).start();
            StreamReader.consumeStderr(process);
            StreamReader stdout = StreamReader.consumeStdout(process);
            if (!process.waitFor(timeoutSeconds, TimeUnit.SECONDS)) {
                process.destroyForcibly();
                throw new WebDriverManagerException("Command timed out: " + String.join((CharSequence)" ", command));
            }
            return stdout.getOutput().trim();
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("There was a problem executing command <{}> on the shell: {}", (Object)String.join((CharSequence)" ", command), (Object)e.getMessage());
            }
            return "";
        }
    }

    private static class StreamReader
    implements Runnable {
        private final CompletableFuture<String> output = new CompletableFuture();
        private final InputStream is;
        private static final AtomicInteger id = new AtomicInteger(0);

        private StreamReader(InputStream is) {
            this.is = is;
        }

        private static StreamReader consume(InputStream is, String streamName) {
            StreamReader streamReader = new StreamReader(is);
            Thread t = new Thread((Runnable)streamReader, "streamReader-" + id.getAndIncrement() + "-" + streamName);
            t.setDaemon(true);
            t.start();
            return streamReader;
        }

        public static StreamReader consumeStdout(Process process) {
            return StreamReader.consume(process.getInputStream(), "stdout");
        }

        public static StreamReader consumeStderr(Process process) {
            return StreamReader.consume(process.getErrorStream(), "stderr");
        }

        @Override
        public void run() {
            try {
                this.output.complete(IOUtils.toString((InputStream)this.is, (Charset)StandardCharsets.UTF_8));
            }
            catch (Exception e) {
                this.output.completeExceptionally(e);
            }
        }

        public String getOutput() throws InterruptedException, ExecutionException {
            return this.output.get();
        }
    }
}

