/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.webdriver;

import com.sun.jna.platform.win32.Guid;
import com.sun.jna.platform.win32.KnownFolders;
import com.sun.jna.platform.win32.Shell32Util;
import io.github.bonigarcia.wdm.config.OperatingSystem;
import io.github.bonigarcia.wdm.docker.DockerContainer;
import io.github.bonigarcia.wdm.webdriver.Recording;
import java.lang.invoke.MethodHandles;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDriverBrowser {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String DEFAULT_DOWNLOADS_FOLDER = "Downloads";
    static final String LINUX_ENV_DOWNLOAD_DIR = "XDG_DOWNLOAD_DIR";
    static final String USER_HOME_PROPERTY = "user.home";
    static final int RECORDING_TIMEOUT_SEC = 5;
    static final int POLL_TIME_MSEC = 500;
    WebDriver driver;
    String recordingName;
    String browserName;
    OperatingSystem os;
    List<DockerContainer> dockerContainerList;
    String browserContainerId;
    String noVncUrl;
    String vncUrl;
    String seleniumServerUrl;
    Path recordingPath;
    int identityHash;

    public WebDriverBrowser(String browserName, OperatingSystem os) {
        this.browserName = browserName;
        this.os = os;
        this.dockerContainerList = new ArrayList<DockerContainer>();
    }

    public WebDriverBrowser(WebDriver driver, String browserName, OperatingSystem os) {
        this.browserName = browserName;
        this.os = os;
        this.setDriver(driver);
    }

    public WebDriver getDriver() {
        return this.driver;
    }

    public void setDriver(WebDriver driver) {
        this.driver = driver;
        this.identityHash = this.calculateIdentityHash(driver);
    }

    public List<DockerContainer> getDockerContainerList() {
        return this.dockerContainerList;
    }

    public void addDockerContainer(DockerContainer dockerContainer) {
        this.dockerContainerList.add(dockerContainer);
    }

    public void addDockerContainer(DockerContainer dockerContainer, int position) {
        this.dockerContainerList.add(position, dockerContainer);
    }

    public String getBrowserContainerId() {
        return this.browserContainerId;
    }

    public void setBrowserContainerId(String browserContainerId) {
        this.browserContainerId = browserContainerId;
    }

    public URL getNoVncUrl() {
        return this.getUrl(this.noVncUrl);
    }

    public void setNoVncUrl(String noVncUrl) {
        this.noVncUrl = noVncUrl;
    }

    public String getVncUrl() {
        return this.vncUrl;
    }

    public void setVncUrl(String vncUrl) {
        this.vncUrl = vncUrl;
    }

    public URL getSeleniumServerUrl() {
        return this.getUrl(this.seleniumServerUrl);
    }

    public void setSeleniumServerUrl(String seleniumServerUrl) {
        this.seleniumServerUrl = seleniumServerUrl;
    }

    protected URL getUrl(String urlStr) {
        URL url = null;
        try {
            url = new URL(urlStr);
        }
        catch (MalformedURLException e) {
            this.log.error("Exception creating URL", (Throwable)e);
        }
        return url;
    }

    public Path getRecordingPath() {
        return this.recordingPath;
    }

    public void setRecordingPath(Path recordingPath) {
        this.recordingPath = recordingPath;
    }

    public int getIdentityHash() {
        return this.identityHash;
    }

    public int calculateIdentityHash(Object object) {
        return System.identityHashCode(object);
    }

    public List<Map<String, Object>> readLogs() {
        return (List)this.readJavaScriptVariable("console._bwLogs");
    }

    public Object readJavaScriptVariable(String jsVariable) {
        return this.executeJavaScript("return " + jsVariable + ";");
    }

    public Object executeJavaScript(String jsCommand) {
        return ((JavascriptExecutor)this.driver).executeScript(jsCommand, new Object[0]);
    }

    public void startRecording() {
        this.startRecording(Recording.getRecordingName(this.browserName, ((RemoteWebDriver)this.driver).getSessionId().toString()));
    }

    public void startRecording(String recordingName) {
        this.setRecordingName(recordingName);
        ((JavascriptExecutor)this.driver).executeScript("window.postMessage({ type: \"startRecording\", name: \"" + recordingName + "\" }, \"*\");", new Object[0]);
    }

    public void stopRecording() {
        ((JavascriptExecutor)this.driver).executeScript("window.postMessage({ type: \"stopRecording\" }, \"*\");", new Object[0]);
        this.waitForRecording();
    }

    public Path getDownloadsFolderPath() {
        String xdgDownloadDir;
        Path downloadsPath = this.os.isWin() ? Paths.get(Shell32Util.getKnownFolderPath((Guid.GUID)KnownFolders.FOLDERID_Downloads), new String[0]) : (this.os.isMac() ? Paths.get(System.getProperty(USER_HOME_PROPERTY), DEFAULT_DOWNLOADS_FOLDER) : ((xdgDownloadDir = System.getenv(LINUX_ENV_DOWNLOAD_DIR)) != null && !xdgDownloadDir.isEmpty() ? Paths.get(xdgDownloadDir, new String[0]) : Paths.get(System.getProperty(USER_HOME_PROPERTY), DEFAULT_DOWNLOADS_FOLDER)));
        return downloadsPath;
    }

    public boolean waitForRecording() {
        Path downloadsPath = this.getDownloadsFolderPath();
        Path filePath = Paths.get(downloadsPath.toString(), this.getRecordingName());
        Instant start = Instant.now();
        Duration timeout = Duration.ofSeconds(5L);
        this.log.trace("Waiting for recording at {}", (Object)filePath);
        while (true) {
            if (Files.exists(filePath, new LinkOption[0])) {
                this.log.debug("Recording found at {}", (Object)filePath);
                this.setRecordingPath(filePath);
                return true;
            }
            if (Duration.between(start, Instant.now()).compareTo(timeout) > 0) {
                this.log.warn("Timeout of {} seconds reached, recording {} not found", (Object)5, (Object)filePath);
                return false;
            }
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public String getRecordingName() {
        return this.recordingName + ".webm";
    }

    public void setRecordingName(String recordingName) {
        this.recordingName = recordingName;
    }
}

