/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.online;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import io.github.bonigarcia.wdm.online.HttpClient;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.stream.Collectors;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Parser {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private Parser() {
        throw new IllegalStateException("Utility class");
    }

    public static <T> T parseJson(HttpClient client, String url, Class<T> klass) throws IOException {
        HttpGet get = client.createHttpGet(new URL(url));
        InputStream content = client.execute((ClassicHttpRequest)get).getEntity().getContent();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(content));){
            Object object;
            String lines = reader.lines().collect(Collectors.joining());
            try {
                object = new GsonBuilder().create().fromJson(lines, klass);
            }
            catch (JsonSyntaxException cause) {
                throw new WebDriverManagerException("Bad JSON. First 100 chars " + lines.substring(0, 100), cause);
            }
            return (T)object;
        }
    }
}

