/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm.config;

import io.github.bonigarcia.wdm.config.WebDriverManagerException;
import java.util.Locale;

public enum DriverManagerType {
    CHROME("org.openqa.selenium.chrome.ChromeDriver"),
    FIREFOX("org.openqa.selenium.firefox.FirefoxDriver"),
    OPERA("org.openqa.selenium.opera.OperaDriver"),
    EDGE("org.openqa.selenium.edge.EdgeDriver"),
    IEXPLORER("org.openqa.selenium.ie.InternetExplorerDriver"),
    CHROMIUM("org.openqa.selenium.chrome.ChromeDriver"),
    SAFARI("org.openqa.selenium.safari.SafariDriver");

    String browserClass;

    private DriverManagerType(String browserClass) {
        this.browserClass = browserClass;
    }

    public String browserClass() {
        return this.browserClass;
    }

    public String getNameLowerCase() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public String getBrowserName() {
        switch (this) {
            case CHROME: {
                return "Chrome";
            }
            case CHROMIUM: {
                return "Chromium";
            }
            case FIREFOX: {
                return "Firefox";
            }
            case OPERA: {
                return "Opera";
            }
            case EDGE: {
                return "Edge";
            }
            case IEXPLORER: {
                return "Internet Explorer";
            }
            case SAFARI: {
                return "Safari";
            }
        }
        throw new WebDriverManagerException("Invalid driver manager type: " + this.name());
    }

    public String getBrowserNameLowerCase() {
        return this.getBrowserName().toLowerCase(Locale.ROOT);
    }

    public static DriverManagerType valueOfDisplayName(String displayName) {
        return DriverManagerType.valueOf(displayName.substring(displayName.indexOf("=") + 1).toUpperCase());
    }
}

