/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.WebDriverManager;
import io.javalin.Javalin;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WdmServer {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public WdmServer(int port) {
        Javalin app = Javalin.create().start(port);
        Handler handler = this::handleRequest;
        app.get("/chromedriver", handler);
        app.get("/firefoxdriver", handler);
        app.get("/edgedriver", handler);
        app.get("/iedriver", handler);
        app.get("/operadriver", handler);
        app.get("/phantomjs", handler);
        app.get("/selenium-server-standalone", handler);
        this.log.info("WebDriverManager server listening on port {}", (Object)port);
    }

    private void handleRequest(Context ctx) throws IOException {
        String requestMethod = ctx.method();
        String requestPath = ctx.path();
        this.log.info("Server request: {} {}", (Object)requestMethod, (Object)requestPath);
        Optional<WebDriverManager> driverManager = this.createDriverManager(requestPath);
        if (driverManager.isPresent()) {
            this.resolveDriver(ctx, driverManager.get());
        }
    }

    private Optional<WebDriverManager> createDriverManager(String requestPath) {
        Optional<WebDriverManager> out;
        switch (requestPath.substring(1)) {
            case "chromedriver": {
                out = Optional.of(WebDriverManager.chromedriver());
                break;
            }
            case "firefoxdriver": {
                out = Optional.of(WebDriverManager.firefoxdriver());
                break;
            }
            case "edgedriver": {
                out = Optional.of(WebDriverManager.edgedriver());
                break;
            }
            case "iedriver": {
                out = Optional.of(WebDriverManager.iedriver());
                break;
            }
            case "operadriver": {
                out = Optional.of(WebDriverManager.operadriver());
                break;
            }
            case "phantomjs": {
                out = Optional.of(WebDriverManager.phantomjs());
                break;
            }
            case "selenium-server-standalone": {
                out = Optional.of(WebDriverManager.seleniumServerStandalone());
                break;
            }
            default: {
                this.log.warn("Unknown option {}", (Object)requestPath);
                out = Optional.empty();
            }
        }
        return out;
    }

    private synchronized void resolveDriver(Context ctx, WebDriverManager driverManager) throws IOException {
        TreeMap<String, List<String>> queryParamMap = new TreeMap<String, List<String>>(ctx.queryParamMap());
        if (driverManager.getDriverName().equals("msedgedriver") && !queryParamMap.containsKey("os")) {
            System.setProperty("wdm.os", "WIN");
            queryParamMap.put("os", Collections.singletonList("WIN"));
        }
        if (!queryParamMap.isEmpty()) {
            this.log.info("Server query string for configuration {}", queryParamMap);
            for (Map.Entry entry : queryParamMap.entrySet()) {
                String configKey = "wdm." + (String)entry.getKey();
                String configValue = (String)((List)entry.getValue()).get(0);
                this.log.trace("\t{} = {}", (Object)configKey, (Object)configValue);
                System.setProperty(configKey, configValue);
            }
        }
        driverManager.config().setAvoidExport(true);
        driverManager.config().setAvoidBrowserDetection(true);
        driverManager.setup();
        File driver = new File(driverManager.getDownloadedDriverPath());
        String driverVersion = driverManager.getDownloadedDriverVersion();
        String driverName = driver.getName();
        String driverLength = String.valueOf(driver.length());
        ctx.res.setHeader("Content-Disposition", "attachment; filename=\"" + driverName + "\"");
        ctx.result((InputStream)FileUtils.openInputStream((File)driver));
        this.log.info("Server response: {} {} ({} bytes)", new Object[]{driverName, driverVersion, driverLength});
        for (String key : queryParamMap.keySet()) {
            System.clearProperty("wdm." + key);
        }
    }
}

