/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.Config;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.Closeable;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLDecoder;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import java.util.StringTokenizer;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.ssl.TrustStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClient
implements Closeable {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    CloseableHttpClient closeableHttpClient;
    int timeout;

    public HttpClient(int timeout) {
        this();
        this.timeout = (int)TimeUnit.SECONDS.toMillis(timeout);
    }

    public HttpClient() {
        HttpClientBuilder builder = HttpClientBuilder.create().setConnectionManagerShared(true);
        try {
            String proxy = WebDriverManager.config().getProxy();
            Optional<HttpHost> proxyHost = this.createProxyHttpHost(proxy);
            if (proxyHost.isPresent()) {
                builder.setProxy(proxyHost.get());
                Optional<BasicCredentialsProvider> credentialsProvider = this.createBasicCredentialsProvider(proxy, WebDriverManager.config().getProxyUser(), WebDriverManager.config().getProxyPass(), proxyHost.get());
                if (credentialsProvider.isPresent()) {
                    builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider.get());
                }
            }
            HostnameVerifier allHostsValid = (hostname, session) -> hostname.equalsIgnoreCase(session.getPeerHost());
            SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustStrategy(){

                public boolean isTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    return true;
                }
            }).build();
            SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, allHostsValid);
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)sslsf).register("http", (Object)new PlainConnectionSocketFactory()).build();
            PoolingHttpClientConnectionManager cm = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            builder.setConnectionManager((HttpClientConnectionManager)cm);
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        this.closeableHttpClient = builder.useSystemProperties().build();
    }

    public Optional<Proxy> createProxy(String proxy) throws MalformedURLException {
        Optional<URL> url = this.determineProxyUrl(proxy);
        if (url.isPresent()) {
            String proxyHost = url.get().getHost();
            int proxyPort = url.get().getPort() == -1 ? 80 : url.get().getPort();
            return Optional.of(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort)));
        }
        return Optional.empty();
    }

    public HttpGet createHttpGet(URL url) {
        HttpGet httpGet = new HttpGet(url.toString());
        httpGet.addHeader("User-Agent", "Mozilla/5.0");
        httpGet.addHeader("Connection", "keep-alive");
        RequestConfig requestConfig = RequestConfig.custom().setCookieSpec("standard").setSocketTimeout(this.timeout).build();
        httpGet.setConfig(requestConfig);
        return httpGet;
    }

    public HttpResponse execute(HttpRequestBase method) throws IOException {
        CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)method);
        if (response.getStatusLine().getStatusCode() >= 400) {
            String errorMessage = "A response error is detected: " + response.getStatusLine();
            this.log.error(errorMessage);
            throw new WebDriverManagerException(errorMessage);
        }
        return response;
    }

    public boolean isValid(URL url) throws IOException {
        CloseableHttpResponse response = this.closeableHttpClient.execute((HttpUriRequest)new HttpOptions(url.toString()));
        if (response.getStatusLine().getStatusCode() > 401) {
            this.log.debug("A response error is detected. {}", (Object)response.getStatusLine());
            return false;
        }
        return true;
    }

    private Optional<URL> determineProxyUrl(String proxy) throws MalformedURLException {
        String proxyInput;
        String string = proxyInput = Config.isNullOrEmpty(proxy) ? System.getenv("HTTPS_PROXY") : proxy;
        if (!Config.isNullOrEmpty(proxyInput)) {
            return Optional.of(new URL(proxyInput.matches("^http[s]?://.*$") ? proxyInput : "http://" + proxyInput));
        }
        return Optional.empty();
    }

    private final Optional<HttpHost> createProxyHttpHost(String proxyUrl) throws MalformedURLException {
        Optional<Proxy> proxy = this.createProxy(proxyUrl);
        if (proxy.isPresent() && proxy.get().address() != null) {
            if (!(proxy.get().address() instanceof InetSocketAddress)) {
                String errorMessage = "Detect an unsupported subclass of SocketAddress. Please use the InetSocketAddress or subclass. Actual:" + proxy.get().address().getClass();
                this.log.error(errorMessage);
                throw new WebDriverManagerException(errorMessage);
            }
            InetSocketAddress proxyAddress = (InetSocketAddress)proxy.get().address();
            return Optional.of(new HttpHost(proxyAddress.getHostName(), proxyAddress.getPort()));
        }
        return Optional.empty();
    }

    private final Optional<BasicCredentialsProvider> createBasicCredentialsProvider(String proxy, String proxyUser, String proxyPass, HttpHost proxyHost) throws MalformedURLException, UnsupportedEncodingException {
        Optional<URL> proxyUrl = this.determineProxyUrl(proxy);
        if (!proxyUrl.isPresent()) {
            return Optional.empty();
        }
        String username = null;
        String password = null;
        String userInfo = proxyUrl.get().getUserInfo();
        if (userInfo != null) {
            StringTokenizer st = new StringTokenizer(userInfo, ":");
            username = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
            password = st.hasMoreTokens() ? URLDecoder.decode(st.nextToken(), StandardCharsets.UTF_8.name()) : null;
        }
        String envProxyUser = System.getenv("HTTPS_PROXY_USER");
        String envProxyPass = System.getenv("HTTPS_PROXY_PASS");
        username = envProxyUser != null ? envProxyUser : username;
        password = envProxyPass != null ? envProxyPass : password;
        username = proxyUser != null ? proxyUser : username;
        String string = password = proxyPass != null ? proxyPass : password;
        if (username == null) {
            return Optional.empty();
        }
        String ntlmUsername = username;
        String ntlmDomain = null;
        int index = username.indexOf(92);
        if (index > 0) {
            ntlmDomain = username.substring(0, index);
            ntlmUsername = username.substring(index + 1);
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        AuthScope authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort(), AuthScope.ANY_REALM, "NTLM");
        NTCredentials creds = new NTCredentials(ntlmUsername, password, this.getWorkstation(), ntlmDomain);
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        authScope = new AuthScope(proxyHost.getHostName(), proxyHost.getPort());
        creds = new UsernamePasswordCredentials(username, password);
        credentialsProvider.setCredentials(authScope, (Credentials)creds);
        return Optional.of(credentialsProvider);
    }

    private String getWorkstation() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        if (env.containsKey("HOSTNAME")) {
            return env.get("HOSTNAME");
        }
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException ex) {
            return null;
        }
    }

    @Override
    public void close() throws IOException {
        this.closeableHttpClient.close();
    }
}

