/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.Architecture;
import io.github.bonigarcia.wdm.ChromeDriverManager;
import io.github.bonigarcia.wdm.Downloader;
import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.DriverVersion;
import io.github.bonigarcia.wdm.EdgeDriverManager;
import io.github.bonigarcia.wdm.FirefoxDriverManager;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.HttpClient;
import io.github.bonigarcia.wdm.InternetExplorerDriverManager;
import io.github.bonigarcia.wdm.OperaDriverManager;
import io.github.bonigarcia.wdm.OperativeSystem;
import io.github.bonigarcia.wdm.PhantomJsDriverManager;
import io.github.bonigarcia.wdm.UrlFilter;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WebDriverManagerException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class WebDriverManager {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final String SLASH = "/";
    protected static Map<DriverManagerType, WebDriverManager> instanceMap = new EnumMap<DriverManagerType, WebDriverManager>(DriverManagerType.class);
    protected DriverManagerType driverManagerType;
    protected String myOsName = this.defaultOsName();
    protected boolean useBetaVersions = false;
    protected boolean mirrorLog = false;
    protected boolean isForcingCache = false;
    protected boolean isForcingDownload = false;
    protected List<String> listVersions;
    protected List<String> driverName;
    protected Architecture architecture;
    protected HttpClient httpClient;
    protected Downloader downloader;
    protected UrlFilter urlFilter;
    protected URL driverUrl;
    protected String versionToDownload;
    protected String downloadedVersion;
    protected String version;
    protected String proxyValue;
    protected String binaryPath;
    protected String proxyUser;
    protected String proxyPass;
    protected String exportParameter;
    protected String driverVersionKey;
    protected String driverUrlKey;
    protected String driverMirrorUrlKey;
    protected String[] ignoredVersions;

    protected abstract List<URL> getDrivers() throws IOException;

    public static synchronized WebDriverManager chromedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.CHROME)) {
            instanceMap.put(DriverManagerType.CHROME, new ChromeDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.CHROME);
    }

    public static synchronized WebDriverManager firefoxdriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.FIREFOX)) {
            instanceMap.put(DriverManagerType.FIREFOX, new FirefoxDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.FIREFOX);
    }

    public static synchronized WebDriverManager operadriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.OPERA)) {
            instanceMap.put(DriverManagerType.OPERA, new OperaDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.OPERA);
    }

    public static synchronized WebDriverManager edgedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.EDGE)) {
            instanceMap.put(DriverManagerType.EDGE, new EdgeDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.EDGE);
    }

    public static synchronized WebDriverManager iedriver() {
        if (!instanceMap.containsKey((Object)DriverManagerType.IEXPLORER)) {
            instanceMap.put(DriverManagerType.IEXPLORER, new InternetExplorerDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.IEXPLORER);
    }

    public static synchronized WebDriverManager phantomjs() {
        if (!instanceMap.containsKey((Object)DriverManagerType.PHANTOMJS)) {
            instanceMap.put(DriverManagerType.PHANTOMJS, new PhantomJsDriverManager());
        }
        return instanceMap.get((Object)DriverManagerType.PHANTOMJS);
    }

    public static synchronized WebDriverManager getInstance(DriverManagerType driverManagerType) {
        if (driverManagerType == null) {
            return WebDriverManager.voiddriver();
        }
        switch (driverManagerType) {
            case CHROME: {
                return WebDriverManager.chromedriver();
            }
            case FIREFOX: {
                return WebDriverManager.firefoxdriver();
            }
            case OPERA: {
                return WebDriverManager.operadriver();
            }
            case IEXPLORER: {
                return WebDriverManager.iedriver();
            }
            case EDGE: {
                return WebDriverManager.edgedriver();
            }
            case PHANTOMJS: {
                return WebDriverManager.phantomjs();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public static synchronized WebDriverManager getInstance(Class<?> webDriverClass) {
        switch (webDriverClass.getName()) {
            case "org.openqa.selenium.chrome.ChromeDriver": {
                return WebDriverManager.chromedriver();
            }
            case "org.openqa.selenium.firefox.FirefoxDriver": {
                return WebDriverManager.firefoxdriver();
            }
            case "org.openqa.selenium.opera.OperaDriver": {
                return WebDriverManager.operadriver();
            }
            case "org.openqa.selenium.ie.InternetExplorerDriver": {
                return WebDriverManager.iedriver();
            }
            case "org.openqa.selenium.edge.EdgeDriver": {
                return WebDriverManager.edgedriver();
            }
            case "org.openqa.selenium.phantomjs.PhantomJSDriver": {
                return WebDriverManager.phantomjs();
            }
        }
        return WebDriverManager.voiddriver();
    }

    public synchronized void setup() {
        if (this.driverManagerType != null) {
            String driverVersion = this.getDriverVersion();
            this.manage(this.getDefaultArchitecture(), WdmConfig.isNullOrEmpty(driverVersion) ? DriverVersion.NOT_SPECIFIED.name() : driverVersion);
            this.reset();
        }
    }

    public WebDriverManager version(String version) {
        this.version = version;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager architecture(Architecture architecture) {
        this.architecture = architecture;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager arch32() {
        this.architecture(Architecture.X32);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager arch64() {
        this.architecture(Architecture.X64);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager operativeSystem(OperativeSystem os) {
        this.myOsName = os.name();
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager forceCache() {
        this.isForcingCache = true;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager forceDownload() {
        this.isForcingDownload = true;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager driverRepositoryUrl(URL url) {
        this.driverUrl = url;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager useMirror() {
        if (WdmConfig.isNullOrEmpty(this.driverMirrorUrlKey)) {
            throw new WebDriverManagerException("Mirror URL not available for " + this.getDriverName());
        }
        this.driverUrl = WdmConfig.getUrl(this.driverMirrorUrlKey);
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager proxy(String proxy) {
        this.proxyValue = proxy;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager proxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager proxyPass(String proxyPass) {
        this.proxyPass = proxyPass;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager useBetaVersions() {
        this.useBetaVersions = true;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public WebDriverManager ignoreVersions(String ... versions) {
        this.ignoredVersions = versions;
        return instanceMap.get((Object)this.driverManagerType);
    }

    public String getBinaryPath() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.driverManagerType)).binaryPath;
    }

    public String getDownloadedVersion() {
        return WebDriverManager.instanceMap.get((Object)((Object)this.driverManagerType)).downloadedVersion;
    }

    protected static synchronized WebDriverManager voiddriver() {
        return new WebDriverManager(){

            @Override
            protected List<URL> getDrivers() throws IOException {
                return Collections.emptyList();
            }
        };
    }

    protected String getDriverVersion() {
        return this.version == null ? WdmConfig.getString(this.getDriverVersionKey()) : this.version;
    }

    protected URL getDriverUrl() {
        return this.driverUrl == null ? WdmConfig.getUrl(this.getDriverUrlKey()) : this.driverUrl;
    }

    protected String preDownload(String target, String version) {
        this.log.trace("Pre-download. target={}, version={}", (Object)target, (Object)version);
        return target;
    }

    protected File postDownload(File archive) {
        File[] ls;
        File target = archive;
        for (File f : ls = archive.getParentFile().listFiles()) {
            if (!this.isExecutable(f)) continue;
            target = f;
            this.log.trace("Found binary in post-download: {}", (Object)target);
            break;
        }
        return target;
    }

    protected String getCurrentVersion(URL url, String driverName) {
        return url.getFile().substring(url.getFile().indexOf(SLASH) + 1, url.getFile().lastIndexOf(SLASH));
    }

    protected void manage(Architecture arch, String version) {
        this.httpClient = new HttpClient(this.proxyValue, this.proxyUser, this.proxyPass);
        try (HttpClient wdmHttpClient = this.httpClient;){
            this.downloader = new Downloader(this.driverManagerType);
            this.urlFilter = new UrlFilter();
            this.updateValuesWithConfig();
            boolean getLatest = version == null || version.isEmpty() || version.equalsIgnoreCase(DriverVersion.LATEST.name()) || version.equalsIgnoreCase(DriverVersion.NOT_SPECIFIED.name());
            boolean cache = this.isForcingCache || WdmConfig.getBoolean("wdm.forceCache") || !this.isNetAvailable();
            this.log.trace(">> Managing {} arch={} version={} getLatest={} cache={}", new Object[]{this.getDriverName(), arch, version, getLatest, cache});
            Optional<String> driverInCache = this.handleCache(arch, version, getLatest, cache);
            if (driverInCache.isPresent()) {
                this.versionToDownload = version;
                this.downloadedVersion = version;
                this.log.debug("Driver for {} {} found in cache {}", new Object[]{this.getDriverName(), this.versionToDownload, driverInCache.get()});
                this.exportDriver(this.getExportParameter(), driverInCache.get());
            } else {
                List<URL> candidateUrls = this.filterCandidateUrls(arch, version, getLatest);
                if (candidateUrls.isEmpty()) {
                    String versionStr = getLatest ? "(latest version)" : version;
                    String errorMessage = this.getDriverName() + " " + versionStr + " for " + this.myOsName + arch.toString() + " not found in " + this.getDriverUrl();
                    this.log.error(errorMessage);
                    throw new WebDriverManagerException(errorMessage);
                }
                this.downloadCandidateUrls(candidateUrls);
            }
        }
        catch (Exception e) {
            this.handleException(e, arch, version);
        }
    }

    protected void updateValuesWithConfig() {
        String wdmProxyPass;
        String wdmProxyUser;
        String wdmProxy;
        String wdmOs = WdmConfig.getString("wdm.os");
        if (!wdmOs.equals("")) {
            this.myOsName = wdmOs;
        }
        if (!(wdmProxy = WdmConfig.getString("wdm.proxy")).equals("")) {
            this.proxyValue = wdmProxy;
        }
        if (!(wdmProxyUser = WdmConfig.getString("wdm.proxyUser")).equals("")) {
            this.proxyUser = wdmProxyUser;
        }
        if (!(wdmProxyPass = WdmConfig.getString("wdm.proxyPass")).equals("")) {
            this.proxyPass = wdmProxyPass;
        }
        if (WdmConfig.getBoolean("wdm.useMirror")) {
            this.useMirror();
        }
    }

    protected void handleException(Exception e, Architecture arch, String version) {
        if (this.isForcingCache) {
            throw new WebDriverManagerException(e);
        }
        this.isForcingCache = true;
        this.log.warn("There was an error managing {} {} ({}) ... trying again forcing to use cache", new Object[]{this.getDriverName(), version, e.getMessage()});
        this.manage(arch, version);
    }

    protected void downloadCandidateUrls(List<URL> candidateUrls) throws IOException, InterruptedException {
        Collections.reverse(candidateUrls);
        URL url = candidateUrls.iterator().next();
        String export = candidateUrls.contains(url) ? this.getExportParameter() : null;
        Optional<String> exportValue = this.downloader.download(url, this.versionToDownload, export, this.getDriverName());
        if (exportValue.isPresent()) {
            this.exportDriver(export, exportValue.get());
            this.downloadedVersion = this.versionToDownload;
        }
    }

    protected List<URL> filterCandidateUrls(Architecture arch, String version, boolean getLatest) throws IOException {
        List<URL> candidateUrls;
        boolean continueSearchingVersion;
        List<URL> urls = this.getDrivers();
        this.log.trace("All URLs: {}", urls);
        do {
            candidateUrls = getLatest ? this.getLatest(urls, this.getDriverName()) : this.getVersion(urls, this.getDriverName(), version);
            this.log.trace("Candidate URLs: {}", candidateUrls);
            if (this.versionToDownload == null || this.getClass().equals(EdgeDriverManager.class)) break;
            candidateUrls = this.urlFilter.filterByOs(candidateUrls, this.myOsName);
            candidateUrls = this.urlFilter.filterByArch(candidateUrls, arch);
            if (this.myOsName.equalsIgnoreCase("linux") && this.getDriverName().contains("phantomjs")) {
                candidateUrls = this.urlFilter.filterByDistro(candidateUrls, "2.5.0");
            }
            if (this.ignoredVersions != null) {
                candidateUrls = this.urlFilter.filterByIgnoredVersions(candidateUrls, this.ignoredVersions);
            }
            boolean bl = continueSearchingVersion = candidateUrls.isEmpty() && getLatest;
            if (!continueSearchingVersion) continue;
            this.log.info("No binary found for {} {} ... seeking another version", this.getDriverName(), (Object)this.versionToDownload);
            urls = this.removeFromList(urls, this.versionToDownload);
            this.versionToDownload = null;
        } while (continueSearchingVersion);
        return candidateUrls;
    }

    protected Optional<String> handleCache(Architecture arch, String version, boolean getLatest, boolean cache) {
        Optional<String> driverInCache = Optional.empty();
        if (cache) {
            driverInCache = this.forceCache(this.downloader.getTargetPath());
        } else if (!getLatest) {
            this.versionToDownload = version;
            driverInCache = this.existsDriverInCache(this.downloader.getTargetPath(), version, arch);
        }
        return driverInCache;
    }

    protected Optional<String> forceCache(String repository) {
        String driverInCache = null;
        for (String driver : this.getDriverName()) {
            this.log.trace("Checking if {} exists in cache {}", (Object)driver, (Object)repository);
            Collection listFiles = FileUtils.listFiles((File)new File(repository), null, (boolean)true);
            Object[] array = listFiles.toArray();
            Arrays.sort(array, Collections.reverseOrder());
            for (Object f : array) {
                driverInCache = f.toString();
                this.log.trace("Checking {}", (Object)driverInCache);
                if (!driverInCache.contains(driver) || !this.isExecutable(new File(driverInCache))) continue;
                this.log.info("Found {} in cache: {} ", (Object)driver, (Object)driverInCache);
                return Optional.of(driverInCache);
            }
        }
        return Optional.empty();
    }

    protected Optional<String> existsDriverInCache(String repository, String driverVersion, Architecture arch) {
        String driverInCache = null;
        for (String driver : this.getDriverName()) {
            this.log.trace("Checking if {} {} ({} bits) exists in cache {}", new Object[]{driver, driverVersion, arch, repository});
            Collection listFiles = FileUtils.listFiles((File)new File(repository), null, (boolean)true);
            Object[] array = listFiles.toArray();
            Arrays.sort(array, Collections.reverseOrder());
            for (Object f : array) {
                driverInCache = f.toString();
                boolean checkArchitecture = !this.shouldCheckArchitecture() || driverInCache.contains(arch.toString());
                this.log.trace("Checking {}", (Object)driverInCache);
                if (!driverInCache.contains(driverVersion) || !driverInCache.contains(driver) || !checkArchitecture || !this.isExecutable(new File(driverInCache))) continue;
                this.log.debug("Found {} {} ({} bits) in cache: {}", new Object[]{driverVersion, driver, arch, driverInCache});
                return Optional.of(driverInCache);
            }
        }
        return Optional.empty();
    }

    protected boolean isExecutable(File file) {
        return this.myOsName.equalsIgnoreCase("win") ? file.getName().toLowerCase().endsWith(".exe") : file.canExecute();
    }

    protected boolean shouldCheckArchitecture() {
        return true;
    }

    protected boolean isNetAvailable() {
        try {
            if (!this.httpClient.isValid(this.getDriverUrl())) {
                this.log.warn("Page not available. Forcing the use of cache");
                return false;
            }
        }
        catch (IOException e) {
            this.log.warn("Network not available. Forcing the use of cache");
            return false;
        }
        return true;
    }

    protected List<URL> removeFromList(List<URL> list, String version) {
        ArrayList<URL> out = new ArrayList<URL>(list);
        for (URL url : list) {
            if (!url.getFile().contains(version)) continue;
            out.remove(url);
        }
        return out;
    }

    protected List<URL> getVersion(List<URL> list, List<String> match, String version) {
        int i;
        ArrayList<URL> out = new ArrayList<URL>();
        if (this.getDriverName().contains("MicrosoftWebDriver") && (i = this.listVersions.indexOf(version)) != -1) {
            out.add(list.get(i));
        }
        for (String s : match) {
            Collections.reverse(list);
            for (URL url : list) {
                if (!url.getFile().contains(s) || !url.getFile().contains(version) || url.getFile().contains("-symbols")) continue;
                out.add(url);
            }
        }
        this.versionToDownload = version;
        this.log.debug("Using {} {}", match, (Object)version);
        return out;
    }

    protected List<URL> getLatest(List<URL> list, List<String> match) {
        this.log.trace("Checking the lastest version of {} with URL list {}", match, list);
        ArrayList<URL> out = new ArrayList<URL>();
        Collections.reverse(list);
        ArrayList<URL> copyOfList = new ArrayList<URL>(list);
        for (URL url : copyOfList) {
            for (String driver : match) {
                try {
                    this.handleDriver(url, driver, out);
                }
                catch (Exception e) {
                    this.log.trace("There was a problem with URL {} : {}", (Object)url.toString(), (Object)e.getMessage());
                    list.remove(url);
                }
            }
        }
        if (this.versionToDownload.startsWith(".")) {
            this.versionToDownload = this.versionToDownload.substring(1);
        }
        this.log.info("Latest version of {} is {}", match, (Object)this.versionToDownload);
        return out;
    }

    protected void handleDriver(URL url, String driver, List<URL> out) {
        if (!this.useBetaVersions && !WdmConfig.getBoolean("wdm.useBetaVersions") && url.getFile().toLowerCase().contains("beta")) {
            return;
        }
        if (url.getFile().contains(driver)) {
            String currentVersion = this.getCurrentVersion(url, driver);
            if (currentVersion.equalsIgnoreCase(driver)) {
                return;
            }
            if (this.versionToDownload == null) {
                this.versionToDownload = currentVersion;
            }
            if (this.versionCompare(currentVersion, this.versionToDownload) > 0) {
                this.versionToDownload = currentVersion;
                out.clear();
            }
            if (url.getFile().contains(this.versionToDownload)) {
                out.add(url);
            }
        }
    }

    protected boolean isUsingTaobaoMirror() {
        return this.getDriverUrl().getHost().equalsIgnoreCase("npm.taobao.org");
    }

    protected Integer versionCompare(String str1, String str2) {
        int i;
        String[] vals1 = str1.replaceAll("v", "").split("\\.");
        String[] vals2 = str2.replaceAll("v", "").split("\\.");
        if (vals1[0].equals("")) {
            vals1[0] = "0";
        }
        if (vals2[0].equals("")) {
            vals2[0] = "0";
        }
        for (i = 0; i < vals1.length && i < vals2.length && vals1[i].equals(vals2[i]); ++i) {
        }
        if (i < vals1.length && i < vals2.length) {
            return Integer.signum(Integer.valueOf(vals1[i]).compareTo(Integer.valueOf(vals2[i])));
        }
        return Integer.signum(vals1.length - vals2.length);
    }

    protected List<URL> getDriversFromMirror(URL driverUrl) throws IOException {
        if (!this.mirrorLog) {
            this.log.info("Crawling driver list from mirror {}", (Object)driverUrl);
            this.mirrorLog = true;
        } else {
            this.log.trace("[Recursive call] Crawling driver list from mirror {}", (Object)driverUrl);
        }
        String driverStr = driverUrl.toString();
        String driverUrlContent = driverUrl.getPath();
        HttpResponse response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl));
        try (InputStream in = response.getEntity().getContent();){
            Document doc = Jsoup.parse((InputStream)in, null, (String)"");
            Iterator iterator = doc.select("a").iterator();
            ArrayList<URL> urlList = new ArrayList<URL>();
            while (iterator.hasNext()) {
                String link = ((org.jsoup.nodes.Element)iterator.next()).attr("href");
                if (link.contains("mirror") && link.endsWith(SLASH)) {
                    urlList.addAll(this.getDriversFromMirror(new URL(driverStr + link.replace(driverUrlContent, ""))));
                    continue;
                }
                if (!link.startsWith(driverUrlContent) || link.contains("icons")) continue;
                urlList.add(new URL(driverStr + link.replace(driverUrlContent, "")));
            }
            ArrayList<URL> arrayList = urlList;
            return arrayList;
        }
    }

    protected List<URL> getDriversFromXml(URL driverUrl) throws IOException {
        this.log.info("Reading {} to seek {}", (Object)driverUrl, this.getDriverName());
        ArrayList<URL> urls = new ArrayList<URL>();
        HttpResponse response = this.httpClient.execute((HttpRequestBase)this.httpClient.createHttpGet(driverUrl));
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));){
            org.w3c.dom.Document xml = this.loadXML(reader);
            NodeList nodes = (NodeList)XPathFactory.newInstance().newXPath().evaluate("//Contents/Key", xml.getDocumentElement(), XPathConstants.NODESET);
            for (int i = 0; i < nodes.getLength(); ++i) {
                Element e = (Element)nodes.item(i);
                urls.add(new URL(driverUrl + e.getChildNodes().item(0).getNodeValue()));
            }
        }
        catch (Exception e) {
            throw new WebDriverManagerException(e);
        }
        return urls;
    }

    protected org.w3c.dom.Document loadXML(Reader reader) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource is = new InputSource(reader);
        return builder.parse(is);
    }

    protected String defaultOsName() {
        String os = System.getProperty("os.name").toLowerCase();
        if (SystemUtils.IS_OS_WINDOWS) {
            os = OperativeSystem.WIN.name();
        } else if (SystemUtils.IS_OS_LINUX) {
            os = OperativeSystem.LINUX.name();
        } else if (SystemUtils.IS_OS_MAC) {
            os = OperativeSystem.MAC.name();
        }
        return os;
    }

    protected void exportDriver(String variableName, String variableValue) {
        this.log.info("Exporting {} as {}", (Object)variableName, (Object)variableValue);
        this.binaryPath = variableValue;
        System.setProperty(variableName, variableValue);
    }

    protected InputStream openGitHubConnection(URL driverUrl) throws IOException {
        HttpGet get = this.httpClient.createHttpGet(driverUrl);
        String gitHubTokenName = WdmConfig.getString("wdm.gitHubTokenName");
        gitHubTokenName = WdmConfig.isNullOrEmpty(gitHubTokenName) ? System.getenv("WDM_GIT_HUB_TOKEN_NAME") : gitHubTokenName;
        String gitHubTokenSecret = WdmConfig.getString("wdm.gitHubTokenSecret");
        String string = gitHubTokenSecret = WdmConfig.isNullOrEmpty(gitHubTokenSecret) ? System.getenv("WDM_GIT_HUB_TOKEN_SECRET") : gitHubTokenSecret;
        if (!WdmConfig.isNullOrEmpty(gitHubTokenName) && !WdmConfig.isNullOrEmpty(gitHubTokenSecret)) {
            String userpass = gitHubTokenName + ":" + gitHubTokenSecret;
            String basicAuth = "Basic " + new String(new Base64().encode(userpass.getBytes()));
            get.addHeader("Authorization", basicAuth);
        }
        return this.httpClient.execute((HttpRequestBase)get).getEntity().getContent();
    }

    protected Architecture getDefaultArchitecture() {
        if (this.architecture == null) {
            String archStr = WdmConfig.getString("wdm.architecture");
            if (archStr.equals("")) {
                archStr = System.getProperty("sun.arch.data.model");
            }
            this.architecture = Architecture.valueOf("X" + archStr);
        }
        return this.architecture;
    }

    protected List<URL> getDriversFromGitHub() throws IOException {
        List<URL> urls;
        if (this.isUsingTaobaoMirror()) {
            urls = this.getDriversFromMirror(this.getDriverUrl());
        } else {
            String driverVersion = this.versionToDownload;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(this.getDriverUrl())));){
                GsonBuilder gsonBuilder = new GsonBuilder();
                Gson gson = gsonBuilder.create();
                GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
                if (driverVersion != null) {
                    releaseArray = new GitHubApi[]{this.getVersion(releaseArray, driverVersion)};
                }
                urls = new ArrayList<URL>();
                for (GitHubApi release : releaseArray) {
                    if (release == null) continue;
                    List<LinkedTreeMap<String, Object>> assets = release.getAssets();
                    for (LinkedTreeMap<String, Object> asset : assets) {
                        urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
                    }
                }
            }
        }
        return urls;
    }

    protected GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            this.log.trace("Get version {} of {}", (Object)version, (Object)release);
            if ((release.getName() == null || !release.getName().contains(version)) && (release.getTagName() == null || !release.getTagName().contains(version))) continue;
            out = release;
            break;
        }
        return out;
    }

    protected String getExportParameter() {
        return this.exportParameter;
    }

    protected String getDriverVersionKey() {
        return this.driverVersionKey;
    }

    protected String getDriverUrlKey() {
        return this.driverUrlKey;
    }

    protected List<String> getDriverName() {
        return this.driverName;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    protected void reset() {
        this.myOsName = this.defaultOsName();
        this.useBetaVersions = false;
        this.mirrorLog = false;
        this.isForcingCache = false;
        this.isForcingDownload = false;
        this.listVersions = null;
        this.architecture = null;
        this.driverUrl = null;
        this.version = null;
        this.versionToDownload = null;
        this.proxyValue = null;
        this.proxyUser = null;
        this.proxyPass = null;
        this.ignoredVersions = null;
    }
}

