/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.DriverManagerType;
import io.github.bonigarcia.wdm.WdmConfig;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;

public class OperaDriverManager
extends WebDriverManager {
    public static synchronized WebDriverManager getInstance() {
        return OperaDriverManager.operadriver();
    }

    public OperaDriverManager() {
        this.driverManagerType = DriverManagerType.OPERA;
        this.exportParameter = WdmConfig.getString("wdm.operaDriverExport");
        this.driverVersionKey = "wdm.operaDriverVersion";
        this.driverUrlKey = "wdm.operaDriverUrl";
        this.driverMirrorUrlKey = "wdm.operaDriverMirrorUrl";
        this.driverName = Arrays.asList("operadriver");
    }

    @Override
    protected List<URL> getDrivers() throws IOException {
        return this.getDriversFromGitHub();
    }

    @Override
    protected String getCurrentVersion(URL url, String driverName) {
        if (this.isUsingTaobaoMirror()) {
            int i = url.getFile().lastIndexOf("/");
            int j = url.getFile().substring(0, i).lastIndexOf("/") + 1;
            return url.getFile().substring(j, i);
        }
        return url.getFile().substring(url.getFile().indexOf("/v") + 2, url.getFile().lastIndexOf("/"));
    }

    @Override
    protected File postDownload(File archive) {
        this.log.trace("Post processing for Opera: {}", (Object)archive);
        File extractFolder = archive.getParentFile().listFiles()[0];
        if (!extractFolder.isFile()) {
            this.log.trace("Opera extract folder (to be deleted): {}", (Object)extractFolder);
            File operadriver = extractFolder.listFiles()[0];
            this.log.trace("Operadriver binary: {}", (Object)operadriver);
            File target = new File(archive.getParentFile().getAbsolutePath(), operadriver.getName());
            this.log.trace("Operadriver target: {}", (Object)target);
            this.downloader.renameFile(operadriver, target);
            this.downloader.deleteFolder(extractFolder);
            return target;
        }
        return super.postDownload(archive);
    }
}

