/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.internal.LinkedTreeMap;
import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.DriverVersion;
import io.github.bonigarcia.wdm.GitHubApi;
import io.github.bonigarcia.wdm.WdmConfig;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MarionetteDriverManager
extends BrowserManager {
    private static MarionetteDriverManager instance;

    public static synchronized MarionetteDriverManager getInstance() {
        if (instance == null) {
            instance = new MarionetteDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws IOException {
        GitHubApi release;
        URL driverUrl = this.getDriverUrl();
        String driverVersion = this.versionToDownload;
        BufferedReader reader = new BufferedReader(new InputStreamReader(this.openGitHubConnection(driverUrl)));
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.create();
        GitHubApi[] releaseArray = (GitHubApi[])gson.fromJson((Reader)reader, GitHubApi[].class);
        if (driverVersion == null || driverVersion.isEmpty() || driverVersion.equalsIgnoreCase(DriverVersion.LATEST.name())) {
            log.debug("Connecting to {} to check latest MarionetteDriver release", (Object)driverUrl);
            driverVersion = releaseArray[0].getName();
            release = releaseArray[0];
        } else {
            release = this.getVersion(releaseArray, driverVersion);
        }
        if (release == null) {
            throw new RuntimeException("Version " + driverVersion + " is not available for MarionetteDriver");
        }
        List<LinkedTreeMap<String, Object>> assets = release.getAssets();
        ArrayList<URL> urls = new ArrayList<URL>();
        for (LinkedTreeMap<String, Object> asset : assets) {
            urls.add(new URL(asset.get((Object)"browser_download_url").toString()));
        }
        reader.close();
        return urls;
    }

    private GitHubApi getVersion(GitHubApi[] releaseArray, String version) {
        GitHubApi out = null;
        for (GitHubApi release : releaseArray) {
            if (!release.getName().contains(version)) continue;
            out = release;
            break;
        }
        return out;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.marionetteDriverExport");
    }

    @Override
    protected String getDriverVersion() {
        return WdmConfig.getString("wdm.marionetteDriverVersion");
    }

    @Override
    protected List<String> getDriverName() {
        return Arrays.asList("wires", "geckodriver");
    }

    @Override
    protected URL getDriverUrl() throws MalformedURLException {
        return WdmConfig.getUrl("wdm.marionetteDriverUrl");
    }
}

