/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.wdm;

import io.github.bonigarcia.wdm.BrowserManager;
import io.github.bonigarcia.wdm.WdmConfig;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public class EdgeDriverManager
extends BrowserManager {
    private static EdgeDriverManager instance;

    protected EdgeDriverManager() {
    }

    public static synchronized EdgeDriverManager getInstance() {
        if (instance == null) {
            instance = new EdgeDriverManager();
        }
        return instance;
    }

    @Override
    public List<URL> getDrivers() throws Exception {
        String edgeDriverUrl = WdmConfig.getString("wdm.edgeDriverUrl");
        log.debug("Reading {} to find out the latest version of Edge driver", (Object)edgeDriverUrl);
        LogFactory.getFactory().setAttribute("org.apache.commons.logging.Log", (Object)"org.apache.commons.logging.impl.NoOpLog");
        Logger.getLogger("com.gargoylesoftware.htmlunit").setLevel(Level.OFF);
        Logger.getLogger("org.apache.commons.httpclient").setLevel(Level.OFF);
        HtmlUnitDriver driver = new HtmlUnitDriver();
        driver.manage().timeouts().implicitlyWait((long)WdmConfig.getInt("wdm.timeout"), TimeUnit.SECONDS);
        driver.get(edgeDriverUrl);
        driver.findElement(By.linkText((String)"Download")).click();
        WebElement clickHere = driver.findElement(By.linkText((String)"Click here"));
        String downloadLink = clickHere.getAttribute("href");
        ArrayList<URL> urlList = new ArrayList<URL>();
        urlList.add(new URL(downloadLink));
        return urlList;
    }

    @Override
    protected String getExportParameter() {
        return WdmConfig.getString("wdm.edgeExport");
    }

    @Override
    protected String getDriverVersion() {
        return WdmConfig.getString("wdm.edgeVersion");
    }

    @Override
    protected URL getDriverUrl() throws MalformedURLException {
        return WdmConfig.getUrl("wdm.edgeDriverUrl");
    }

    @Override
    protected String getDriverName() {
        return "MicrosoftWebDriver";
    }
}

