/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.aventstack.extentreports.ExtentTest;
import io.github.bonigarcia.seljup.OutputHandler;
import io.github.bonigarcia.seljup.config.Config;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Optional;
import org.apache.commons.io.FileUtils;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScreenshotManager {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    ExtensionContext extensionContext;
    Config config;
    OutputHandler outputHandler;

    public ScreenshotManager(ExtensionContext extensionContext, Config config, OutputHandler outputHandler) {
        this.extensionContext = extensionContext;
        this.config = config;
        this.outputHandler = outputHandler;
    }

    boolean isScreenshotRequired() {
        Optional executionException = this.extensionContext.getExecutionException();
        boolean isSscreenshot = this.config.isScreenshot();
        boolean isSscreenshotWhenFailure = this.config.isScreenshotWhenFailure();
        return isSscreenshot || executionException.isPresent() && isSscreenshotWhenFailure;
    }

    void makeScreenshotIfRequired(List<WebDriver> driverList, Optional<ExtentTest> optionalTest) {
        driverList.forEach(driver -> this.makeScreenshotIfRequired((WebDriver)driver, optionalTest));
    }

    void makeScreenshotIfRequired(WebDriver driver, Optional<ExtentTest> optionalTest) {
        if (this.isScreenshotRequired() && driver != null) {
            String screenshotFormat;
            String base64Screenshot = ScreenshotManager.getBase64Screenshot(driver);
            switch (screenshotFormat = this.config.getScreenshotFormat()) {
                case "png": {
                    optionalTest.ifPresent(test -> test.addScreenCaptureFromBase64String(base64Screenshot));
                    this.logFileScreenshot(driver);
                    break;
                }
                case "base64": {
                    this.logBase64Screenshot(base64Screenshot);
                    break;
                }
                case "base64andpng": {
                    this.logBase64Screenshot(base64Screenshot);
                    this.logFileScreenshot(driver);
                    break;
                }
                default: {
                    this.log.warn("Invalid screenshot format {}", (Object)screenshotFormat);
                }
            }
        }
    }

    public static String getBase64Screenshot(WebDriver driver) {
        return (String)((TakesScreenshot)driver).getScreenshotAs(OutputType.BASE64);
    }

    void logBase64Screenshot(String screenshotBase64) {
        try {
            this.log.debug("Screenshot (in Base64) at the end of test (copy&paste this string as URL in browser to watch it):\r\ndata:image/png;base64,{}", (Object)screenshotBase64);
        }
        catch (Exception e) {
            this.log.trace("Exception getting screenshot in Base64", (Throwable)e);
        }
    }

    void logFileScreenshot(WebDriver driver) {
        try {
            File screenshotFile = (File)((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
            File destFile = this.outputHandler.getScreenshotFile(driver);
            this.log.trace("Creating screenshot for {} in {}", (Object)driver, (Object)destFile);
            FileUtils.copyFile((File)screenshotFile, (File)destFile);
        }
        catch (Exception e) {
            this.log.trace("Exception getting screenshot as file", (Throwable)e);
        }
    }
}

