/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.codeborne.selenide.SelenideConfig;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.SelenideConfiguration;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Parameter;
import java.util.Optional;
import org.openqa.selenium.WebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SelenideHandler {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String SELENIDE_DRIVER_CLASS = "com.codeborne.selenide.SelenideDriver";
    static final String SELENIDE_CONFIG_INTERFACE = "com.codeborne.selenide.Config";
    static final String SELENIDE_CONFIG_CLASS = "com.codeborne.selenide.SelenideConfig";
    static final String SELENIDE_PROXY_CLASS = "com.codeborne.selenide.proxy.SelenideProxyServer";
    AnnotationsReader annotationsReader;

    public SelenideHandler(AnnotationsReader annotationsReader) {
        this.annotationsReader = annotationsReader;
    }

    public boolean isSelenide(Class<?> type) {
        return type.getCanonicalName().equals(SELENIDE_DRIVER_CLASS);
    }

    public boolean useCustomSelenideConfig(Parameter parameter, Optional<Object> testInstance) {
        SelenideConfiguration selenideConfiguration = parameter.getAnnotation(SelenideConfiguration.class);
        SelenideConfig globalConfig = this.annotationsReader.getFromAnnotatedField(testInstance, SelenideConfiguration.class, SelenideConfig.class);
        return selenideConfiguration != null || globalConfig != null;
    }

    public Object createSelenideDriver(WebDriver driver, Parameter parameter, Optional<Object> testInstance) {
        Object object = null;
        try {
            Object config = this.getSelenideConfig(testInstance, parameter);
            object = driver == null ? Class.forName(SELENIDE_DRIVER_CLASS).getDeclaredConstructor(Class.forName(SELENIDE_CONFIG_INTERFACE)).newInstance(config) : Class.forName(SELENIDE_DRIVER_CLASS).getDeclaredConstructor(Class.forName(SELENIDE_CONFIG_INTERFACE), WebDriver.class, Class.forName(SELENIDE_PROXY_CLASS)).newInstance(config, driver, null);
        }
        catch (Exception e) {
            this.log.warn("Exception creating SelenideDriver object", (Throwable)e);
        }
        return object;
    }

    public Object getSelenideConfig(Optional<Object> testInstance, Parameter parameter) {
        SelenideConfig config = null;
        try {
            config = (SelenideConfig)Class.forName(SELENIDE_CONFIG_CLASS).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            if (parameter != null) {
                SelenideConfig globalConfig;
                SelenideConfiguration selenideConfiguration = parameter.getAnnotation(SelenideConfiguration.class);
                if (selenideConfiguration != null) {
                    Class.forName(SELENIDE_CONFIG_CLASS).getDeclaredMethod("browser", String.class).invoke((Object)config, selenideConfiguration.browser());
                    Class.forName(SELENIDE_CONFIG_CLASS).getDeclaredMethod("headless", Boolean.TYPE).invoke((Object)config, selenideConfiguration.headless());
                    Class.forName(SELENIDE_CONFIG_CLASS).getDeclaredMethod("browserBinary", String.class).invoke((Object)config, selenideConfiguration.browserBinary());
                }
                if ((globalConfig = this.annotationsReader.getFromAnnotatedField(testInstance, SelenideConfiguration.class, SelenideConfig.class)) != null) {
                    config = globalConfig;
                }
            }
        }
        catch (Exception e) {
            this.log.warn("Exception getting Selenide Config", (Throwable)e);
        }
        return config;
    }
}

