/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.gson.Gson;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Browser;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.BrowsersTemplate;
import io.github.bonigarcia.seljup.CapabilitiesHandler;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.EnabledIfBrowserAvailable;
import io.github.bonigarcia.seljup.OutputHandler;
import io.github.bonigarcia.seljup.ScreenshotManager;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.SingleSession;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.wdm.WebDriverManager;
import io.github.bonigarcia.wdm.config.DriverManagerType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.AfterAllCallback;
import org.junit.jupiter.api.extension.AfterEachCallback;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.ConditionEvaluationResult;
import org.junit.jupiter.api.extension.ExecutionCondition;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestTemplateInvocationContext;
import org.junit.jupiter.api.extension.TestTemplateInvocationContextProvider;
import org.junit.platform.commons.util.AnnotationUtils;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeleniumJupiter
implements ParameterResolver,
AfterTestExecutionCallback,
AfterEachCallback,
AfterAllCallback,
TestTemplateInvocationContextProvider,
ExecutionCondition {
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    static final String CLASSPATH_PREFIX = "classpath:";
    static final ConditionEvaluationResult ENABLED = ConditionEvaluationResult.enabled((String)"Browser(s) available in the system");
    Config config = new Config();
    Map<String, List<WebDriverManager>> wdmMap = new ConcurrentHashMap<String, List<WebDriverManager>>();
    AnnotationsReader annotationsReader = new AnnotationsReader();
    List<List<BrowsersTemplate.Browser>> browserListList = new ArrayList<List<BrowsersTemplate.Browser>>();
    Map<String, List<BrowsersTemplate.Browser>> browserListMap = new ConcurrentHashMap<String, List<BrowsersTemplate.Browser>>();
    OutputHandler outputHandler;

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        Parameter parameter = parameterContext.getParameter();
        Class<?> type = parameter.getType();
        Type parameterizedType = parameter.getParameterizedType();
        String parameterizedTypeName = "";
        if (ParameterizedType.class.isAssignableFrom(parameterizedType.getClass())) {
            parameterizedTypeName = ((ParameterizedType)parameterizedType).getActualTypeArguments()[0].getTypeName();
        }
        Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(parameter);
        return (WebDriver.class.isAssignableFrom(type) || type.equals(List.class) && dockerBrowser.isPresent() && this.isGeneric(parameterizedTypeName)) && !this.isTestTemplate(extensionContext);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        WebDriver driver;
        String contextId = this.getContextId(extensionContext);
        Parameter parameter = parameterContext.getParameter();
        int index = parameterContext.getIndex();
        Optional testInstance = extensionContext.getTestInstance();
        this.log.trace("Resolving parameter {} (contextId {}, index {})", new Object[]{parameter, contextId, index});
        WebDriverManager wdm = null;
        BrowsersTemplate.Browser browser = null;
        int browserNumber = 0;
        Class<?> type = parameter.getType();
        boolean isGeneric = this.isGeneric(type);
        Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(parameter);
        Optional<URL> url = this.annotationsReader.getUrl(parameter, testInstance, this.config.getSeleniumServerUrl());
        Optional<Capabilities> caps = this.annotationsReader.getCapabilities(parameter, testInstance);
        if (this.isSingleSession(extensionContext) && this.wdmMap.containsKey(contextId) && index < this.wdmMap.get(contextId).size() && (driver = this.wdmMap.get(contextId).get(index).getWebDriver()) != null) {
            this.log.trace("Returning driver at index {}: {}", (Object)index, (Object)driver);
            return driver;
        }
        if (this.config.getManager() != null) {
            wdm = this.config.getManager();
        } else if (isGeneric && !this.browserListMap.isEmpty()) {
            browser = this.getBrowser(contextId, index);
            wdm = this.getManagerForTemplate(extensionContext, parameter, browser, url);
        } else if (dockerBrowser.isPresent()) {
            if (dockerBrowser.get().size() > 0) {
                browserNumber = dockerBrowser.get().size();
            }
            wdm = this.getManagerForDocker(extensionContext, parameter, dockerBrowser.get());
        } else {
            wdm = url.isPresent() && caps.isPresent() ? this.getManagerForRemote(url.get(), caps.get()) : this.getManagerForLocal(extensionContext, parameter, type, isGeneric);
        }
        this.outputHandler = new OutputHandler(extensionContext, this.getConfig(), parameter);
        wdm.recordingPrefix(this.outputHandler.getPrefix());
        wdm.recordingOutput(this.outputHandler.getOutputFolder());
        this.putManagerInMap(contextId, wdm);
        return browserNumber == 0 ? wdm.create() : wdm.create(browserNumber);
    }

    private String getContextId(ExtensionContext extensionContext) {
        Optional parent = extensionContext.getParent();
        return parent.isPresent() && extensionContext.getClass().getCanonicalName().equals("org.junit.jupiter.engine.descriptor.MethodExtensionContext") ? ((ExtensionContext)parent.get()).getUniqueId() : extensionContext.getUniqueId();
    }

    private WebDriverManager getManagerForRemote(URL url, Capabilities caps) {
        WebDriverManager wdm = WebDriverManager.getInstance().remoteAddress(url.toString()).capabilities(caps);
        return wdm;
    }

    private WebDriverManager getManagerForLocal(ExtensionContext extensionContext, Parameter parameter, Class<?> type, boolean isGeneric) {
        if (type == List.class) {
            throw new SeleniumJupiterException("List<WebDriver> must be used together with @DockerBrowser");
        }
        WebDriverManager wdm = isGeneric ? WebDriverManager.getInstance() : WebDriverManager.getInstance(type);
        Optional<Capabilities> capabilities = this.getCapabilities(extensionContext, parameter, Optional.empty(), Optional.empty());
        if (capabilities.isPresent()) {
            wdm.capabilities(capabilities.get());
        }
        return wdm;
    }

    private WebDriverManager getManagerForDocker(ExtensionContext extensionContext, Parameter parameter, DockerBrowser dockerBrowser) {
        Optional<Capabilities> capabilities;
        String browserVersion = dockerBrowser.version();
        BrowserType browserType = dockerBrowser.type();
        WebDriverManager wdm = WebDriverManager.getInstance((String)browserType.toBrowserName()).browserVersion(browserVersion).browserInDocker();
        if (browserType == BrowserType.CHROME_MOBILE) {
            wdm.browserInDockerAndroid();
        }
        if (dockerBrowser.recording() || this.config.isRecording() || this.config.isRecordingWhenFailure()) {
            wdm.enableRecording();
        }
        if (dockerBrowser.vnc() || this.config.isVnc()) {
            wdm.enableVnc();
        }
        if (dockerBrowser.volumes().length > 0) {
            wdm.dockerVolumes(dockerBrowser.volumes());
        }
        if (!dockerBrowser.lang().isEmpty()) {
            wdm.dockerLang(dockerBrowser.lang());
        }
        if (!dockerBrowser.timezone().isEmpty()) {
            wdm.dockerTimezone(dockerBrowser.timezone());
        }
        if ((capabilities = this.getCapabilities(extensionContext, parameter, Optional.of(browserType), Optional.empty())).isPresent()) {
            wdm.capabilities(capabilities.get());
        }
        return wdm;
    }

    private WebDriverManager getManagerForTemplate(ExtensionContext extensionContext, Parameter parameter, BrowsersTemplate.Browser browser, Optional<URL> url) {
        Optional<Capabilities> capabilities;
        WebDriverManager wdm;
        Optional<BrowserType> browserType = Optional.empty();
        Optional<BrowsersTemplate.Browser> opBrowser = Optional.empty();
        if (browser != null) {
            opBrowser = Optional.of(browser);
            browserType = Optional.of(browser.toBrowserType());
            wdm = WebDriverManager.getInstance((String)browserType.get().toBrowserName()).browserVersion(browser.getVersion()).remoteAddress(browser.getRemoteUrl());
            if (url.isPresent()) {
                wdm.remoteAddress(url.get().toString());
            }
            if (browser.isDockerBrowser()) {
                wdm.browserInDocker();
            }
            if (browser.isAndroidBrowser()) {
                wdm.browserInDockerAndroid();
            }
            if (this.config.isRecording()) {
                wdm.enableRecording();
            }
            if (this.config.isVnc()) {
                wdm.enableVnc();
            }
        } else {
            wdm = WebDriverManager.getInstance();
        }
        if ((capabilities = this.getCapabilities(extensionContext, parameter, browserType, opBrowser)).isPresent()) {
            wdm.capabilities(capabilities.get());
        }
        return wdm;
    }

    private Optional<Capabilities> getCapabilities(ExtensionContext extensionContext, Parameter parameter, Optional<BrowserType> browserType, Optional<BrowsersTemplate.Browser> browser) {
        CapabilitiesHandler capsHandler = new CapabilitiesHandler(this.config, this.annotationsReader, parameter, extensionContext, browser, browserType, this.isGeneric(parameter.getType()));
        return capsHandler.getCapabilities();
    }

    public void afterTestExecution(ExtensionContext extensionContext) throws Exception {
        String contextId = this.getContextId(extensionContext);
        ScreenshotManager screenshotManager = new ScreenshotManager(extensionContext, this.getConfig(), this.outputHandler);
        if (this.wdmMap.containsKey(contextId)) {
            this.wdmMap.get(contextId).stream().map(WebDriverManager::getWebDriverList).forEach(screenshotManager::makeScreenshotIfRequired);
            this.wdmMap.get(contextId).stream().forEach(WebDriverManager::stopDockerRecording);
        }
    }

    public void afterEach(ExtensionContext extensionContext) throws Exception {
        if (!this.isSingleSession(extensionContext)) {
            this.quitWebDriver(extensionContext);
        }
    }

    public void afterAll(ExtensionContext extensionContext) throws Exception {
        if (this.isSingleSession(extensionContext)) {
            this.quitWebDriver(extensionContext);
        }
    }

    public boolean supportsTestTemplate(ExtensionContext context) {
        boolean allWebDriver = false;
        if (context.getTestMethod().isPresent()) {
            allWebDriver = !Arrays.stream(((Method)context.getTestMethod().get()).getParameterTypes()).map(s -> s.equals(WebDriver.class) || s.equals(RemoteWebDriver.class)).collect(Collectors.toList()).contains(false);
        }
        return allWebDriver;
    }

    public Stream<TestTemplateInvocationContext> provideTestTemplateInvocationContexts(ExtensionContext extensionContext) {
        String contextId = this.getContextId(extensionContext);
        try {
            if (!this.browserListList.isEmpty()) {
                return this.browserListList.stream().map(b -> this.invocationContext((List<BrowsersTemplate.Browser>)b, this));
            }
            String browserJsonContent = this.config.getBrowserTemplateJsonContent();
            if (browserJsonContent.isEmpty()) {
                String browserJsonFile = this.config.getBrowserTemplateJsonFile();
                if (browserJsonFile.startsWith(CLASSPATH_PREFIX)) {
                    String browserJsonInClasspath = browserJsonFile.substring(CLASSPATH_PREFIX.length());
                    InputStream resourceAsStream = this.getClass().getResourceAsStream("/" + browserJsonInClasspath);
                    if (resourceAsStream != null) {
                        browserJsonContent = IOUtils.toString((InputStream)resourceAsStream, (Charset)Charset.defaultCharset());
                    }
                } else {
                    browserJsonContent = new String(Files.readAllBytes(Paths.get(browserJsonFile, new String[0])));
                }
            }
            if (!browserJsonContent.isEmpty()) {
                return ((BrowsersTemplate)new Gson().fromJson(browserJsonContent, BrowsersTemplate.class)).getStream().map(b -> this.invocationContext((List<BrowsersTemplate.Browser>)b, this));
            }
            if (this.browserListMap != null) {
                List<BrowsersTemplate.Browser> browsers = this.browserListMap.get(contextId);
                if (browsers != null) {
                    return Stream.of(this.invocationContext(browsers, this));
                }
                return Stream.empty();
            }
        }
        catch (IOException e) {
            throw new SeleniumJupiterException(e);
        }
        throw new SeleniumJupiterException("No browser scenario registered for test template");
    }

    private synchronized TestTemplateInvocationContext invocationContext(final List<BrowsersTemplate.Browser> template, final SeleniumJupiter parent) {
        return new TestTemplateInvocationContext(){

            public String getDisplayName(int invocationIndex) {
                return template.toString();
            }

            public List<Extension> getAdditionalExtensions() {
                return Collections.singletonList(new ParameterResolver(){

                    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                        Class<?> type = parameterContext.getParameter().getType();
                        return type.equals(WebDriver.class) || type.equals(RemoteWebDriver.class);
                    }

                    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
                        String contextId = SeleniumJupiter.this.getContextId(extensionContext);
                        SeleniumJupiter.this.log.trace("Setting browser list {} for context id {}", (Object)template, (Object)contextId);
                        parent.browserListMap.put(contextId, template);
                        return parent.resolveParameter(parameterContext, extensionContext);
                    }
                });
            }
        };
    }

    public ConditionEvaluationResult evaluateExecutionCondition(ExtensionContext context) {
        AnnotatedElement element = context.getElement().orElse(null);
        return AnnotationUtils.findAnnotation((AnnotatedElement)element, EnabledIfBrowserAvailable.class).map(this::toResult).orElse(ENABLED);
    }

    public Config getConfig() {
        return this.config;
    }

    public void addBrowsers(BrowsersTemplate.Browser ... browsers) {
        this.browserListList.add(Arrays.asList(browsers));
    }

    public void putBrowserList(String key, List<BrowsersTemplate.Browser> browserList) {
        this.browserListMap.put(key, browserList);
    }

    private boolean isTestTemplate(ExtensionContext extensionContext) {
        Optional testMethod = extensionContext.getTestMethod();
        return testMethod.isPresent() && ((Method)testMethod.get()).isAnnotationPresent(TestTemplate.class);
    }

    private boolean isGeneric(Class<?> type) {
        return this.isGeneric(type.getCanonicalName());
    }

    private boolean isGeneric(String type) {
        return type.equals("org.openqa.selenium.remote.RemoteWebDriver") || type.equals("org.openqa.selenium.WebDriver");
    }

    private BrowsersTemplate.Browser getBrowser(String contextId, int index) {
        this.log.trace("Getting browser by contextId {} and index {}", (Object)contextId, (Object)index);
        BrowsersTemplate.Browser browser = null;
        if (!this.browserListMap.containsKey(contextId)) {
            this.log.warn("Browser list for context id {} not found", (Object)contextId);
        } else {
            List<BrowsersTemplate.Browser> browserList = this.browserListMap.get(contextId);
            if (index >= browserList.size()) {
                index = browserList.size() - 1;
            }
            browser = browserList.get(index);
        }
        return browser;
    }

    private ConditionEvaluationResult toResult(EnabledIfBrowserAvailable annotation) {
        Browser[] browsers;
        for (Browser browser : browsers = annotation.value()) {
            DriverManagerType driverManagerType = DriverManagerType.valueOf((String)browser.name());
            Optional browserPath = WebDriverManager.getInstance((DriverManagerType)driverManagerType).getBrowserPath();
            if (browserPath.isPresent()) continue;
            return ConditionEvaluationResult.disabled((String)((Object)((Object)browser) + " is not installed in the system"));
        }
        return ENABLED;
    }

    private void removeManagersFromMap(String contextId) {
        if (this.wdmMap.containsKey(contextId)) {
            this.wdmMap.remove(contextId);
            this.log.trace("Removing managers from map (id {})", (Object)contextId);
        }
    }

    private void putManagerInMap(String contextId, WebDriverManager wdm) {
        this.log.trace("Put manager {} in map (context id {})", (Object)wdm, (Object)contextId);
        if (this.wdmMap.containsKey(contextId)) {
            this.wdmMap.get(contextId).add(wdm);
            this.log.trace("Adding {} to existing map (id {})", (Object)wdm, (Object)contextId);
        } else {
            ArrayList<WebDriverManager> wdmList = new ArrayList<WebDriverManager>();
            wdmList.add(wdm);
            this.wdmMap.put(contextId, wdmList);
            this.log.trace("Adding {} to new map (id {})", (Object)wdm, (Object)contextId);
        }
    }

    private boolean isSingleSession(ExtensionContext extensionContext) {
        boolean singleSession = false;
        Optional testClass = extensionContext.getTestClass();
        if (testClass.isPresent()) {
            singleSession = ((Class)testClass.get()).isAnnotationPresent(SingleSession.class);
        }
        this.log.trace("Single session {}", (Object)singleSession);
        return singleSession;
    }

    private void quitWebDriver(ExtensionContext extensionContext) {
        String contextId = this.getContextId(extensionContext);
        this.log.trace("Quitting contextId {}: (wdmMap={})", (Object)contextId, this.wdmMap);
        if (this.wdmMap.containsKey(contextId)) {
            Optional executionException = extensionContext.getExecutionException();
            this.wdmMap.get(contextId).forEach(manager -> {
                List<Path> recordingList = Collections.emptyList();
                if (this.config.isRecordingWhenFailure() && !executionException.isPresent()) {
                    recordingList = manager.getWebDriverList().stream().map(arg_0 -> ((WebDriverManager)manager).getDockerRecordingPath(arg_0)).collect(Collectors.toList());
                }
                manager.quit();
                recordingList.forEach(path -> {
                    try {
                        this.log.debug("Deleting {} (since test does not fail)", path);
                        Files.delete(path);
                    }
                    catch (Exception e) {
                        this.log.warn("Exception trying to delete recording {}", path);
                    }
                });
            });
            this.removeManagersFromMap(contextId);
        }
    }
}

