/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.Arguments;
import io.github.bonigarcia.seljup.Binary;
import io.github.bonigarcia.seljup.Extensions;
import io.github.bonigarcia.seljup.Options;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import io.github.bonigarcia.wdm.WebDriverManager;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Parameter;
import java.util.Arrays;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.chrome.ChromeOptions;

public class ChromeDriverHandler
extends DriverHandler {
    public ChromeDriverHandler(Config config, AnnotationsReader annotationsReader) {
        super(config, annotationsReader);
    }

    public ChromeDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
            ChromeOptions chromeOptions = (ChromeOptions)this.getOptions(this.parameter, testInstance);
            if (chromeOptions.asMap().get("goog:chromeOptions").toString().toLowerCase().contains("chromium")) {
                WebDriverManager.chromiumdriver().setup();
            }
            if (capabilities.isPresent()) {
                chromeOptions.merge(capabilities.get());
            }
            this.object = new ChromeDriver(chromeOptions);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public MutableCapabilities getOptions(Parameter parameter, Optional<Object> testInstance) throws IOException, IllegalAccessException {
        ChromeOptions chromeOptions = new ChromeOptions();
        if (parameter != null) {
            ChromeOptions optionsFromAnnotatedField;
            Binary binary;
            Extensions extensions;
            Arguments arguments = parameter.getAnnotation(Arguments.class);
            if (arguments != null) {
                Arrays.stream(arguments.value()).forEach(xva$0 -> chromeOptions.addArguments(new String[]{xva$0}));
            }
            if ((extensions = parameter.getAnnotation(Extensions.class)) != null) {
                for (String extension : extensions.value()) {
                    chromeOptions.addExtensions(new File[]{this.getExtension(extension)});
                }
            }
            if ((binary = parameter.getAnnotation(Binary.class)) != null) {
                chromeOptions.setBinary(binary.value());
            }
            if ((optionsFromAnnotatedField = this.annotationsReader.getFromAnnotatedField(testInstance, Options.class, ChromeOptions.class)) != null) {
                chromeOptions = optionsFromAnnotatedField.merge((Capabilities)chromeOptions);
            }
        }
        return chromeOptions;
    }
}

