/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SurefireReports {
    static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    private SurefireReports() {
        throw new IllegalStateException("Utility class");
    }

    public static String getOutputFolder(ExtensionContext context, String outputFolder) {
        if (context == null) {
            return "";
        }
        Optional testMethod = context.getTestMethod();
        Optional testInstance = context.getTestClass();
        if (testMethod.isPresent() && testInstance.isPresent()) {
            if (outputFolder.equalsIgnoreCase("surefire-reports")) {
                outputFolder = SurefireReports.getSurefireOutputFolder((Class)testInstance.get());
            } else if (outputFolder.isEmpty()) {
                outputFolder = ".";
            }
        }
        log.trace("Output folder {}", (Object)outputFolder);
        File outputFolderFile = new File(outputFolder);
        if (!outputFolderFile.exists()) {
            outputFolderFile.mkdirs();
        }
        return outputFolder;
    }

    private static String getSurefireOutputFolder(Class<?> testInstance) {
        StringBuilder stringBuilder = new StringBuilder("./target/surefire-reports/");
        stringBuilder.append(testInstance.getName());
        return stringBuilder.toString();
    }
}

