/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup;

import com.google.gson.Gson;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowserType;
import io.github.bonigarcia.seljup.CloudType;
import io.github.bonigarcia.seljup.InternalPreferences;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DockerDriverHandler;
import io.javalin.Handler;
import io.javalin.Javalin;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Server {
    public static final MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static final String GET = "GET";
    public static final String DELETE = "DELETE";
    public static final String POST = "POST";
    public static final String SESSION = "/session";
    final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public Server(int port) {
        Javalin app = Javalin.create().start(port);
        Config config = new Config();
        AnnotationsReader annotationsReader = new AnnotationsReader();
        InternalPreferences preferences = new InternalPreferences(config);
        Gson gson = new Gson();
        String[] hubUrl = new String[1];
        DockerDriverHandler[] dockerDriverHandler = new DockerDriverHandler[1];
        String path = config.getServerPath();
        String serverPath = path.endsWith("/") ? path.substring(0, path.length() - 1) : path;
        int timeoutSec = config.getServerTimeoutSec();
        Handler handler = ctx -> {
            String requestMethod = ctx.method();
            String requestPath = ctx.path();
            String requestBody = ctx.body();
            this.log.info("Server request: {} {}", (Object)requestMethod, (Object)requestPath);
            this.log.debug("body: {} ", (Object)requestBody);
            Session session = (Session)gson.fromJson(requestBody, Session.class);
            if (session != null && session.getDesiredCapabilities() != null) {
                String browserName = session.getDesiredCapabilities().getBrowserName();
                String version = session.getDesiredCapabilities().getVersion();
                BrowserType browserType = this.getBrowserType(browserName);
                BrowserInstance browserInstance = new BrowserInstance(config, annotationsReader, browserType, CloudType.NONE, Optional.empty(), Optional.empty());
                dockerDriverHandler[0] = new DockerDriverHandler(config, browserInstance, version, preferences);
                dockerDriverHandler[0].resolve(browserInstance, version, "", "", false);
                hubUrl[0] = dockerDriverHandler[0].getHubUrl().toString();
                this.log.info("Hub URL {}", (Object)hubUrl[0]);
            }
            String response = Server.exchange(hubUrl[0] + requestPath.replace(serverPath, ""), requestMethod, requestBody, timeoutSec);
            this.log.info("Server response: {}", (Object)response);
            ctx.result(response);
            if (requestMethod.equalsIgnoreCase(DELETE) && requestPath.startsWith(serverPath + SESSION + "/")) {
                dockerDriverHandler[0].cleanup();
            }
        };
        app.post(serverPath + SESSION, handler);
        app.post(serverPath + SESSION + "/*", handler);
        app.get(serverPath + SESSION + "/*", handler);
        app.delete(serverPath + SESSION + "/*", handler);
        String serverUrl = String.format("http://localhost:%d%s", port, serverPath);
        this.log.info("Selenium-Jupiter server listening on {}", (Object)serverUrl);
    }

    public BrowserType getBrowserType(String browserName) {
        BrowserType browserType;
        switch (browserName) {
            case "operablink": {
                browserType = BrowserType.OPERA;
                break;
            }
            case "MicrosoftEdge": {
                browserType = BrowserType.EDGE;
                break;
            }
            case "internet explorer": {
                browserType = BrowserType.IEXPLORER;
                break;
            }
            default: {
                browserType = BrowserType.valueOf(browserName.toUpperCase());
            }
        }
        return browserType;
    }

    public static String exchange(String url, String method, String json, int timeoutSec) throws IOException {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.connectTimeout((long)timeoutSec, TimeUnit.SECONDS);
        builder.readTimeout((long)timeoutSec, TimeUnit.SECONDS);
        builder.writeTimeout((long)timeoutSec, TimeUnit.SECONDS);
        OkHttpClient client = builder.build();
        Request.Builder requestBuilder = new Request.Builder().url(url);
        switch (method) {
            case "GET": {
                requestBuilder.get();
                break;
            }
            case "DELETE": {
                requestBuilder.delete();
                break;
            }
            default: {
                RequestBody body = RequestBody.create((MediaType)JSON, (String)json);
                requestBuilder.post(body);
            }
        }
        Response response = client.newCall(requestBuilder.build()).execute();
        return response.body().string();
    }

    static class DesiredCapabilities {
        String browserName;
        String version;
        String platform;

        DesiredCapabilities() {
        }

        public String getBrowserName() {
            return this.browserName;
        }

        public String getVersion() {
            return this.version;
        }

        public String getPlatform() {
            return this.platform;
        }
    }

    static class Session {
        DesiredCapabilities desiredCapabilities;

        Session() {
        }

        public DesiredCapabilities getDesiredCapabilities() {
            return this.desiredCapabilities;
        }
    }
}

