/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import com.codeborne.selenide.SelenideConfig;
import com.codeborne.selenide.SelenideDriver;
import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.SelenideConfiguration;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DockerDriverHandler;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.lang.reflect.Parameter;
import java.net.URL;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class SelenideDriverHandler
extends DriverHandler {
    private DockerDriverHandler dockerDriverHandler;

    public SelenideDriverHandler(Config config, AnnotationsReader annotationsReader) {
        super(config, annotationsReader);
    }

    public SelenideDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(this.parameter);
            if (dockerBrowser.isPresent()) {
                BrowserInstance browserInstance = new BrowserInstance(this.config, this.annotationsReader, dockerBrowser.get().type(), dockerBrowser.get().cloud(), Optional.ofNullable(dockerBrowser.get().browserName()), Optional.ofNullable(dockerBrowser.get().volumes()));
                this.dockerDriverHandler = new DockerDriverHandler(this.context, this.parameter, testInstance, this.annotationsReader, this.containerMap, this.dockerService, this.config, browserInstance, dockerBrowser.get().version());
                this.object = this.dockerDriverHandler.resolve(dockerBrowser.get());
            }
            SelenideConfig selenideConfig = this.getSelenideConfig(this.parameter, testInstance);
            if (this.object != null) {
                WebDriver webdriver = (WebDriver)this.object;
                this.object = new SelenideDriver((com.codeborne.selenide.Config)selenideConfig, webdriver, null);
            } else {
                Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
                Optional<URL> url = this.annotationsReader.getUrl(this.parameter, testInstance, this.config.getSeleniumServerUrl());
                if (capabilities.isPresent() && url.isPresent()) {
                    selenideConfig.remote(url.get().toString());
                    DesiredCapabilities browserCapabilities = (DesiredCapabilities)capabilities.get();
                    selenideConfig.browserCapabilities(browserCapabilities);
                    selenideConfig.browser(browserCapabilities.getBrowserName());
                }
                this.object = new SelenideDriver((com.codeborne.selenide.Config)selenideConfig);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    @Override
    public void cleanup() {
        if (this.dockerDriverHandler != null) {
            this.dockerDriverHandler.cleanup();
        }
    }

    public SelenideConfig getSelenideConfig(Parameter parameter, Optional<Object> testInstance) throws IllegalAccessException {
        SelenideConfig config = new SelenideConfig();
        if (parameter != null) {
            SelenideConfig globalConfig;
            SelenideConfiguration selenideConfiguration = parameter.getAnnotation(SelenideConfiguration.class);
            if (selenideConfiguration != null) {
                config.browser(selenideConfiguration.browser());
                config.headless(selenideConfiguration.headless());
                config.browserBinary(selenideConfiguration.browserBinary());
            }
            if ((globalConfig = this.annotationsReader.getFromAnnotatedField(testInstance, SelenideConfiguration.class, SelenideConfig.class)) != null) {
                config = globalConfig;
            }
        }
        return config;
    }
}

