/*
 * Decompiled with CFR 0.152.
 */
package io.github.bonigarcia.seljup.handler;

import io.github.bonigarcia.seljup.AnnotationsReader;
import io.github.bonigarcia.seljup.BrowserInstance;
import io.github.bonigarcia.seljup.BrowsersTemplate;
import io.github.bonigarcia.seljup.DockerBrowser;
import io.github.bonigarcia.seljup.SeleniumExtension;
import io.github.bonigarcia.seljup.SeleniumJupiterException;
import io.github.bonigarcia.seljup.WebDriverCreator;
import io.github.bonigarcia.seljup.config.Config;
import io.github.bonigarcia.seljup.handler.DockerDriverHandler;
import io.github.bonigarcia.seljup.handler.DriverHandler;
import java.lang.reflect.Parameter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Optional;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;

public class RemoteDriverHandler
extends DriverHandler {
    private DockerDriverHandler dockerDriverHandler;
    private BrowsersTemplate.Browser browser;
    private SeleniumExtension parent;
    private ParameterContext parameterContext;
    private WebDriverCreator webDriverCreator;

    public RemoteDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader) {
        super(parameter, context, config, annotationsReader);
    }

    public RemoteDriverHandler(Parameter parameter, ExtensionContext context, Config config, AnnotationsReader annotationsReader, BrowsersTemplate.Browser browser) {
        super(parameter, context, config, annotationsReader);
        this.browser = browser;
    }

    @Override
    public void resolve() {
        try {
            Optional testInstance = this.context.getTestInstance();
            if (this.browser != null && this.browser.isDockerBrowser()) {
                BrowserInstance browserInstance = new BrowserInstance(this.config, this.annotationsReader, this.browser.toBrowserType(), this.browser.toCloudType(), Optional.ofNullable(this.browser.getBrowserName()), Optional.ofNullable(this.browser.getVolumes()));
                this.dockerDriverHandler = new DockerDriverHandler(this.context, this.parameter, testInstance, this.annotationsReader, this.containerMap, this.dockerService, this.config, browserInstance, this.browser.getVersion());
                this.object = this.dockerDriverHandler.resolve(browserInstance, this.browser.getVersion(), this.browser.getDeviceName(), this.browser.getUrl(), true);
            } else {
                Optional<DockerBrowser> dockerBrowser = this.annotationsReader.getDocker(this.parameter);
                if (dockerBrowser.isPresent()) {
                    BrowserInstance browserInstance = new BrowserInstance(this.config, this.annotationsReader, dockerBrowser.get().type(), dockerBrowser.get().cloud(), Optional.ofNullable(dockerBrowser.get().browserName()), Optional.ofNullable(dockerBrowser.get().volumes()));
                    this.dockerDriverHandler = new DockerDriverHandler(this.context, this.parameter, testInstance, this.annotationsReader, this.containerMap, this.dockerService, this.config, browserInstance, dockerBrowser.get().version());
                    this.object = this.dockerDriverHandler.resolve(dockerBrowser.get());
                } else {
                    this.resolveOtherThanDocker(testInstance);
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void resolveOtherThanDocker(Optional<Object> testInstance) throws IllegalAccessException, MalformedURLException {
        Optional<URL> url;
        Optional<Capabilities> capabilities = this.annotationsReader.getCapabilities(this.parameter, testInstance);
        if (this.browser != null && this.browser.getUrl() != null && !this.browser.getUrl().isEmpty()) {
            url = Optional.of(new URL(this.browser.getUrl()));
            capabilities = Optional.of(new DesiredCapabilities(this.browser.getType(), this.browser.getVersion(), Platform.ANY));
        } else {
            url = this.annotationsReader.getUrl(this.parameter, testInstance, this.config.getSeleniumServerUrl());
        }
        this.object = url.isPresent() && capabilities.isPresent() ? this.resolveRemote(url.get(), capabilities.get()) : this.resolveGeneric();
    }

    @Override
    public String getName() {
        if (this.dockerDriverHandler != null) {
            return this.dockerDriverHandler.getName();
        }
        return super.getName();
    }

    private WebDriver resolveRemote(URL url, Capabilities capabilities) {
        if (this.webDriverCreator == null) {
            this.webDriverCreator = new WebDriverCreator(this.getConfig());
        }
        return this.webDriverCreator.createRemoteWebDriver(url, capabilities);
    }

    private WebDriver resolveGeneric() {
        String defaultBrowser = this.getConfig().getDefaultBrowser();
        String defaultVersion = this.getConfig().getDefaultVersion();
        String defaultBrowserFallback = this.getConfig().getDefaultBrowserFallback();
        String defaultBrowserFallbackVersion = this.getConfig().getDefaultBrowserFallbackVersion();
        String separator = ",";
        ArrayList<String> browserCandidates = new ArrayList<String>();
        ArrayList<String> versionCandidates = new ArrayList<String>();
        browserCandidates.add(defaultBrowser);
        versionCandidates.add(defaultVersion);
        if (defaultBrowserFallback.contains(separator)) {
            browserCandidates.addAll(Arrays.asList(defaultBrowserFallback.split(separator)));
        }
        if (defaultBrowserFallbackVersion.contains(separator)) {
            versionCandidates.addAll(Arrays.asList(defaultBrowserFallbackVersion.split(separator)));
        }
        assert (browserCandidates.size() == versionCandidates.size()) : "Number of browser and versions for fallback does not match";
        Iterator browserIterator = browserCandidates.iterator();
        Iterator versionIterator = versionCandidates.iterator();
        do {
            if (!browserIterator.hasNext()) {
                throw new SeleniumJupiterException("Browser candidate not found");
            }
            String browserCandidate = (String)browserIterator.next();
            String versionCandidate = (String)versionIterator.next();
            BrowsersTemplate.Browser candidate = new BrowsersTemplate.Browser(browserCandidate, versionCandidate);
            log.debug("Using generic handler, trying with {}", (Object)browserCandidate);
            this.parent.putBrowserList(this.context.getUniqueId(), Collections.singletonList(candidate));
            try {
                this.object = this.parent.resolveParameter(this.parameterContext, this.context);
            }
            catch (Exception e) {
                log.debug("There was an error with {} {}", (Object)browserCandidate, (Object)e.getMessage());
                this.object = null;
            }
        } while (this.object == null);
        return (WebDriver)this.object;
    }

    @Override
    public void cleanup() {
        if (this.dockerDriverHandler != null) {
            this.dockerDriverHandler.cleanup();
        }
    }

    public void setParent(SeleniumExtension parent) {
        this.parent = parent;
    }

    public void setParameterContext(ParameterContext parameterContext) {
        this.parameterContext = parameterContext;
    }
}

