/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.stream.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.stream.StreamConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.RequestWrapperDTO;
import com.binance.connector.client.common.websocket.service.StreamBlockingQueue;
import com.binance.connector.client.common.websocket.service.StreamBlockingQueueWrapper;
import com.binance.connector.client.spot.websocket.stream.model.AggTradeRequest;
import com.binance.connector.client.spot.websocket.stream.model.AggTradeResponse;
import com.binance.connector.client.spot.websocket.stream.model.AllMarketRollingWindowTickerRequest;
import com.binance.connector.client.spot.websocket.stream.model.AllMarketRollingWindowTickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.AllMiniTickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.AllTickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.AvgPriceRequest;
import com.binance.connector.client.spot.websocket.stream.model.AvgPriceResponse;
import com.binance.connector.client.spot.websocket.stream.model.BookTickerRequest;
import com.binance.connector.client.spot.websocket.stream.model.BookTickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.DiffBookDepthRequest;
import com.binance.connector.client.spot.websocket.stream.model.DiffBookDepthResponse;
import com.binance.connector.client.spot.websocket.stream.model.KlineOffsetRequest;
import com.binance.connector.client.spot.websocket.stream.model.KlineOffsetResponse;
import com.binance.connector.client.spot.websocket.stream.model.KlineRequest;
import com.binance.connector.client.spot.websocket.stream.model.KlineResponse;
import com.binance.connector.client.spot.websocket.stream.model.MiniTickerRequest;
import com.binance.connector.client.spot.websocket.stream.model.MiniTickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.PartialBookDepthRequest;
import com.binance.connector.client.spot.websocket.stream.model.PartialBookDepthResponse;
import com.binance.connector.client.spot.websocket.stream.model.RollingWindowTickerRequest;
import com.binance.connector.client.spot.websocket.stream.model.RollingWindowTickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.TickerRequest;
import com.binance.connector.client.spot.websocket.stream.model.TickerResponse;
import com.binance.connector.client.spot.websocket.stream.model.TradeRequest;
import com.binance.connector.client.spot.websocket.stream.model.TradeResponse;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class WebSocketStreamsApi {
    private StreamConnectionInterface connection;

    public WebSocketStreamsApi() {
    }

    public WebSocketStreamsApi(StreamConnectionInterface connection) {
        this.connection = connection;
    }

    public StreamBlockingQueueWrapper<AggTradeResponse> aggTrade(AggTradeRequest aggTradeRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.aggTradeRaw(aggTradeRequest);
        TypeToken<AggTradeResponse> typeToken = new TypeToken<AggTradeResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> aggTradeRaw(AggTradeRequest aggTradeRequest) throws ApiException {
        this.aggTradeValidateBeforeCall(aggTradeRequest);
        String methodName = "/<symbol>@aggTrade".substring(1).replace("<symbol>", aggTradeRequest.getSymbol() != null ? aggTradeRequest.getSymbol().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void aggTradeValidateBeforeCall(AggTradeRequest aggTradeRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)aggTradeRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<AllMarketRollingWindowTickerResponse> allMarketRollingWindowTicker(AllMarketRollingWindowTickerRequest allMarketRollingWindowTickerRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.allMarketRollingWindowTickerRaw(allMarketRollingWindowTickerRequest);
        TypeToken<AllMarketRollingWindowTickerResponse> typeToken = new TypeToken<AllMarketRollingWindowTickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> allMarketRollingWindowTickerRaw(AllMarketRollingWindowTickerRequest allMarketRollingWindowTickerRequest) throws ApiException {
        this.allMarketRollingWindowTickerValidateBeforeCall(allMarketRollingWindowTickerRequest);
        String methodName = "/!ticker_<windowSize>@arr".substring(1).replace("<windowSize>", allMarketRollingWindowTickerRequest.getWindowSize() != null ? allMarketRollingWindowTickerRequest.getWindowSize().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void allMarketRollingWindowTickerValidateBeforeCall(AllMarketRollingWindowTickerRequest allMarketRollingWindowTickerRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)allMarketRollingWindowTickerRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<AllMiniTickerResponse> allMiniTicker() throws ApiException {
        StreamBlockingQueue<String> queue = this.allMiniTickerRaw();
        TypeToken<AllMiniTickerResponse> typeToken = new TypeToken<AllMiniTickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> allMiniTickerRaw() throws ApiException {
        this.allMiniTickerValidateBeforeCall();
        String methodName = "/!miniTicker@arr".substring(1);
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void allMiniTickerValidateBeforeCall() throws ApiException {
    }

    public StreamBlockingQueueWrapper<AllTickerResponse> allTicker() throws ApiException {
        StreamBlockingQueue<String> queue = this.allTickerRaw();
        TypeToken<AllTickerResponse> typeToken = new TypeToken<AllTickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> allTickerRaw() throws ApiException {
        this.allTickerValidateBeforeCall();
        String methodName = "/!ticker@arr".substring(1);
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void allTickerValidateBeforeCall() throws ApiException {
    }

    public StreamBlockingQueueWrapper<AvgPriceResponse> avgPrice(AvgPriceRequest avgPriceRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.avgPriceRaw(avgPriceRequest);
        TypeToken<AvgPriceResponse> typeToken = new TypeToken<AvgPriceResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> avgPriceRaw(AvgPriceRequest avgPriceRequest) throws ApiException {
        this.avgPriceValidateBeforeCall(avgPriceRequest);
        String methodName = "/<symbol>@avgPrice".substring(1).replace("<symbol>", avgPriceRequest.getSymbol() != null ? avgPriceRequest.getSymbol().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void avgPriceValidateBeforeCall(AvgPriceRequest avgPriceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)avgPriceRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<BookTickerResponse> bookTicker(BookTickerRequest bookTickerRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.bookTickerRaw(bookTickerRequest);
        TypeToken<BookTickerResponse> typeToken = new TypeToken<BookTickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> bookTickerRaw(BookTickerRequest bookTickerRequest) throws ApiException {
        this.bookTickerValidateBeforeCall(bookTickerRequest);
        String methodName = "/<symbol>@bookTicker".substring(1).replace("<symbol>", bookTickerRequest.getSymbol() != null ? bookTickerRequest.getSymbol().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void bookTickerValidateBeforeCall(BookTickerRequest bookTickerRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)bookTickerRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<DiffBookDepthResponse> diffBookDepth(DiffBookDepthRequest diffBookDepthRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.diffBookDepthRaw(diffBookDepthRequest);
        TypeToken<DiffBookDepthResponse> typeToken = new TypeToken<DiffBookDepthResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> diffBookDepthRaw(DiffBookDepthRequest diffBookDepthRequest) throws ApiException {
        this.diffBookDepthValidateBeforeCall(diffBookDepthRequest);
        String methodName = "/<symbol>@depth@<updateSpeed>".substring(1).replace("<symbol>", diffBookDepthRequest.getSymbol() != null ? diffBookDepthRequest.getSymbol().toString() : "").replace("<updateSpeed>", diffBookDepthRequest.getUpdateSpeed() != null ? diffBookDepthRequest.getUpdateSpeed().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void diffBookDepthValidateBeforeCall(DiffBookDepthRequest diffBookDepthRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)diffBookDepthRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<KlineResponse> kline(KlineRequest klineRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.klineRaw(klineRequest);
        TypeToken<KlineResponse> typeToken = new TypeToken<KlineResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> klineRaw(KlineRequest klineRequest) throws ApiException {
        this.klineValidateBeforeCall(klineRequest);
        String methodName = "/<symbol>@kline_<interval>".substring(1).replace("<symbol>", klineRequest.getSymbol() != null ? klineRequest.getSymbol().toString() : "").replace("<interval>", klineRequest.getInterval() != null ? klineRequest.getInterval().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void klineValidateBeforeCall(KlineRequest klineRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)klineRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<KlineOffsetResponse> klineOffset(KlineOffsetRequest klineOffsetRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.klineOffsetRaw(klineOffsetRequest);
        TypeToken<KlineOffsetResponse> typeToken = new TypeToken<KlineOffsetResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> klineOffsetRaw(KlineOffsetRequest klineOffsetRequest) throws ApiException {
        this.klineOffsetValidateBeforeCall(klineOffsetRequest);
        String methodName = "/<symbol>@kline_<interval>@+08:00".substring(1).replace("<symbol>", klineOffsetRequest.getSymbol() != null ? klineOffsetRequest.getSymbol().toString() : "").replace("<interval>", klineOffsetRequest.getInterval() != null ? klineOffsetRequest.getInterval().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void klineOffsetValidateBeforeCall(KlineOffsetRequest klineOffsetRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)klineOffsetRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<MiniTickerResponse> miniTicker(MiniTickerRequest miniTickerRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.miniTickerRaw(miniTickerRequest);
        TypeToken<MiniTickerResponse> typeToken = new TypeToken<MiniTickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> miniTickerRaw(MiniTickerRequest miniTickerRequest) throws ApiException {
        this.miniTickerValidateBeforeCall(miniTickerRequest);
        String methodName = "/<symbol>@miniTicker".substring(1).replace("<symbol>", miniTickerRequest.getSymbol() != null ? miniTickerRequest.getSymbol().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void miniTickerValidateBeforeCall(MiniTickerRequest miniTickerRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)miniTickerRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<PartialBookDepthResponse> partialBookDepth(PartialBookDepthRequest partialBookDepthRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.partialBookDepthRaw(partialBookDepthRequest);
        TypeToken<PartialBookDepthResponse> typeToken = new TypeToken<PartialBookDepthResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> partialBookDepthRaw(PartialBookDepthRequest partialBookDepthRequest) throws ApiException {
        this.partialBookDepthValidateBeforeCall(partialBookDepthRequest);
        String methodName = "/<symbol>@depth<levels>@<updateSpeed>".substring(1).replace("<symbol>", partialBookDepthRequest.getSymbol() != null ? partialBookDepthRequest.getSymbol().toString() : "").replace("<levels>", partialBookDepthRequest.getLevels() != null ? partialBookDepthRequest.getLevels().toString() : "").replace("<updateSpeed>", partialBookDepthRequest.getUpdateSpeed() != null ? partialBookDepthRequest.getUpdateSpeed().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void partialBookDepthValidateBeforeCall(PartialBookDepthRequest partialBookDepthRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)partialBookDepthRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<RollingWindowTickerResponse> rollingWindowTicker(RollingWindowTickerRequest rollingWindowTickerRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.rollingWindowTickerRaw(rollingWindowTickerRequest);
        TypeToken<RollingWindowTickerResponse> typeToken = new TypeToken<RollingWindowTickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> rollingWindowTickerRaw(RollingWindowTickerRequest rollingWindowTickerRequest) throws ApiException {
        this.rollingWindowTickerValidateBeforeCall(rollingWindowTickerRequest);
        String methodName = "/<symbol>@ticker_<windowSize>".substring(1).replace("<symbol>", rollingWindowTickerRequest.getSymbol() != null ? rollingWindowTickerRequest.getSymbol().toString() : "").replace("<windowSize>", rollingWindowTickerRequest.getWindowSize() != null ? rollingWindowTickerRequest.getWindowSize().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void rollingWindowTickerValidateBeforeCall(RollingWindowTickerRequest rollingWindowTickerRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)rollingWindowTickerRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<TickerResponse> ticker(TickerRequest tickerRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.tickerRaw(tickerRequest);
        TypeToken<TickerResponse> typeToken = new TypeToken<TickerResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> tickerRaw(TickerRequest tickerRequest) throws ApiException {
        this.tickerValidateBeforeCall(tickerRequest);
        String methodName = "/<symbol>@ticker".substring(1).replace("<symbol>", tickerRequest.getSymbol() != null ? tickerRequest.getSymbol().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void tickerValidateBeforeCall(TickerRequest tickerRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tickerRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamBlockingQueueWrapper<TradeResponse> trade(TradeRequest tradeRequest) throws ApiException {
        StreamBlockingQueue<String> queue = this.tradeRaw(tradeRequest);
        TypeToken<TradeResponse> typeToken = new TypeToken<TradeResponse>(){};
        return new StreamBlockingQueueWrapper(queue, (TypeToken)typeToken);
    }

    public StreamBlockingQueue<String> tradeRaw(TradeRequest tradeRequest) throws ApiException {
        this.tradeValidateBeforeCall(tradeRequest);
        String methodName = "/<symbol>@trade".substring(1).replace("<symbol>", tradeRequest.getSymbol() != null ? tradeRequest.getSymbol().toString() : "");
        if ("@".equals(methodName.substring(methodName.length() - 1))) {
            methodName = methodName.substring(0, methodName.length() - 1);
        }
        RequestWrapperDTO requestWrapperDTO = new RequestWrapperDTO.Builder().id(this.getRequestID()).method("SUBSCRIBE").params(Collections.singleton(methodName)).build();
        Map queuesMap = this.connection.subscribe(requestWrapperDTO);
        return (StreamBlockingQueue)queuesMap.get(methodName);
    }

    private void tradeValidateBeforeCall(TradeRequest tradeRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)tradeRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

