/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.model;

import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.binance.connector.client.spot.websocket.api.model.Symbols;
import com.binance.connector.client.spot.websocket.api.model.TickerType;
import com.binance.connector.client.spot.websocket.api.model.WindowSize;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class TickerRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nullable
    private String symbol;
    public static final String SERIALIZED_NAME_SYMBOLS = "symbols";
    @SerializedName(value="symbols")
    @Nullable
    private Symbols symbols;
    public static final String SERIALIZED_NAME_TICKER_TYPE = "tickerType";
    @SerializedName(value="tickerType")
    @Nullable
    private TickerType tickerType;
    public static final String SERIALIZED_NAME_WINDOW_SIZE = "windowSize";
    @SerializedName(value="windowSize")
    @Nullable
    private WindowSize windowSize;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TickerRequest symbol(@Nullable String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nullable String symbol) {
        this.symbol = symbol;
    }

    public TickerRequest symbols(@Nullable Symbols symbols) {
        this.symbols = symbols;
        return this;
    }

    @Nullable
    @Valid
    public Symbols getSymbols() {
        return this.symbols;
    }

    public void setSymbols(@Nullable Symbols symbols) {
        this.symbols = symbols;
    }

    public TickerRequest tickerType(@Nullable TickerType tickerType) {
        this.tickerType = tickerType;
        return this;
    }

    @Nullable
    @Valid
    public TickerType getTickerType() {
        return this.tickerType;
    }

    public void setTickerType(@Nullable TickerType tickerType) {
        this.tickerType = tickerType;
    }

    public TickerRequest windowSize(@Nullable WindowSize windowSize) {
        this.windowSize = windowSize;
        return this;
    }

    @Nullable
    @Valid
    public WindowSize getWindowSize() {
        return this.windowSize;
    }

    public void setWindowSize(@Nullable WindowSize windowSize) {
        this.windowSize = windowSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        TickerRequest tickerRequest = (TickerRequest)((Object)o);
        return Objects.equals(this.symbol, tickerRequest.symbol) && Objects.equals(this.symbols, tickerRequest.symbols) && Objects.equals((Object)this.tickerType, (Object)tickerRequest.tickerType) && Objects.equals((Object)this.windowSize, (Object)tickerRequest.windowSize);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.symbols, this.tickerType, this.windowSize});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TickerRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\tsymbols: ").append(this.toIndentedString(this.symbols)).append("\n");
        sb.append("\t\ttickerType: ").append(this.toIndentedString((Object)this.tickerType)).append("\n");
        sb.append("\t\twindowSize: ").append(this.toIndentedString((Object)this.windowSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        WindowSize windowSizeValue;
        TickerType tickerTypeValue;
        Symbols symbolsValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((symbolsValue = this.getSymbols()) != null) {
            String symbolsValueAsString = JSON.getGson().toJson((Object)symbolsValue);
            valMap.put(SERIALIZED_NAME_SYMBOLS, symbolsValueAsString);
        }
        if ((tickerTypeValue = this.getTickerType()) != null) {
            String tickerTypeValueAsString = tickerTypeValue.toString();
            valMap.put(SERIALIZED_NAME_TICKER_TYPE, tickerTypeValueAsString);
        }
        if ((windowSizeValue = this.getWindowSize()) != null) {
            String windowSizeValueAsString = windowSizeValue.toString();
            valMap.put(SERIALIZED_NAME_WINDOW_SIZE, windowSizeValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return TickerRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        WindowSize windowSizeValue;
        TickerType tickerTypeValue;
        Symbols symbolsValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((symbolsValue = this.getSymbols()) != null) {
            valMap.put(SERIALIZED_NAME_SYMBOLS, symbolsValue);
        }
        if ((tickerTypeValue = this.getTickerType()) != null) {
            valMap.put(SERIALIZED_NAME_TICKER_TYPE, (Object)tickerTypeValue);
        }
        if ((windowSizeValue = this.getWindowSize()) != null) {
            valMap.put(SERIALIZED_NAME_WINDOW_SIZE, (Object)windowSizeValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in TickerRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `TickerRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_TICKER_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_TICKER_TYPE).isJsonNull()) {
            TickerType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TICKER_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_WINDOW_SIZE) != null && !jsonObj.get(SERIALIZED_NAME_WINDOW_SIZE).isJsonNull()) {
            WindowSize.validateJsonElement(jsonObj.get(SERIALIZED_NAME_WINDOW_SIZE));
        }
    }

    public static TickerRequest fromJson(String jsonString) throws IOException {
        return (TickerRequest)((Object)JSON.getGson().fromJson(jsonString, TickerRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_SYMBOLS);
        openapiFields.add(SERIALIZED_NAME_TICKER_TYPE);
        openapiFields.add(SERIALIZED_NAME_WINDOW_SIZE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TickerRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TickerRequest.class));
            return new TypeAdapter<TickerRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, TickerRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TickerRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (TickerRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

