/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.model;

import com.binance.connector.client.common.DecimalFormatter;
import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.binance.connector.client.spot.websocket.api.model.CancelReplaceMode;
import com.binance.connector.client.spot.websocket.api.model.CancelRestrictions;
import com.binance.connector.client.spot.websocket.api.model.NewOrderRespType;
import com.binance.connector.client.spot.websocket.api.model.OrderRateLimitExceededMode;
import com.binance.connector.client.spot.websocket.api.model.OrderType;
import com.binance.connector.client.spot.websocket.api.model.PegOffsetType;
import com.binance.connector.client.spot.websocket.api.model.PegPriceType;
import com.binance.connector.client.spot.websocket.api.model.SelfTradePreventionMode;
import com.binance.connector.client.spot.websocket.api.model.Side;
import com.binance.connector.client.spot.websocket.api.model.TimeInForce;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OrderCancelReplaceRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nonnull
    private String symbol;
    public static final String SERIALIZED_NAME_CANCEL_REPLACE_MODE = "cancelReplaceMode";
    @SerializedName(value="cancelReplaceMode")
    @Nonnull
    private CancelReplaceMode cancelReplaceMode;
    public static final String SERIALIZED_NAME_CANCEL_ORDER_ID = "cancelOrderId";
    @SerializedName(value="cancelOrderId")
    @Nullable
    private Long cancelOrderId;
    public static final String SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID = "cancelOrigClientOrderId";
    @SerializedName(value="cancelOrigClientOrderId")
    @Nullable
    private String cancelOrigClientOrderId;
    public static final String SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID = "cancelNewClientOrderId";
    @SerializedName(value="cancelNewClientOrderId")
    @Nullable
    private String cancelNewClientOrderId;
    public static final String SERIALIZED_NAME_SIDE = "side";
    @SerializedName(value="side")
    @Nonnull
    private Side side;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private OrderType type;
    public static final String SERIALIZED_NAME_TIME_IN_FORCE = "timeInForce";
    @SerializedName(value="timeInForce")
    @Nullable
    private TimeInForce timeInForce;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    @Nullable
    private Double price;
    public static final String SERIALIZED_NAME_QUANTITY = "quantity";
    @SerializedName(value="quantity")
    @Nullable
    private Double quantity;
    public static final String SERIALIZED_NAME_QUOTE_ORDER_QTY = "quoteOrderQty";
    @SerializedName(value="quoteOrderQty")
    @Nullable
    private Double quoteOrderQty;
    public static final String SERIALIZED_NAME_NEW_CLIENT_ORDER_ID = "newClientOrderId";
    @SerializedName(value="newClientOrderId")
    @Nullable
    private String newClientOrderId;
    public static final String SERIALIZED_NAME_NEW_ORDER_RESP_TYPE = "newOrderRespType";
    @SerializedName(value="newOrderRespType")
    @Nullable
    private NewOrderRespType newOrderRespType;
    public static final String SERIALIZED_NAME_STOP_PRICE = "stopPrice";
    @SerializedName(value="stopPrice")
    @Nullable
    private Double stopPrice;
    public static final String SERIALIZED_NAME_TRAILING_DELTA = "trailingDelta";
    @SerializedName(value="trailingDelta")
    @Nullable
    private Double trailingDelta;
    public static final String SERIALIZED_NAME_ICEBERG_QTY = "icebergQty";
    @SerializedName(value="icebergQty")
    @Nullable
    private Double icebergQty;
    public static final String SERIALIZED_NAME_STRATEGY_ID = "strategyId";
    @SerializedName(value="strategyId")
    @Nullable
    private Long strategyId;
    public static final String SERIALIZED_NAME_STRATEGY_TYPE = "strategyType";
    @SerializedName(value="strategyType")
    @Nullable
    private Integer strategyType;
    public static final String SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE = "selfTradePreventionMode";
    @SerializedName(value="selfTradePreventionMode")
    @Nullable
    private SelfTradePreventionMode selfTradePreventionMode;
    public static final String SERIALIZED_NAME_CANCEL_RESTRICTIONS = "cancelRestrictions";
    @SerializedName(value="cancelRestrictions")
    @Nullable
    private CancelRestrictions cancelRestrictions;
    public static final String SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE = "orderRateLimitExceededMode";
    @SerializedName(value="orderRateLimitExceededMode")
    @Nullable
    private OrderRateLimitExceededMode orderRateLimitExceededMode;
    public static final String SERIALIZED_NAME_PEG_PRICE_TYPE = "pegPriceType";
    @SerializedName(value="pegPriceType")
    @Nullable
    private PegPriceType pegPriceType;
    public static final String SERIALIZED_NAME_PEG_OFFSET_VALUE = "pegOffsetValue";
    @SerializedName(value="pegOffsetValue")
    @Nullable
    private Integer pegOffsetValue;
    public static final String SERIALIZED_NAME_PEG_OFFSET_TYPE = "pegOffsetType";
    @SerializedName(value="pegOffsetType")
    @Nullable
    private PegOffsetType pegOffsetType;
    public static final String SERIALIZED_NAME_RECV_WINDOW = "recvWindow";
    @SerializedName(value="recvWindow")
    @Nullable
    private Long recvWindow;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OrderCancelReplaceRequest symbol(@Nonnull String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nonnull String symbol) {
        this.symbol = symbol;
    }

    public OrderCancelReplaceRequest cancelReplaceMode(@Nonnull CancelReplaceMode cancelReplaceMode) {
        this.cancelReplaceMode = cancelReplaceMode;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public CancelReplaceMode getCancelReplaceMode() {
        return this.cancelReplaceMode;
    }

    public void setCancelReplaceMode(@Nonnull CancelReplaceMode cancelReplaceMode) {
        this.cancelReplaceMode = cancelReplaceMode;
    }

    public OrderCancelReplaceRequest cancelOrderId(@Nullable Long cancelOrderId) {
        this.cancelOrderId = cancelOrderId;
        return this;
    }

    @Nullable
    public Long getCancelOrderId() {
        return this.cancelOrderId;
    }

    public void setCancelOrderId(@Nullable Long cancelOrderId) {
        this.cancelOrderId = cancelOrderId;
    }

    public OrderCancelReplaceRequest cancelOrigClientOrderId(@Nullable String cancelOrigClientOrderId) {
        this.cancelOrigClientOrderId = cancelOrigClientOrderId;
        return this;
    }

    @Nullable
    public String getCancelOrigClientOrderId() {
        return this.cancelOrigClientOrderId;
    }

    public void setCancelOrigClientOrderId(@Nullable String cancelOrigClientOrderId) {
        this.cancelOrigClientOrderId = cancelOrigClientOrderId;
    }

    public OrderCancelReplaceRequest cancelNewClientOrderId(@Nullable String cancelNewClientOrderId) {
        this.cancelNewClientOrderId = cancelNewClientOrderId;
        return this;
    }

    @Nullable
    public String getCancelNewClientOrderId() {
        return this.cancelNewClientOrderId;
    }

    public void setCancelNewClientOrderId(@Nullable String cancelNewClientOrderId) {
        this.cancelNewClientOrderId = cancelNewClientOrderId;
    }

    public OrderCancelReplaceRequest side(@Nonnull Side side) {
        this.side = side;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public Side getSide() {
        return this.side;
    }

    public void setSide(@Nonnull Side side) {
        this.side = side;
    }

    public OrderCancelReplaceRequest type(@Nonnull OrderType type) {
        this.type = type;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public OrderType getType() {
        return this.type;
    }

    public void setType(@Nonnull OrderType type) {
        this.type = type;
    }

    public OrderCancelReplaceRequest timeInForce(@Nullable TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
        return this;
    }

    @Nullable
    @Valid
    public TimeInForce getTimeInForce() {
        return this.timeInForce;
    }

    public void setTimeInForce(@Nullable TimeInForce timeInForce) {
        this.timeInForce = timeInForce;
    }

    public OrderCancelReplaceRequest price(@Nullable Double price) {
        this.price = price;
        return this;
    }

    @Nullable
    @Valid
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(@Nullable Double price) {
        this.price = price;
    }

    public OrderCancelReplaceRequest quantity(@Nullable Double quantity) {
        this.quantity = quantity;
        return this;
    }

    @Nullable
    @Valid
    public Double getQuantity() {
        return this.quantity;
    }

    public void setQuantity(@Nullable Double quantity) {
        this.quantity = quantity;
    }

    public OrderCancelReplaceRequest quoteOrderQty(@Nullable Double quoteOrderQty) {
        this.quoteOrderQty = quoteOrderQty;
        return this;
    }

    @Nullable
    @Valid
    public Double getQuoteOrderQty() {
        return this.quoteOrderQty;
    }

    public void setQuoteOrderQty(@Nullable Double quoteOrderQty) {
        this.quoteOrderQty = quoteOrderQty;
    }

    public OrderCancelReplaceRequest newClientOrderId(@Nullable String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
        return this;
    }

    @Nullable
    public String getNewClientOrderId() {
        return this.newClientOrderId;
    }

    public void setNewClientOrderId(@Nullable String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
    }

    public OrderCancelReplaceRequest newOrderRespType(@Nullable NewOrderRespType newOrderRespType) {
        this.newOrderRespType = newOrderRespType;
        return this;
    }

    @Nullable
    @Valid
    public NewOrderRespType getNewOrderRespType() {
        return this.newOrderRespType;
    }

    public void setNewOrderRespType(@Nullable NewOrderRespType newOrderRespType) {
        this.newOrderRespType = newOrderRespType;
    }

    public OrderCancelReplaceRequest stopPrice(@Nullable Double stopPrice) {
        this.stopPrice = stopPrice;
        return this;
    }

    @Nullable
    @Valid
    public Double getStopPrice() {
        return this.stopPrice;
    }

    public void setStopPrice(@Nullable Double stopPrice) {
        this.stopPrice = stopPrice;
    }

    public OrderCancelReplaceRequest trailingDelta(@Nullable Double trailingDelta) {
        this.trailingDelta = trailingDelta;
        return this;
    }

    @Nullable
    @Valid
    public Double getTrailingDelta() {
        return this.trailingDelta;
    }

    public void setTrailingDelta(@Nullable Double trailingDelta) {
        this.trailingDelta = trailingDelta;
    }

    public OrderCancelReplaceRequest icebergQty(@Nullable Double icebergQty) {
        this.icebergQty = icebergQty;
        return this;
    }

    @Nullable
    @Valid
    public Double getIcebergQty() {
        return this.icebergQty;
    }

    public void setIcebergQty(@Nullable Double icebergQty) {
        this.icebergQty = icebergQty;
    }

    public OrderCancelReplaceRequest strategyId(@Nullable Long strategyId) {
        this.strategyId = strategyId;
        return this;
    }

    @Nullable
    public Long getStrategyId() {
        return this.strategyId;
    }

    public void setStrategyId(@Nullable Long strategyId) {
        this.strategyId = strategyId;
    }

    public OrderCancelReplaceRequest strategyType(@Nullable Integer strategyType) {
        this.strategyType = strategyType;
        return this;
    }

    @Nullable
    public Integer getStrategyType() {
        return this.strategyType;
    }

    public void setStrategyType(@Nullable Integer strategyType) {
        this.strategyType = strategyType;
    }

    public OrderCancelReplaceRequest selfTradePreventionMode(@Nullable SelfTradePreventionMode selfTradePreventionMode) {
        this.selfTradePreventionMode = selfTradePreventionMode;
        return this;
    }

    @Nullable
    @Valid
    public SelfTradePreventionMode getSelfTradePreventionMode() {
        return this.selfTradePreventionMode;
    }

    public void setSelfTradePreventionMode(@Nullable SelfTradePreventionMode selfTradePreventionMode) {
        this.selfTradePreventionMode = selfTradePreventionMode;
    }

    public OrderCancelReplaceRequest cancelRestrictions(@Nullable CancelRestrictions cancelRestrictions) {
        this.cancelRestrictions = cancelRestrictions;
        return this;
    }

    @Nullable
    @Valid
    public CancelRestrictions getCancelRestrictions() {
        return this.cancelRestrictions;
    }

    public void setCancelRestrictions(@Nullable CancelRestrictions cancelRestrictions) {
        this.cancelRestrictions = cancelRestrictions;
    }

    public OrderCancelReplaceRequest orderRateLimitExceededMode(@Nullable OrderRateLimitExceededMode orderRateLimitExceededMode) {
        this.orderRateLimitExceededMode = orderRateLimitExceededMode;
        return this;
    }

    @Nullable
    @Valid
    public OrderRateLimitExceededMode getOrderRateLimitExceededMode() {
        return this.orderRateLimitExceededMode;
    }

    public void setOrderRateLimitExceededMode(@Nullable OrderRateLimitExceededMode orderRateLimitExceededMode) {
        this.orderRateLimitExceededMode = orderRateLimitExceededMode;
    }

    public OrderCancelReplaceRequest pegPriceType(@Nullable PegPriceType pegPriceType) {
        this.pegPriceType = pegPriceType;
        return this;
    }

    @Nullable
    @Valid
    public PegPriceType getPegPriceType() {
        return this.pegPriceType;
    }

    public void setPegPriceType(@Nullable PegPriceType pegPriceType) {
        this.pegPriceType = pegPriceType;
    }

    public OrderCancelReplaceRequest pegOffsetValue(@Nullable Integer pegOffsetValue) {
        this.pegOffsetValue = pegOffsetValue;
        return this;
    }

    @Nullable
    public Integer getPegOffsetValue() {
        return this.pegOffsetValue;
    }

    public void setPegOffsetValue(@Nullable Integer pegOffsetValue) {
        this.pegOffsetValue = pegOffsetValue;
    }

    public OrderCancelReplaceRequest pegOffsetType(@Nullable PegOffsetType pegOffsetType) {
        this.pegOffsetType = pegOffsetType;
        return this;
    }

    @Nullable
    @Valid
    public PegOffsetType getPegOffsetType() {
        return this.pegOffsetType;
    }

    public void setPegOffsetType(@Nullable PegOffsetType pegOffsetType) {
        this.pegOffsetType = pegOffsetType;
    }

    public OrderCancelReplaceRequest recvWindow(@Nullable Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    @Nullable
    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public void setRecvWindow(@Nullable Long recvWindow) {
        this.recvWindow = recvWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OrderCancelReplaceRequest orderCancelReplaceRequest = (OrderCancelReplaceRequest)((Object)o);
        return Objects.equals(this.symbol, orderCancelReplaceRequest.symbol) && Objects.equals((Object)this.cancelReplaceMode, (Object)orderCancelReplaceRequest.cancelReplaceMode) && Objects.equals(this.cancelOrderId, orderCancelReplaceRequest.cancelOrderId) && Objects.equals(this.cancelOrigClientOrderId, orderCancelReplaceRequest.cancelOrigClientOrderId) && Objects.equals(this.cancelNewClientOrderId, orderCancelReplaceRequest.cancelNewClientOrderId) && Objects.equals((Object)this.side, (Object)orderCancelReplaceRequest.side) && Objects.equals((Object)this.type, (Object)orderCancelReplaceRequest.type) && Objects.equals((Object)this.timeInForce, (Object)orderCancelReplaceRequest.timeInForce) && Objects.equals(this.price, orderCancelReplaceRequest.price) && Objects.equals(this.quantity, orderCancelReplaceRequest.quantity) && Objects.equals(this.quoteOrderQty, orderCancelReplaceRequest.quoteOrderQty) && Objects.equals(this.newClientOrderId, orderCancelReplaceRequest.newClientOrderId) && Objects.equals((Object)this.newOrderRespType, (Object)orderCancelReplaceRequest.newOrderRespType) && Objects.equals(this.stopPrice, orderCancelReplaceRequest.stopPrice) && Objects.equals(this.trailingDelta, orderCancelReplaceRequest.trailingDelta) && Objects.equals(this.icebergQty, orderCancelReplaceRequest.icebergQty) && Objects.equals(this.strategyId, orderCancelReplaceRequest.strategyId) && Objects.equals(this.strategyType, orderCancelReplaceRequest.strategyType) && Objects.equals((Object)this.selfTradePreventionMode, (Object)orderCancelReplaceRequest.selfTradePreventionMode) && Objects.equals((Object)this.cancelRestrictions, (Object)orderCancelReplaceRequest.cancelRestrictions) && Objects.equals((Object)this.orderRateLimitExceededMode, (Object)orderCancelReplaceRequest.orderRateLimitExceededMode) && Objects.equals((Object)this.pegPriceType, (Object)orderCancelReplaceRequest.pegPriceType) && Objects.equals(this.pegOffsetValue, orderCancelReplaceRequest.pegOffsetValue) && Objects.equals((Object)this.pegOffsetType, (Object)orderCancelReplaceRequest.pegOffsetType) && Objects.equals(this.recvWindow, orderCancelReplaceRequest.recvWindow);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.cancelReplaceMode, this.cancelOrderId, this.cancelOrigClientOrderId, this.cancelNewClientOrderId, this.side, this.type, this.timeInForce, this.price, this.quantity, this.quoteOrderQty, this.newClientOrderId, this.newOrderRespType, this.stopPrice, this.trailingDelta, this.icebergQty, this.strategyId, this.strategyType, this.selfTradePreventionMode, this.cancelRestrictions, this.orderRateLimitExceededMode, this.pegPriceType, this.pegOffsetValue, this.pegOffsetType, this.recvWindow});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderCancelReplaceRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\tcancelReplaceMode: ").append(this.toIndentedString((Object)this.cancelReplaceMode)).append("\n");
        sb.append("\t\tcancelOrderId: ").append(this.toIndentedString(this.cancelOrderId)).append("\n");
        sb.append("\t\tcancelOrigClientOrderId: ").append(this.toIndentedString(this.cancelOrigClientOrderId)).append("\n");
        sb.append("\t\tcancelNewClientOrderId: ").append(this.toIndentedString(this.cancelNewClientOrderId)).append("\n");
        sb.append("\t\tside: ").append(this.toIndentedString((Object)this.side)).append("\n");
        sb.append("\t\ttype: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("\t\ttimeInForce: ").append(this.toIndentedString((Object)this.timeInForce)).append("\n");
        sb.append("\t\tprice: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("\t\tquantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("\t\tquoteOrderQty: ").append(this.toIndentedString(this.quoteOrderQty)).append("\n");
        sb.append("\t\tnewClientOrderId: ").append(this.toIndentedString(this.newClientOrderId)).append("\n");
        sb.append("\t\tnewOrderRespType: ").append(this.toIndentedString((Object)this.newOrderRespType)).append("\n");
        sb.append("\t\tstopPrice: ").append(this.toIndentedString(this.stopPrice)).append("\n");
        sb.append("\t\ttrailingDelta: ").append(this.toIndentedString(this.trailingDelta)).append("\n");
        sb.append("\t\ticebergQty: ").append(this.toIndentedString(this.icebergQty)).append("\n");
        sb.append("\t\tstrategyId: ").append(this.toIndentedString(this.strategyId)).append("\n");
        sb.append("\t\tstrategyType: ").append(this.toIndentedString(this.strategyType)).append("\n");
        sb.append("\t\tselfTradePreventionMode: ").append(this.toIndentedString((Object)this.selfTradePreventionMode)).append("\n");
        sb.append("\t\tcancelRestrictions: ").append(this.toIndentedString((Object)this.cancelRestrictions)).append("\n");
        sb.append("\t\torderRateLimitExceededMode: ").append(this.toIndentedString((Object)this.orderRateLimitExceededMode)).append("\n");
        sb.append("\t\tpegPriceType: ").append(this.toIndentedString((Object)this.pegPriceType)).append("\n");
        sb.append("\t\tpegOffsetValue: ").append(this.toIndentedString(this.pegOffsetValue)).append("\n");
        sb.append("\t\tpegOffsetType: ").append(this.toIndentedString((Object)this.pegOffsetType)).append("\n");
        sb.append("\t\trecvWindow: ").append(this.toIndentedString(this.recvWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        Long recvWindowValue;
        PegOffsetType pegOffsetTypeValue;
        Integer pegOffsetValueValue;
        PegPriceType pegPriceTypeValue;
        OrderRateLimitExceededMode orderRateLimitExceededModeValue;
        CancelRestrictions cancelRestrictionsValue;
        SelfTradePreventionMode selfTradePreventionModeValue;
        Integer strategyTypeValue;
        Long strategyIdValue;
        Double icebergQtyValue;
        Double trailingDeltaValue;
        Double stopPriceValue;
        NewOrderRespType newOrderRespTypeValue;
        String newClientOrderIdValue;
        Double quoteOrderQtyValue;
        Double quantityValue;
        Double priceValue;
        TimeInForce timeInForceValue;
        OrderType typeValue;
        Side sideValue;
        String cancelNewClientOrderIdValue;
        String cancelOrigClientOrderIdValue;
        Long cancelOrderIdValue;
        CancelReplaceMode cancelReplaceModeValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((cancelReplaceModeValue = this.getCancelReplaceMode()) != null) {
            String cancelReplaceModeValueAsString = cancelReplaceModeValue.toString();
            valMap.put(SERIALIZED_NAME_CANCEL_REPLACE_MODE, cancelReplaceModeValueAsString);
        }
        if ((cancelOrderIdValue = this.getCancelOrderId()) != null) {
            String cancelOrderIdValueAsString = cancelOrderIdValue.toString();
            valMap.put(SERIALIZED_NAME_CANCEL_ORDER_ID, cancelOrderIdValueAsString);
        }
        if ((cancelOrigClientOrderIdValue = this.getCancelOrigClientOrderId()) != null) {
            String cancelOrigClientOrderIdValueAsString = cancelOrigClientOrderIdValue.toString();
            valMap.put(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID, cancelOrigClientOrderIdValueAsString);
        }
        if ((cancelNewClientOrderIdValue = this.getCancelNewClientOrderId()) != null) {
            String cancelNewClientOrderIdValueAsString = cancelNewClientOrderIdValue.toString();
            valMap.put(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID, cancelNewClientOrderIdValueAsString);
        }
        if ((sideValue = this.getSide()) != null) {
            String sideValueAsString = sideValue.toString();
            valMap.put(SERIALIZED_NAME_SIDE, sideValueAsString);
        }
        if ((typeValue = this.getType()) != null) {
            String typeValueAsString = typeValue.toString();
            valMap.put(SERIALIZED_NAME_TYPE, typeValueAsString);
        }
        if ((timeInForceValue = this.getTimeInForce()) != null) {
            String timeInForceValueAsString = timeInForceValue.toString();
            valMap.put(SERIALIZED_NAME_TIME_IN_FORCE, timeInForceValueAsString);
        }
        if ((priceValue = this.getPrice()) != null) {
            String priceValueAsString = DecimalFormatter.getFormatter().format(priceValue);
            valMap.put(SERIALIZED_NAME_PRICE, priceValueAsString);
        }
        if ((quantityValue = this.getQuantity()) != null) {
            String quantityValueAsString = DecimalFormatter.getFormatter().format(quantityValue);
            valMap.put(SERIALIZED_NAME_QUANTITY, quantityValueAsString);
        }
        if ((quoteOrderQtyValue = this.getQuoteOrderQty()) != null) {
            String quoteOrderQtyValueAsString = DecimalFormatter.getFormatter().format(quoteOrderQtyValue);
            valMap.put(SERIALIZED_NAME_QUOTE_ORDER_QTY, quoteOrderQtyValueAsString);
        }
        if ((newClientOrderIdValue = this.getNewClientOrderId()) != null) {
            String newClientOrderIdValueAsString = newClientOrderIdValue.toString();
            valMap.put(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID, newClientOrderIdValueAsString);
        }
        if ((newOrderRespTypeValue = this.getNewOrderRespType()) != null) {
            String newOrderRespTypeValueAsString = newOrderRespTypeValue.toString();
            valMap.put(SERIALIZED_NAME_NEW_ORDER_RESP_TYPE, newOrderRespTypeValueAsString);
        }
        if ((stopPriceValue = this.getStopPrice()) != null) {
            String stopPriceValueAsString = DecimalFormatter.getFormatter().format(stopPriceValue);
            valMap.put(SERIALIZED_NAME_STOP_PRICE, stopPriceValueAsString);
        }
        if ((trailingDeltaValue = this.getTrailingDelta()) != null) {
            String trailingDeltaValueAsString = DecimalFormatter.getFormatter().format(trailingDeltaValue);
            valMap.put(SERIALIZED_NAME_TRAILING_DELTA, trailingDeltaValueAsString);
        }
        if ((icebergQtyValue = this.getIcebergQty()) != null) {
            String icebergQtyValueAsString = DecimalFormatter.getFormatter().format(icebergQtyValue);
            valMap.put(SERIALIZED_NAME_ICEBERG_QTY, icebergQtyValueAsString);
        }
        if ((strategyIdValue = this.getStrategyId()) != null) {
            String strategyIdValueAsString = strategyIdValue.toString();
            valMap.put(SERIALIZED_NAME_STRATEGY_ID, strategyIdValueAsString);
        }
        if ((strategyTypeValue = this.getStrategyType()) != null) {
            String strategyTypeValueAsString = strategyTypeValue.toString();
            valMap.put(SERIALIZED_NAME_STRATEGY_TYPE, strategyTypeValueAsString);
        }
        if ((selfTradePreventionModeValue = this.getSelfTradePreventionMode()) != null) {
            String selfTradePreventionModeValueAsString = selfTradePreventionModeValue.toString();
            valMap.put(SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE, selfTradePreventionModeValueAsString);
        }
        if ((cancelRestrictionsValue = this.getCancelRestrictions()) != null) {
            String cancelRestrictionsValueAsString = cancelRestrictionsValue.toString();
            valMap.put(SERIALIZED_NAME_CANCEL_RESTRICTIONS, cancelRestrictionsValueAsString);
        }
        if ((orderRateLimitExceededModeValue = this.getOrderRateLimitExceededMode()) != null) {
            String orderRateLimitExceededModeValueAsString = orderRateLimitExceededModeValue.toString();
            valMap.put(SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE, orderRateLimitExceededModeValueAsString);
        }
        if ((pegPriceTypeValue = this.getPegPriceType()) != null) {
            String pegPriceTypeValueAsString = pegPriceTypeValue.toString();
            valMap.put(SERIALIZED_NAME_PEG_PRICE_TYPE, pegPriceTypeValueAsString);
        }
        if ((pegOffsetValueValue = this.getPegOffsetValue()) != null) {
            String pegOffsetValueValueAsString = pegOffsetValueValue.toString();
            valMap.put(SERIALIZED_NAME_PEG_OFFSET_VALUE, pegOffsetValueValueAsString);
        }
        if ((pegOffsetTypeValue = this.getPegOffsetType()) != null) {
            String pegOffsetTypeValueAsString = pegOffsetTypeValue.toString();
            valMap.put(SERIALIZED_NAME_PEG_OFFSET_TYPE, pegOffsetTypeValueAsString);
        }
        if ((recvWindowValue = this.getRecvWindow()) != null) {
            String recvWindowValueAsString = recvWindowValue.toString();
            valMap.put(SERIALIZED_NAME_RECV_WINDOW, recvWindowValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return OrderCancelReplaceRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        Long recvWindowValue;
        PegOffsetType pegOffsetTypeValue;
        Integer pegOffsetValueValue;
        PegPriceType pegPriceTypeValue;
        OrderRateLimitExceededMode orderRateLimitExceededModeValue;
        CancelRestrictions cancelRestrictionsValue;
        SelfTradePreventionMode selfTradePreventionModeValue;
        Integer strategyTypeValue;
        Long strategyIdValue;
        Double icebergQtyValue;
        Double trailingDeltaValue;
        Double stopPriceValue;
        NewOrderRespType newOrderRespTypeValue;
        String newClientOrderIdValue;
        Double quoteOrderQtyValue;
        Double quantityValue;
        Double priceValue;
        TimeInForce timeInForceValue;
        OrderType typeValue;
        Side sideValue;
        String cancelNewClientOrderIdValue;
        String cancelOrigClientOrderIdValue;
        Long cancelOrderIdValue;
        CancelReplaceMode cancelReplaceModeValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((cancelReplaceModeValue = this.getCancelReplaceMode()) != null) {
            valMap.put(SERIALIZED_NAME_CANCEL_REPLACE_MODE, (Object)cancelReplaceModeValue);
        }
        if ((cancelOrderIdValue = this.getCancelOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_CANCEL_ORDER_ID, cancelOrderIdValue);
        }
        if ((cancelOrigClientOrderIdValue = this.getCancelOrigClientOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID, cancelOrigClientOrderIdValue);
        }
        if ((cancelNewClientOrderIdValue = this.getCancelNewClientOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID, cancelNewClientOrderIdValue);
        }
        if ((sideValue = this.getSide()) != null) {
            valMap.put(SERIALIZED_NAME_SIDE, (Object)sideValue);
        }
        if ((typeValue = this.getType()) != null) {
            valMap.put(SERIALIZED_NAME_TYPE, (Object)typeValue);
        }
        if ((timeInForceValue = this.getTimeInForce()) != null) {
            valMap.put(SERIALIZED_NAME_TIME_IN_FORCE, (Object)timeInForceValue);
        }
        if ((priceValue = this.getPrice()) != null) {
            valMap.put(SERIALIZED_NAME_PRICE, priceValue);
        }
        if ((quantityValue = this.getQuantity()) != null) {
            valMap.put(SERIALIZED_NAME_QUANTITY, quantityValue);
        }
        if ((quoteOrderQtyValue = this.getQuoteOrderQty()) != null) {
            valMap.put(SERIALIZED_NAME_QUOTE_ORDER_QTY, quoteOrderQtyValue);
        }
        if ((newClientOrderIdValue = this.getNewClientOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID, newClientOrderIdValue);
        }
        if ((newOrderRespTypeValue = this.getNewOrderRespType()) != null) {
            valMap.put(SERIALIZED_NAME_NEW_ORDER_RESP_TYPE, (Object)newOrderRespTypeValue);
        }
        if ((stopPriceValue = this.getStopPrice()) != null) {
            valMap.put(SERIALIZED_NAME_STOP_PRICE, stopPriceValue);
        }
        if ((trailingDeltaValue = this.getTrailingDelta()) != null) {
            valMap.put(SERIALIZED_NAME_TRAILING_DELTA, trailingDeltaValue);
        }
        if ((icebergQtyValue = this.getIcebergQty()) != null) {
            valMap.put(SERIALIZED_NAME_ICEBERG_QTY, icebergQtyValue);
        }
        if ((strategyIdValue = this.getStrategyId()) != null) {
            valMap.put(SERIALIZED_NAME_STRATEGY_ID, strategyIdValue);
        }
        if ((strategyTypeValue = this.getStrategyType()) != null) {
            valMap.put(SERIALIZED_NAME_STRATEGY_TYPE, strategyTypeValue);
        }
        if ((selfTradePreventionModeValue = this.getSelfTradePreventionMode()) != null) {
            valMap.put(SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE, (Object)selfTradePreventionModeValue);
        }
        if ((cancelRestrictionsValue = this.getCancelRestrictions()) != null) {
            valMap.put(SERIALIZED_NAME_CANCEL_RESTRICTIONS, (Object)cancelRestrictionsValue);
        }
        if ((orderRateLimitExceededModeValue = this.getOrderRateLimitExceededMode()) != null) {
            valMap.put(SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE, (Object)orderRateLimitExceededModeValue);
        }
        if ((pegPriceTypeValue = this.getPegPriceType()) != null) {
            valMap.put(SERIALIZED_NAME_PEG_PRICE_TYPE, (Object)pegPriceTypeValue);
        }
        if ((pegOffsetValueValue = this.getPegOffsetValue()) != null) {
            valMap.put(SERIALIZED_NAME_PEG_OFFSET_VALUE, pegOffsetValueValue);
        }
        if ((pegOffsetTypeValue = this.getPegOffsetType()) != null) {
            valMap.put(SERIALIZED_NAME_PEG_OFFSET_TYPE, (Object)pegOffsetTypeValue);
        }
        if ((recvWindowValue = this.getRecvWindow()) != null) {
            valMap.put(SERIALIZED_NAME_RECV_WINDOW, recvWindowValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OrderCancelReplaceRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OrderCancelReplaceRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        CancelReplaceMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CANCEL_REPLACE_MODE));
        if (jsonObj.get(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cancelOrigClientOrderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `cancelNewClientOrderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID).toString()));
        }
        Side.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SIDE));
        OrderType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE).isJsonNull()) {
            TimeInForce.validateJsonElement(jsonObj.get(SERIALIZED_NAME_TIME_IN_FORCE));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `newClientOrderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEW_ORDER_RESP_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_NEW_ORDER_RESP_TYPE).isJsonNull()) {
            NewOrderRespType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_NEW_ORDER_RESP_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE) != null && !jsonObj.get(SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE).isJsonNull()) {
            SelfTradePreventionMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_CANCEL_RESTRICTIONS) != null && !jsonObj.get(SERIALIZED_NAME_CANCEL_RESTRICTIONS).isJsonNull()) {
            CancelRestrictions.validateJsonElement(jsonObj.get(SERIALIZED_NAME_CANCEL_RESTRICTIONS));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE) != null && !jsonObj.get(SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE).isJsonNull()) {
            OrderRateLimitExceededMode.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE));
        }
        if (jsonObj.get(SERIALIZED_NAME_PEG_PRICE_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PEG_PRICE_TYPE).isJsonNull()) {
            PegPriceType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PEG_PRICE_TYPE));
        }
        if (jsonObj.get(SERIALIZED_NAME_PEG_OFFSET_TYPE) != null && !jsonObj.get(SERIALIZED_NAME_PEG_OFFSET_TYPE).isJsonNull()) {
            PegOffsetType.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PEG_OFFSET_TYPE));
        }
    }

    public static OrderCancelReplaceRequest fromJson(String jsonString) throws IOException {
        return (OrderCancelReplaceRequest)((Object)JSON.getGson().fromJson(jsonString, OrderCancelReplaceRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_CANCEL_REPLACE_MODE);
        openapiFields.add(SERIALIZED_NAME_CANCEL_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_CANCEL_ORIG_CLIENT_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_CANCEL_NEW_CLIENT_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_SIDE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiFields.add(SERIALIZED_NAME_TIME_IN_FORCE);
        openapiFields.add(SERIALIZED_NAME_PRICE);
        openapiFields.add(SERIALIZED_NAME_QUANTITY);
        openapiFields.add(SERIALIZED_NAME_QUOTE_ORDER_QTY);
        openapiFields.add(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_NEW_ORDER_RESP_TYPE);
        openapiFields.add(SERIALIZED_NAME_STOP_PRICE);
        openapiFields.add(SERIALIZED_NAME_TRAILING_DELTA);
        openapiFields.add(SERIALIZED_NAME_ICEBERG_QTY);
        openapiFields.add(SERIALIZED_NAME_STRATEGY_ID);
        openapiFields.add(SERIALIZED_NAME_STRATEGY_TYPE);
        openapiFields.add(SERIALIZED_NAME_SELF_TRADE_PREVENTION_MODE);
        openapiFields.add(SERIALIZED_NAME_CANCEL_RESTRICTIONS);
        openapiFields.add(SERIALIZED_NAME_ORDER_RATE_LIMIT_EXCEEDED_MODE);
        openapiFields.add(SERIALIZED_NAME_PEG_PRICE_TYPE);
        openapiFields.add(SERIALIZED_NAME_PEG_OFFSET_VALUE);
        openapiFields.add(SERIALIZED_NAME_PEG_OFFSET_TYPE);
        openapiFields.add(SERIALIZED_NAME_RECV_WINDOW);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_CANCEL_REPLACE_MODE);
        openapiRequiredFields.add(SERIALIZED_NAME_SIDE);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OrderCancelReplaceRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OrderCancelReplaceRequest.class));
            return new TypeAdapter<OrderCancelReplaceRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, OrderCancelReplaceRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OrderCancelReplaceRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (OrderCancelReplaceRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

