/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.model;

import com.binance.connector.client.common.DecimalFormatter;
import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OrderAmendKeepPriorityRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nonnull
    private String symbol;
    public static final String SERIALIZED_NAME_ORDER_ID = "orderId";
    @SerializedName(value="orderId")
    @Nullable
    private Long orderId;
    public static final String SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID = "origClientOrderId";
    @SerializedName(value="origClientOrderId")
    @Nullable
    private String origClientOrderId;
    public static final String SERIALIZED_NAME_NEW_CLIENT_ORDER_ID = "newClientOrderId";
    @SerializedName(value="newClientOrderId")
    @Nullable
    private String newClientOrderId;
    public static final String SERIALIZED_NAME_NEW_QTY = "newQty";
    @SerializedName(value="newQty")
    @Nonnull
    private Double newQty;
    public static final String SERIALIZED_NAME_RECV_WINDOW = "recvWindow";
    @SerializedName(value="recvWindow")
    @Nullable
    private Long recvWindow;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OrderAmendKeepPriorityRequest symbol(@Nonnull String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nonnull String symbol) {
        this.symbol = symbol;
    }

    public OrderAmendKeepPriorityRequest orderId(@Nullable Long orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nullable
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(@Nullable Long orderId) {
        this.orderId = orderId;
    }

    public OrderAmendKeepPriorityRequest origClientOrderId(@Nullable String origClientOrderId) {
        this.origClientOrderId = origClientOrderId;
        return this;
    }

    @Nullable
    public String getOrigClientOrderId() {
        return this.origClientOrderId;
    }

    public void setOrigClientOrderId(@Nullable String origClientOrderId) {
        this.origClientOrderId = origClientOrderId;
    }

    public OrderAmendKeepPriorityRequest newClientOrderId(@Nullable String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
        return this;
    }

    @Nullable
    public String getNewClientOrderId() {
        return this.newClientOrderId;
    }

    public void setNewClientOrderId(@Nullable String newClientOrderId) {
        this.newClientOrderId = newClientOrderId;
    }

    public OrderAmendKeepPriorityRequest newQty(@Nonnull Double newQty) {
        this.newQty = newQty;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public Double getNewQty() {
        return this.newQty;
    }

    public void setNewQty(@Nonnull Double newQty) {
        this.newQty = newQty;
    }

    public OrderAmendKeepPriorityRequest recvWindow(@Nullable Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    @Nullable
    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public void setRecvWindow(@Nullable Long recvWindow) {
        this.recvWindow = recvWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest = (OrderAmendKeepPriorityRequest)((Object)o);
        return Objects.equals(this.symbol, orderAmendKeepPriorityRequest.symbol) && Objects.equals(this.orderId, orderAmendKeepPriorityRequest.orderId) && Objects.equals(this.origClientOrderId, orderAmendKeepPriorityRequest.origClientOrderId) && Objects.equals(this.newClientOrderId, orderAmendKeepPriorityRequest.newClientOrderId) && Objects.equals(this.newQty, orderAmendKeepPriorityRequest.newQty) && Objects.equals(this.recvWindow, orderAmendKeepPriorityRequest.recvWindow);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.orderId, this.origClientOrderId, this.newClientOrderId, this.newQty, this.recvWindow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderAmendKeepPriorityRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\torderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("\t\torigClientOrderId: ").append(this.toIndentedString(this.origClientOrderId)).append("\n");
        sb.append("\t\tnewClientOrderId: ").append(this.toIndentedString(this.newClientOrderId)).append("\n");
        sb.append("\t\tnewQty: ").append(this.toIndentedString(this.newQty)).append("\n");
        sb.append("\t\trecvWindow: ").append(this.toIndentedString(this.recvWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        Long recvWindowValue;
        Double newQtyValue;
        String newClientOrderIdValue;
        String origClientOrderIdValue;
        Long orderIdValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((orderIdValue = this.getOrderId()) != null) {
            String orderIdValueAsString = orderIdValue.toString();
            valMap.put(SERIALIZED_NAME_ORDER_ID, orderIdValueAsString);
        }
        if ((origClientOrderIdValue = this.getOrigClientOrderId()) != null) {
            String origClientOrderIdValueAsString = origClientOrderIdValue.toString();
            valMap.put(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID, origClientOrderIdValueAsString);
        }
        if ((newClientOrderIdValue = this.getNewClientOrderId()) != null) {
            String newClientOrderIdValueAsString = newClientOrderIdValue.toString();
            valMap.put(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID, newClientOrderIdValueAsString);
        }
        if ((newQtyValue = this.getNewQty()) != null) {
            String newQtyValueAsString = DecimalFormatter.getFormatter().format(newQtyValue);
            valMap.put(SERIALIZED_NAME_NEW_QTY, newQtyValueAsString);
        }
        if ((recvWindowValue = this.getRecvWindow()) != null) {
            String recvWindowValueAsString = recvWindowValue.toString();
            valMap.put(SERIALIZED_NAME_RECV_WINDOW, recvWindowValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return OrderAmendKeepPriorityRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        Long recvWindowValue;
        Double newQtyValue;
        String newClientOrderIdValue;
        String origClientOrderIdValue;
        Long orderIdValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((orderIdValue = this.getOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_ORDER_ID, orderIdValue);
        }
        if ((origClientOrderIdValue = this.getOrigClientOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID, origClientOrderIdValue);
        }
        if ((newClientOrderIdValue = this.getNewClientOrderId()) != null) {
            valMap.put(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID, newClientOrderIdValue);
        }
        if ((newQtyValue = this.getNewQty()) != null) {
            valMap.put(SERIALIZED_NAME_NEW_QTY, newQtyValue);
        }
        if ((recvWindowValue = this.getRecvWindow()) != null) {
            valMap.put(SERIALIZED_NAME_RECV_WINDOW, recvWindowValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OrderAmendKeepPriorityRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OrderAmendKeepPriorityRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `origClientOrderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID) != null && !jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `newClientOrderId` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID).toString()));
        }
    }

    public static OrderAmendKeepPriorityRequest fromJson(String jsonString) throws IOException {
        return (OrderAmendKeepPriorityRequest)((Object)JSON.getGson().fromJson(jsonString, OrderAmendKeepPriorityRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_ORIG_CLIENT_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_NEW_CLIENT_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_NEW_QTY);
        openapiFields.add(SERIALIZED_NAME_RECV_WINDOW);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_NEW_QTY);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OrderAmendKeepPriorityRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OrderAmendKeepPriorityRequest.class));
            return new TypeAdapter<OrderAmendKeepPriorityRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, OrderAmendKeepPriorityRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OrderAmendKeepPriorityRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (OrderAmendKeepPriorityRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

