/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.model;

import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class OpenOrdersStatusRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nullable
    private String symbol;
    public static final String SERIALIZED_NAME_RECV_WINDOW = "recvWindow";
    @SerializedName(value="recvWindow")
    @Nullable
    private Long recvWindow;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public OpenOrdersStatusRequest symbol(@Nullable String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nullable
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nullable String symbol) {
        this.symbol = symbol;
    }

    public OpenOrdersStatusRequest recvWindow(@Nullable Long recvWindow) {
        this.recvWindow = recvWindow;
        return this;
    }

    @Nullable
    public Long getRecvWindow() {
        return this.recvWindow;
    }

    public void setRecvWindow(@Nullable Long recvWindow) {
        this.recvWindow = recvWindow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        OpenOrdersStatusRequest openOrdersStatusRequest = (OpenOrdersStatusRequest)((Object)o);
        return Objects.equals(this.symbol, openOrdersStatusRequest.symbol) && Objects.equals(this.recvWindow, openOrdersStatusRequest.recvWindow);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.recvWindow);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OpenOrdersStatusRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\trecvWindow: ").append(this.toIndentedString(this.recvWindow)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        Long recvWindowValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((recvWindowValue = this.getRecvWindow()) != null) {
            String recvWindowValueAsString = recvWindowValue.toString();
            valMap.put(SERIALIZED_NAME_RECV_WINDOW, recvWindowValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return OpenOrdersStatusRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        Long recvWindowValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((recvWindowValue = this.getRecvWindow()) != null) {
            valMap.put(SERIALIZED_NAME_RECV_WINDOW, recvWindowValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in OpenOrdersStatusRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `OpenOrdersStatusRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_SYMBOL) != null && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
    }

    public static OpenOrdersStatusRequest fromJson(String jsonString) throws IOException {
        return (OpenOrdersStatusRequest)((Object)JSON.getGson().fromJson(jsonString, OpenOrdersStatusRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_RECV_WINDOW);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!OpenOrdersStatusRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(OpenOrdersStatusRequest.class));
            return new TypeAdapter<OpenOrdersStatusRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, OpenOrdersStatusRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public OpenOrdersStatusRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (OpenOrdersStatusRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

