/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.model;

import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.binance.connector.client.spot.websocket.api.model.Interval;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class KlinesRequest
extends BaseDTO {
    public static final String SERIALIZED_NAME_SYMBOL = "symbol";
    @SerializedName(value="symbol")
    @Nonnull
    private String symbol;
    public static final String SERIALIZED_NAME_INTERVAL = "interval";
    @SerializedName(value="interval")
    @Nonnull
    private Interval interval;
    public static final String SERIALIZED_NAME_START_TIME = "startTime";
    @SerializedName(value="startTime")
    @Nullable
    private Long startTime;
    public static final String SERIALIZED_NAME_END_TIME = "endTime";
    @SerializedName(value="endTime")
    @Nullable
    private Long endTime;
    public static final String SERIALIZED_NAME_TIME_ZONE = "timeZone";
    @SerializedName(value="timeZone")
    @Nullable
    private String timeZone;
    public static final String SERIALIZED_NAME_LIMIT = "limit";
    @SerializedName(value="limit")
    @Nullable
    private Integer limit;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public KlinesRequest symbol(@Nonnull String symbol) {
        this.symbol = symbol;
        return this;
    }

    @Nonnull
    @NotNull
    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(@Nonnull String symbol) {
        this.symbol = symbol;
    }

    public KlinesRequest interval(@Nonnull Interval interval) {
        this.interval = interval;
        return this;
    }

    @Nonnull
    @NotNull
    @Valid
    public Interval getInterval() {
        return this.interval;
    }

    public void setInterval(@Nonnull Interval interval) {
        this.interval = interval;
    }

    public KlinesRequest startTime(@Nullable Long startTime) {
        this.startTime = startTime;
        return this;
    }

    @Nullable
    public Long getStartTime() {
        return this.startTime;
    }

    public void setStartTime(@Nullable Long startTime) {
        this.startTime = startTime;
    }

    public KlinesRequest endTime(@Nullable Long endTime) {
        this.endTime = endTime;
        return this;
    }

    @Nullable
    public Long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(@Nullable Long endTime) {
        this.endTime = endTime;
    }

    public KlinesRequest timeZone(@Nullable String timeZone) {
        this.timeZone = timeZone;
        return this;
    }

    @Nullable
    public String getTimeZone() {
        return this.timeZone;
    }

    public void setTimeZone(@Nullable String timeZone) {
        this.timeZone = timeZone;
    }

    public KlinesRequest limit(@Nullable Integer limit) {
        this.limit = limit;
        return this;
    }

    @Nullable
    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(@Nullable Integer limit) {
        this.limit = limit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        KlinesRequest klinesRequest = (KlinesRequest)((Object)o);
        return Objects.equals(this.symbol, klinesRequest.symbol) && Objects.equals((Object)this.interval, (Object)klinesRequest.interval) && Objects.equals(this.startTime, klinesRequest.startTime) && Objects.equals(this.endTime, klinesRequest.endTime) && Objects.equals(this.timeZone, klinesRequest.timeZone) && Objects.equals(this.limit, klinesRequest.limit);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.symbol, this.interval, this.startTime, this.endTime, this.timeZone, this.limit});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KlinesRequest {\n");
        sb.append("\t\tsymbol: ").append(this.toIndentedString(this.symbol)).append("\n");
        sb.append("\t\tinterval: ").append(this.toIndentedString((Object)this.interval)).append("\n");
        sb.append("\t\tstartTime: ").append(this.toIndentedString(this.startTime)).append("\n");
        sb.append("\t\tendTime: ").append(this.toIndentedString(this.endTime)).append("\n");
        sb.append("\t\ttimeZone: ").append(this.toIndentedString(this.timeZone)).append("\n");
        sb.append("\t\tlimit: ").append(this.toIndentedString(this.limit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        Integer limitValue;
        String timeZoneValue;
        Long endTimeValue;
        Long startTimeValue;
        Interval intervalValue;
        StringBuilder sb = new StringBuilder();
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            String symbolValueAsString = symbolValue.toString();
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValueAsString);
        }
        if ((intervalValue = this.getInterval()) != null) {
            String intervalValueAsString = intervalValue.toString();
            valMap.put(SERIALIZED_NAME_INTERVAL, intervalValueAsString);
        }
        if ((startTimeValue = this.getStartTime()) != null) {
            String startTimeValueAsString = startTimeValue.toString();
            valMap.put(SERIALIZED_NAME_START_TIME, startTimeValueAsString);
        }
        if ((endTimeValue = this.getEndTime()) != null) {
            String endTimeValueAsString = endTimeValue.toString();
            valMap.put(SERIALIZED_NAME_END_TIME, endTimeValueAsString);
        }
        if ((timeZoneValue = this.getTimeZone()) != null) {
            String timeZoneValueAsString = timeZoneValue.toString();
            valMap.put(SERIALIZED_NAME_TIME_ZONE, timeZoneValueAsString);
        }
        if ((limitValue = this.getLimit()) != null) {
            String limitValueAsString = limitValue.toString();
            valMap.put(SERIALIZED_NAME_LIMIT, limitValueAsString);
        }
        valMap.put("timestamp", this.getTimestamp());
        return KlinesRequest.asciiEncode(valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&")));
    }

    public Map<String, Object> toMap() {
        Integer limitValue;
        String timeZoneValue;
        Long endTimeValue;
        Long startTimeValue;
        Interval intervalValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String symbolValue = this.getSymbol();
        if (symbolValue != null) {
            valMap.put(SERIALIZED_NAME_SYMBOL, symbolValue);
        }
        if ((intervalValue = this.getInterval()) != null) {
            valMap.put(SERIALIZED_NAME_INTERVAL, (Object)intervalValue);
        }
        if ((startTimeValue = this.getStartTime()) != null) {
            valMap.put(SERIALIZED_NAME_START_TIME, startTimeValue);
        }
        if ((endTimeValue = this.getEndTime()) != null) {
            valMap.put(SERIALIZED_NAME_END_TIME, endTimeValue);
        }
        if ((timeZoneValue = this.getTimeZone()) != null) {
            valMap.put(SERIALIZED_NAME_TIME_ZONE, timeZoneValue);
        }
        if ((limitValue = this.getLimit()) != null) {
            valMap.put(SERIALIZED_NAME_LIMIT, limitValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String asciiEncode(String s) {
        return new String(s.getBytes(), StandardCharsets.US_ASCII);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in KlinesRequest is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `KlinesRequest` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_SYMBOL).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `symbol` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOL).toString()));
        }
        Interval.validateJsonElement(jsonObj.get(SERIALIZED_NAME_INTERVAL));
        if (jsonObj.get(SERIALIZED_NAME_TIME_ZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TIME_ZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timeZone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIME_ZONE).toString()));
        }
    }

    public static KlinesRequest fromJson(String jsonString) throws IOException {
        return (KlinesRequest)((Object)JSON.getGson().fromJson(jsonString, KlinesRequest.class));
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_SYMBOL);
        openapiFields.add(SERIALIZED_NAME_INTERVAL);
        openapiFields.add(SERIALIZED_NAME_START_TIME);
        openapiFields.add(SERIALIZED_NAME_END_TIME);
        openapiFields.add(SERIALIZED_NAME_TIME_ZONE);
        openapiFields.add(SERIALIZED_NAME_LIMIT);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_SYMBOL);
        openapiRequiredFields.add(SERIALIZED_NAME_INTERVAL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!KlinesRequest.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(KlinesRequest.class));
            return new TypeAdapter<KlinesRequest>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, KlinesRequest value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public KlinesRequest read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (KlinesRequest)((Object)thisAdapter.fromJsonTree(jsonElement));
                }
            }.nullSafe();
        }
    }
}

