/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.common.websocket.dtos.StreamResponse;
import com.binance.connector.client.common.websocket.service.StreamBlockingQueue;
import com.binance.connector.client.common.websocket.service.StreamBlockingQueueWrapper;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.binance.connector.client.spot.websocket.api.model.SessionSubscriptionsResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamEventsResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamPingRequest;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamPingResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamStartResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamStopRequest;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamStopResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamSubscribeResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamSubscribeSignatureResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamUnsubscribeRequest;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamUnsubscribeResponse;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class UserDataStreamApi {
    private ConnectionInterface connection;

    public UserDataStreamApi() {
    }

    public UserDataStreamApi(ConnectionInterface connection) {
        this.connection = connection;
    }

    public CompletableFuture<SessionSubscriptionsResponse> sessionSubscriptions() throws ApiException {
        this.sessionSubscriptionsValidateBeforeCall();
        String methodName = "/session.subscriptions".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(SessionSubscriptionsResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void sessionSubscriptionsValidateBeforeCall() throws ApiException {
    }

    public CompletableFuture<UserDataStreamPingResponse> userDataStreamPing(UserDataStreamPingRequest userDataStreamPingRequest) throws ApiException {
        this.userDataStreamPingValidateBeforeCall(userDataStreamPingRequest);
        String methodName = "/userDataStream.ping".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)userDataStreamPingRequest).responseType(UserDataStreamPingResponse.class).signed(Boolean.valueOf(false)).apiKeyOnly(Boolean.valueOf(true)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void userDataStreamPingValidateBeforeCall(UserDataStreamPingRequest userDataStreamPingRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)userDataStreamPingRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public CompletableFuture<UserDataStreamStartResponse> userDataStreamStart() throws ApiException {
        this.userDataStreamStartValidateBeforeCall();
        String methodName = "/userDataStream.start".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(UserDataStreamStartResponse.class).signed(Boolean.valueOf(false)).apiKeyOnly(Boolean.valueOf(true)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void userDataStreamStartValidateBeforeCall() throws ApiException {
    }

    public CompletableFuture<UserDataStreamStopResponse> userDataStreamStop(UserDataStreamStopRequest userDataStreamStopRequest) throws ApiException {
        this.userDataStreamStopValidateBeforeCall(userDataStreamStopRequest);
        String methodName = "/userDataStream.stop".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)userDataStreamStopRequest).responseType(UserDataStreamStopResponse.class).signed(Boolean.valueOf(false)).apiKeyOnly(Boolean.valueOf(true)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void userDataStreamStopValidateBeforeCall(UserDataStreamStopRequest userDataStreamStopRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)userDataStreamStopRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public StreamResponse<UserDataStreamSubscribeResponse, UserDataStreamEventsResponse> userDataStreamSubscribe() throws ApiException {
        this.userDataStreamSubscribeValidateBeforeCall();
        String methodName = "/userDataStream.subscribe".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(UserDataStreamSubscribeResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            BlockingQueue queue = this.connection.sendForStream(build);
            TypeToken<UserDataStreamEventsResponse> typeToken = new TypeToken<UserDataStreamEventsResponse>(){};
            return new StreamResponse(build.getResponseCallback(), new StreamBlockingQueueWrapper(new StreamBlockingQueue(queue), (TypeToken)typeToken, JSON.getGson()));
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
    }

    private void userDataStreamSubscribeValidateBeforeCall() throws ApiException {
    }

    public StreamResponse<UserDataStreamSubscribeSignatureResponse, UserDataStreamEventsResponse> userDataStreamSubscribeSignature() throws ApiException {
        this.userDataStreamSubscribeSignatureValidateBeforeCall();
        String methodName = "/userDataStream.subscribe.signature".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params(new BaseRequestDTO()).responseType(UserDataStreamSubscribeSignatureResponse.class).build();
        try {
            BlockingQueue queue = this.connection.sendForStream(build);
            TypeToken<UserDataStreamEventsResponse> typeToken = new TypeToken<UserDataStreamEventsResponse>(){};
            return new StreamResponse(build.getResponseCallback(), new StreamBlockingQueueWrapper(new StreamBlockingQueue(queue), (TypeToken)typeToken, JSON.getGson()));
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
    }

    private void userDataStreamSubscribeSignatureValidateBeforeCall() throws ApiException {
    }

    public CompletableFuture<UserDataStreamUnsubscribeResponse> userDataStreamUnsubscribe(UserDataStreamUnsubscribeRequest userDataStreamUnsubscribeRequest) throws ApiException {
        this.userDataStreamUnsubscribeValidateBeforeCall(userDataStreamUnsubscribeRequest);
        String methodName = "/userDataStream.unsubscribe".substring(1);
        ApiRequestWrapperDTO build = new ApiRequestWrapperDTO.Builder().id(this.getRequestID()).method(methodName).params((BaseRequestDTO)userDataStreamUnsubscribeRequest).responseType(UserDataStreamUnsubscribeResponse.class).signed(Boolean.valueOf(false)).build();
        try {
            this.connection.send(build);
        }
        catch (InterruptedException e) {
            throw new ApiException((Throwable)e);
        }
        return build.getResponseCallback();
    }

    private void userDataStreamUnsubscribeValidateBeforeCall(UserDataStreamUnsubscribeRequest userDataStreamUnsubscribeRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            Set violations = validator.validate((Object)userDataStreamUnsubscribeRequest, new Class[0]);
            if (!violations.isEmpty()) {
                throw new ConstraintViolationException(violations);
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public String getRequestID() {
        return UUID.randomUUID().toString();
    }
}

