/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.websocket.api.api;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.adapter.ConnectionWrapper;
import com.binance.connector.client.common.websocket.adapter.PoolConnectionWrapper;
import com.binance.connector.client.common.websocket.configuration.WebSocketClientConfiguration;
import com.binance.connector.client.common.websocket.dtos.StreamResponse;
import com.binance.connector.client.spot.websocket.api.JSON;
import com.binance.connector.client.spot.websocket.api.api.AccountApi;
import com.binance.connector.client.spot.websocket.api.api.AuthApi;
import com.binance.connector.client.spot.websocket.api.api.GeneralApi;
import com.binance.connector.client.spot.websocket.api.api.MarketApi;
import com.binance.connector.client.spot.websocket.api.api.TradeApi;
import com.binance.connector.client.spot.websocket.api.api.UserDataStreamApi;
import com.binance.connector.client.spot.websocket.api.model.AccountCommissionRequest;
import com.binance.connector.client.spot.websocket.api.model.AccountCommissionResponse;
import com.binance.connector.client.spot.websocket.api.model.AccountRateLimitsOrdersRequest;
import com.binance.connector.client.spot.websocket.api.model.AccountRateLimitsOrdersResponse;
import com.binance.connector.client.spot.websocket.api.model.AccountStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.AccountStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.AllOrderListsRequest;
import com.binance.connector.client.spot.websocket.api.model.AllOrderListsResponse;
import com.binance.connector.client.spot.websocket.api.model.AllOrdersRequest;
import com.binance.connector.client.spot.websocket.api.model.AllOrdersResponse;
import com.binance.connector.client.spot.websocket.api.model.AvgPriceRequest;
import com.binance.connector.client.spot.websocket.api.model.AvgPriceResponse;
import com.binance.connector.client.spot.websocket.api.model.DepthRequest;
import com.binance.connector.client.spot.websocket.api.model.DepthResponse;
import com.binance.connector.client.spot.websocket.api.model.ExchangeInfoRequest;
import com.binance.connector.client.spot.websocket.api.model.ExchangeInfoResponse;
import com.binance.connector.client.spot.websocket.api.model.KlinesRequest;
import com.binance.connector.client.spot.websocket.api.model.KlinesResponse;
import com.binance.connector.client.spot.websocket.api.model.MyAllocationsRequest;
import com.binance.connector.client.spot.websocket.api.model.MyAllocationsResponse;
import com.binance.connector.client.spot.websocket.api.model.MyPreventedMatchesRequest;
import com.binance.connector.client.spot.websocket.api.model.MyPreventedMatchesResponse;
import com.binance.connector.client.spot.websocket.api.model.MyTradesRequest;
import com.binance.connector.client.spot.websocket.api.model.MyTradesResponse;
import com.binance.connector.client.spot.websocket.api.model.OpenOrderListsStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OpenOrderListsStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersCancelAllRequest;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersCancelAllResponse;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OpenOrdersStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendKeepPriorityRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendKeepPriorityResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendmentsRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderAmendmentsResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelReplaceRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelReplaceResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderCancelResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListCancelRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListCancelResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOcoRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOcoResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtoRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtoResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtocoRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceOtocoResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListPlaceResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderListStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderListStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderPlaceRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderPlaceResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderStatusRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.OrderTestRequest;
import com.binance.connector.client.spot.websocket.api.model.OrderTestResponse;
import com.binance.connector.client.spot.websocket.api.model.PingResponse;
import com.binance.connector.client.spot.websocket.api.model.SessionLogonRequest;
import com.binance.connector.client.spot.websocket.api.model.SessionLogonResponse;
import com.binance.connector.client.spot.websocket.api.model.SessionLogoutResponse;
import com.binance.connector.client.spot.websocket.api.model.SessionStatusResponse;
import com.binance.connector.client.spot.websocket.api.model.SessionSubscriptionsResponse;
import com.binance.connector.client.spot.websocket.api.model.SorOrderPlaceRequest;
import com.binance.connector.client.spot.websocket.api.model.SorOrderPlaceResponse;
import com.binance.connector.client.spot.websocket.api.model.SorOrderTestRequest;
import com.binance.connector.client.spot.websocket.api.model.SorOrderTestResponse;
import com.binance.connector.client.spot.websocket.api.model.Ticker24hrRequest;
import com.binance.connector.client.spot.websocket.api.model.Ticker24hrResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerBookRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerBookResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerPriceRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerPriceResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerResponse;
import com.binance.connector.client.spot.websocket.api.model.TickerTradingDayRequest;
import com.binance.connector.client.spot.websocket.api.model.TickerTradingDayResponse;
import com.binance.connector.client.spot.websocket.api.model.TimeResponse;
import com.binance.connector.client.spot.websocket.api.model.TradesAggregateRequest;
import com.binance.connector.client.spot.websocket.api.model.TradesAggregateResponse;
import com.binance.connector.client.spot.websocket.api.model.TradesHistoricalRequest;
import com.binance.connector.client.spot.websocket.api.model.TradesHistoricalResponse;
import com.binance.connector.client.spot.websocket.api.model.TradesRecentRequest;
import com.binance.connector.client.spot.websocket.api.model.TradesRecentResponse;
import com.binance.connector.client.spot.websocket.api.model.UiKlinesRequest;
import com.binance.connector.client.spot.websocket.api.model.UiKlinesResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamEventsResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamPingRequest;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamPingResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamStartResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamStopRequest;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamStopResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamSubscribeResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamSubscribeSignatureResponse;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamUnsubscribeRequest;
import com.binance.connector.client.spot.websocket.api.model.UserDataStreamUnsubscribeResponse;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;

public class SpotWebSocketApi {
    private static final String USER_AGENT = String.format("binance-spot/6.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private AccountApi accountApi;
    private AuthApi authApi;
    private GeneralApi generalApi;
    private MarketApi marketApi;
    private TradeApi tradeApi;
    private UserDataStreamApi userDataStreamApi;

    public SpotWebSocketApi(WebSocketClientConfiguration configuration) {
        this((ConnectionInterface)(configuration.getUsePool() != false ? new PoolConnectionWrapper(configuration, JSON.getGson()) : new ConnectionWrapper(configuration, JSON.getGson())));
    }

    public SpotWebSocketApi(ConnectionInterface connection) {
        connection.setUserAgent(USER_AGENT);
        ArrayList<String> logonMethods = new ArrayList<String>();
        ArrayList<String> logoutMethods = new ArrayList<String>();
        logonMethods.add("/session.logon".substring(1));
        logoutMethods.add("/session.logout".substring(1));
        connection.setLogonMethods(logonMethods);
        connection.setLogoutMethods(logoutMethods);
        if (!connection.isConnected()) {
            connection.connect();
        }
        this.accountApi = new AccountApi(connection);
        this.authApi = new AuthApi(connection);
        this.generalApi = new GeneralApi(connection);
        this.marketApi = new MarketApi(connection);
        this.tradeApi = new TradeApi(connection);
        this.userDataStreamApi = new UserDataStreamApi(connection);
    }

    public CompletableFuture<AccountCommissionResponse> accountCommission(AccountCommissionRequest accountCommissionRequest) throws ApiException {
        return this.accountApi.accountCommission(accountCommissionRequest);
    }

    public CompletableFuture<AccountRateLimitsOrdersResponse> accountRateLimitsOrders(AccountRateLimitsOrdersRequest accountRateLimitsOrdersRequest) throws ApiException {
        return this.accountApi.accountRateLimitsOrders(accountRateLimitsOrdersRequest);
    }

    public CompletableFuture<AccountStatusResponse> accountStatus(AccountStatusRequest accountStatusRequest) throws ApiException {
        return this.accountApi.accountStatus(accountStatusRequest);
    }

    public CompletableFuture<AllOrderListsResponse> allOrderLists(AllOrderListsRequest allOrderListsRequest) throws ApiException {
        return this.accountApi.allOrderLists(allOrderListsRequest);
    }

    public CompletableFuture<AllOrdersResponse> allOrders(AllOrdersRequest allOrdersRequest) throws ApiException {
        return this.accountApi.allOrders(allOrdersRequest);
    }

    public CompletableFuture<MyAllocationsResponse> myAllocations(MyAllocationsRequest myAllocationsRequest) throws ApiException {
        return this.accountApi.myAllocations(myAllocationsRequest);
    }

    public CompletableFuture<MyPreventedMatchesResponse> myPreventedMatches(MyPreventedMatchesRequest myPreventedMatchesRequest) throws ApiException {
        return this.accountApi.myPreventedMatches(myPreventedMatchesRequest);
    }

    public CompletableFuture<MyTradesResponse> myTrades(MyTradesRequest myTradesRequest) throws ApiException {
        return this.accountApi.myTrades(myTradesRequest);
    }

    public CompletableFuture<OpenOrderListsStatusResponse> openOrderListsStatus(OpenOrderListsStatusRequest openOrderListsStatusRequest) throws ApiException {
        return this.accountApi.openOrderListsStatus(openOrderListsStatusRequest);
    }

    public CompletableFuture<OpenOrdersStatusResponse> openOrdersStatus(OpenOrdersStatusRequest openOrdersStatusRequest) throws ApiException {
        return this.accountApi.openOrdersStatus(openOrdersStatusRequest);
    }

    public CompletableFuture<OrderAmendmentsResponse> orderAmendments(OrderAmendmentsRequest orderAmendmentsRequest) throws ApiException {
        return this.accountApi.orderAmendments(orderAmendmentsRequest);
    }

    public CompletableFuture<OrderListStatusResponse> orderListStatus(OrderListStatusRequest orderListStatusRequest) throws ApiException {
        return this.accountApi.orderListStatus(orderListStatusRequest);
    }

    public CompletableFuture<OrderStatusResponse> orderStatus(OrderStatusRequest orderStatusRequest) throws ApiException {
        return this.accountApi.orderStatus(orderStatusRequest);
    }

    public CompletableFuture<SessionLogonResponse> sessionLogon(SessionLogonRequest sessionLogonRequest) throws ApiException {
        return this.authApi.sessionLogon(sessionLogonRequest);
    }

    public CompletableFuture<SessionLogoutResponse> sessionLogout() throws ApiException {
        return this.authApi.sessionLogout();
    }

    public CompletableFuture<SessionStatusResponse> sessionStatus() throws ApiException {
        return this.authApi.sessionStatus();
    }

    public CompletableFuture<ExchangeInfoResponse> exchangeInfo(ExchangeInfoRequest exchangeInfoRequest) throws ApiException {
        return this.generalApi.exchangeInfo(exchangeInfoRequest);
    }

    public CompletableFuture<PingResponse> ping() throws ApiException {
        return this.generalApi.ping();
    }

    public CompletableFuture<TimeResponse> time() throws ApiException {
        return this.generalApi.time();
    }

    public CompletableFuture<AvgPriceResponse> avgPrice(AvgPriceRequest avgPriceRequest) throws ApiException {
        return this.marketApi.avgPrice(avgPriceRequest);
    }

    public CompletableFuture<DepthResponse> depth(DepthRequest depthRequest) throws ApiException {
        return this.marketApi.depth(depthRequest);
    }

    public CompletableFuture<KlinesResponse> klines(KlinesRequest klinesRequest) throws ApiException {
        return this.marketApi.klines(klinesRequest);
    }

    public CompletableFuture<TickerResponse> ticker(TickerRequest tickerRequest) throws ApiException {
        return this.marketApi.ticker(tickerRequest);
    }

    public CompletableFuture<Ticker24hrResponse> ticker24hr(Ticker24hrRequest ticker24hrRequest) throws ApiException {
        return this.marketApi.ticker24hr(ticker24hrRequest);
    }

    public CompletableFuture<TickerBookResponse> tickerBook(TickerBookRequest tickerBookRequest) throws ApiException {
        return this.marketApi.tickerBook(tickerBookRequest);
    }

    public CompletableFuture<TickerPriceResponse> tickerPrice(TickerPriceRequest tickerPriceRequest) throws ApiException {
        return this.marketApi.tickerPrice(tickerPriceRequest);
    }

    public CompletableFuture<TickerTradingDayResponse> tickerTradingDay(TickerTradingDayRequest tickerTradingDayRequest) throws ApiException {
        return this.marketApi.tickerTradingDay(tickerTradingDayRequest);
    }

    public CompletableFuture<TradesAggregateResponse> tradesAggregate(TradesAggregateRequest tradesAggregateRequest) throws ApiException {
        return this.marketApi.tradesAggregate(tradesAggregateRequest);
    }

    public CompletableFuture<TradesHistoricalResponse> tradesHistorical(TradesHistoricalRequest tradesHistoricalRequest) throws ApiException {
        return this.marketApi.tradesHistorical(tradesHistoricalRequest);
    }

    public CompletableFuture<TradesRecentResponse> tradesRecent(TradesRecentRequest tradesRecentRequest) throws ApiException {
        return this.marketApi.tradesRecent(tradesRecentRequest);
    }

    public CompletableFuture<UiKlinesResponse> uiKlines(UiKlinesRequest uiKlinesRequest) throws ApiException {
        return this.marketApi.uiKlines(uiKlinesRequest);
    }

    public CompletableFuture<OpenOrdersCancelAllResponse> openOrdersCancelAll(OpenOrdersCancelAllRequest openOrdersCancelAllRequest) throws ApiException {
        return this.tradeApi.openOrdersCancelAll(openOrdersCancelAllRequest);
    }

    public CompletableFuture<OrderAmendKeepPriorityResponse> orderAmendKeepPriority(OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        return this.tradeApi.orderAmendKeepPriority(orderAmendKeepPriorityRequest);
    }

    public CompletableFuture<OrderCancelResponse> orderCancel(OrderCancelRequest orderCancelRequest) throws ApiException {
        return this.tradeApi.orderCancel(orderCancelRequest);
    }

    public CompletableFuture<OrderCancelReplaceResponse> orderCancelReplace(OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        return this.tradeApi.orderCancelReplace(orderCancelReplaceRequest);
    }

    public CompletableFuture<OrderListCancelResponse> orderListCancel(OrderListCancelRequest orderListCancelRequest) throws ApiException {
        return this.tradeApi.orderListCancel(orderListCancelRequest);
    }

    public CompletableFuture<OrderListPlaceResponse> orderListPlace(OrderListPlaceRequest orderListPlaceRequest) throws ApiException {
        return this.tradeApi.orderListPlace(orderListPlaceRequest);
    }

    public CompletableFuture<OrderListPlaceOcoResponse> orderListPlaceOco(OrderListPlaceOcoRequest orderListPlaceOcoRequest) throws ApiException {
        return this.tradeApi.orderListPlaceOco(orderListPlaceOcoRequest);
    }

    public CompletableFuture<OrderListPlaceOtoResponse> orderListPlaceOto(OrderListPlaceOtoRequest orderListPlaceOtoRequest) throws ApiException {
        return this.tradeApi.orderListPlaceOto(orderListPlaceOtoRequest);
    }

    public CompletableFuture<OrderListPlaceOtocoResponse> orderListPlaceOtoco(OrderListPlaceOtocoRequest orderListPlaceOtocoRequest) throws ApiException {
        return this.tradeApi.orderListPlaceOtoco(orderListPlaceOtocoRequest);
    }

    public CompletableFuture<OrderPlaceResponse> orderPlace(OrderPlaceRequest orderPlaceRequest) throws ApiException {
        return this.tradeApi.orderPlace(orderPlaceRequest);
    }

    public CompletableFuture<OrderTestResponse> orderTest(OrderTestRequest orderTestRequest) throws ApiException {
        return this.tradeApi.orderTest(orderTestRequest);
    }

    public CompletableFuture<SorOrderPlaceResponse> sorOrderPlace(SorOrderPlaceRequest sorOrderPlaceRequest) throws ApiException {
        return this.tradeApi.sorOrderPlace(sorOrderPlaceRequest);
    }

    public CompletableFuture<SorOrderTestResponse> sorOrderTest(SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        return this.tradeApi.sorOrderTest(sorOrderTestRequest);
    }

    public CompletableFuture<SessionSubscriptionsResponse> sessionSubscriptions() throws ApiException {
        return this.userDataStreamApi.sessionSubscriptions();
    }

    public CompletableFuture<UserDataStreamPingResponse> userDataStreamPing(UserDataStreamPingRequest userDataStreamPingRequest) throws ApiException {
        return this.userDataStreamApi.userDataStreamPing(userDataStreamPingRequest);
    }

    public CompletableFuture<UserDataStreamStartResponse> userDataStreamStart() throws ApiException {
        return this.userDataStreamApi.userDataStreamStart();
    }

    public CompletableFuture<UserDataStreamStopResponse> userDataStreamStop(UserDataStreamStopRequest userDataStreamStopRequest) throws ApiException {
        return this.userDataStreamApi.userDataStreamStop(userDataStreamStopRequest);
    }

    public StreamResponse<UserDataStreamSubscribeResponse, UserDataStreamEventsResponse> userDataStreamSubscribe() throws ApiException {
        return this.userDataStreamApi.userDataStreamSubscribe();
    }

    public StreamResponse<UserDataStreamSubscribeSignatureResponse, UserDataStreamEventsResponse> userDataStreamSubscribeSignature() throws ApiException {
        return this.userDataStreamApi.userDataStreamSubscribeSignature();
    }

    public CompletableFuture<UserDataStreamUnsubscribeResponse> userDataStreamUnsubscribe(UserDataStreamUnsubscribeRequest userDataStreamUnsubscribeRequest) throws ApiException {
        return this.userDataStreamApi.userDataStreamUnsubscribe(userDataStreamUnsubscribeRequest);
    }
}

