/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.model;

import com.binance.connector.client.spot.rest.JSON;
import com.binance.connector.client.spot.rest.model.ExchangeFilters;
import com.binance.connector.client.spot.rest.model.ExchangeInfoResponseSymbolsInner;
import com.binance.connector.client.spot.rest.model.RateLimits;
import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ExchangeInfoResponse {
    public static final String SERIALIZED_NAME_TIMEZONE = "timezone";
    @SerializedName(value="timezone")
    @Nullable
    private String timezone;
    public static final String SERIALIZED_NAME_SERVER_TIME = "serverTime";
    @SerializedName(value="serverTime")
    @Nullable
    private Long serverTime;
    public static final String SERIALIZED_NAME_RATE_LIMITS = "rateLimits";
    @SerializedName(value="rateLimits")
    @Nullable
    private RateLimits rateLimits;
    public static final String SERIALIZED_NAME_EXCHANGE_FILTERS = "exchangeFilters";
    @SerializedName(value="exchangeFilters")
    @Nullable
    private ExchangeFilters exchangeFilters;
    public static final String SERIALIZED_NAME_SYMBOLS = "symbols";
    @SerializedName(value="symbols")
    @Nullable
    private List<@Valid ExchangeInfoResponseSymbolsInner> symbols;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public ExchangeInfoResponse timezone(@Nullable String timezone) {
        this.timezone = timezone;
        return this;
    }

    @Nullable
    public String getTimezone() {
        return this.timezone;
    }

    public void setTimezone(@Nullable String timezone) {
        this.timezone = timezone;
    }

    public ExchangeInfoResponse serverTime(@Nullable Long serverTime) {
        this.serverTime = serverTime;
        return this;
    }

    @Nullable
    public Long getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(@Nullable Long serverTime) {
        this.serverTime = serverTime;
    }

    public ExchangeInfoResponse rateLimits(@Nullable RateLimits rateLimits) {
        this.rateLimits = rateLimits;
        return this;
    }

    @Nullable
    @Valid
    public RateLimits getRateLimits() {
        return this.rateLimits;
    }

    public void setRateLimits(@Nullable RateLimits rateLimits) {
        this.rateLimits = rateLimits;
    }

    public ExchangeInfoResponse exchangeFilters(@Nullable ExchangeFilters exchangeFilters) {
        this.exchangeFilters = exchangeFilters;
        return this;
    }

    @Nullable
    @Valid
    public ExchangeFilters getExchangeFilters() {
        return this.exchangeFilters;
    }

    public void setExchangeFilters(@Nullable ExchangeFilters exchangeFilters) {
        this.exchangeFilters = exchangeFilters;
    }

    public ExchangeInfoResponse symbols(@Nullable List<@Valid ExchangeInfoResponseSymbolsInner> symbols) {
        this.symbols = symbols;
        return this;
    }

    public ExchangeInfoResponse addSymbolsItem(ExchangeInfoResponseSymbolsInner symbolsItem) {
        if (this.symbols == null) {
            this.symbols = new ArrayList<ExchangeInfoResponseSymbolsInner>();
        }
        this.symbols.add(symbolsItem);
        return this;
    }

    @Nullable
    @Valid
    public @Valid List<@Valid ExchangeInfoResponseSymbolsInner> getSymbols() {
        return this.symbols;
    }

    public void setSymbols(@Nullable List<@Valid ExchangeInfoResponseSymbolsInner> symbols) {
        this.symbols = symbols;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExchangeInfoResponse exchangeInfoResponse = (ExchangeInfoResponse)o;
        return Objects.equals(this.timezone, exchangeInfoResponse.timezone) && Objects.equals(this.serverTime, exchangeInfoResponse.serverTime) && Objects.equals(this.rateLimits, exchangeInfoResponse.rateLimits) && Objects.equals(this.exchangeFilters, exchangeInfoResponse.exchangeFilters) && Objects.equals(this.symbols, exchangeInfoResponse.symbols);
    }

    public int hashCode() {
        return Objects.hash(this.timezone, this.serverTime, this.rateLimits, this.exchangeFilters, this.symbols);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ExchangeInfoResponse {\n");
        sb.append("\t\ttimezone: ").append(this.toIndentedString(this.timezone)).append("\n");
        sb.append("\t\tserverTime: ").append(this.toIndentedString(this.serverTime)).append("\n");
        sb.append("\t\trateLimits: ").append(this.toIndentedString(this.rateLimits)).append("\n");
        sb.append("\t\texchangeFilters: ").append(this.toIndentedString(this.exchangeFilters)).append("\n");
        sb.append("\t\tsymbols: ").append(this.toIndentedString(this.symbols)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    public String toUrlQueryString() {
        StringBuilder sb = new StringBuilder();
        String timezoneValue = this.getTimezone();
        String timezoneValueAsString = "";
        timezoneValueAsString = timezoneValue.toString();
        sb.append("timezone=").append(ExchangeInfoResponse.urlEncode(timezoneValueAsString)).append("");
        Long serverTimeValue = this.getServerTime();
        String serverTimeValueAsString = "";
        serverTimeValueAsString = ((Object)serverTimeValue).toString();
        sb.append("serverTime=").append(ExchangeInfoResponse.urlEncode(serverTimeValueAsString)).append("");
        RateLimits rateLimitsValue = this.getRateLimits();
        String rateLimitsValueAsString = "";
        rateLimitsValueAsString = ((Object)rateLimitsValue).toString();
        sb.append("rateLimits=").append(ExchangeInfoResponse.urlEncode(rateLimitsValueAsString)).append("");
        ExchangeFilters exchangeFiltersValue = this.getExchangeFilters();
        String exchangeFiltersValueAsString = "";
        exchangeFiltersValueAsString = ((Object)exchangeFiltersValue).toString();
        sb.append("exchangeFilters=").append(ExchangeInfoResponse.urlEncode(exchangeFiltersValueAsString)).append("");
        List<ExchangeInfoResponseSymbolsInner> symbolsValue = this.getSymbols();
        String symbolsValueAsString = "";
        symbolsValueAsString = ((Collection)symbolsValue).stream().map(Object::toString).collect(Collectors.joining(","));
        sb.append("symbols=").append(ExchangeInfoResponse.urlEncode(symbolsValueAsString)).append("");
        return sb.toString();
    }

    public static String urlEncode(String s) {
        try {
            return URLEncoder.encode(s, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(StandardCharsets.UTF_8.name() + " is unsupported", e);
        }
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArraysymbols;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in ExchangeInfoResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_TIMEZONE) != null && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TIMEZONE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `timezone` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TIMEZONE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_SYMBOLS) != null && !jsonObj.get(SERIALIZED_NAME_SYMBOLS).isJsonNull() && (jsonArraysymbols = jsonObj.getAsJsonArray(SERIALIZED_NAME_SYMBOLS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_SYMBOLS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `symbols` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SYMBOLS).toString()));
            }
            for (int i = 0; i < jsonArraysymbols.size(); ++i) {
                ExchangeInfoResponseSymbolsInner.validateJsonElement(jsonArraysymbols.get(i));
            }
        }
    }

    public static ExchangeInfoResponse fromJson(String jsonString) throws IOException {
        return (ExchangeInfoResponse)JSON.getGson().fromJson(jsonString, ExchangeInfoResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_TIMEZONE);
        openapiFields.add(SERIALIZED_NAME_SERVER_TIME);
        openapiFields.add(SERIALIZED_NAME_RATE_LIMITS);
        openapiFields.add(SERIALIZED_NAME_EXCHANGE_FILTERS);
        openapiFields.add(SERIALIZED_NAME_SYMBOLS);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!ExchangeInfoResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(ExchangeInfoResponse.class));
            return new TypeAdapter<ExchangeInfoResponse>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, ExchangeInfoResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public ExchangeInfoResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (ExchangeInfoResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

