/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.api;

import com.binance.connector.client.common.ApiClient;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.DecimalFormatter;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.spot.rest.model.CancelRestrictions;
import com.binance.connector.client.spot.rest.model.DeleteOpenOrdersResponse;
import com.binance.connector.client.spot.rest.model.DeleteOrderListResponse;
import com.binance.connector.client.spot.rest.model.DeleteOrderResponse;
import com.binance.connector.client.spot.rest.model.NewOrderRequest;
import com.binance.connector.client.spot.rest.model.NewOrderResponse;
import com.binance.connector.client.spot.rest.model.OrderAmendKeepPriorityRequest;
import com.binance.connector.client.spot.rest.model.OrderAmendKeepPriorityResponse;
import com.binance.connector.client.spot.rest.model.OrderCancelReplaceRequest;
import com.binance.connector.client.spot.rest.model.OrderCancelReplaceResponse;
import com.binance.connector.client.spot.rest.model.OrderListOcoRequest;
import com.binance.connector.client.spot.rest.model.OrderListOcoResponse;
import com.binance.connector.client.spot.rest.model.OrderListOtoRequest;
import com.binance.connector.client.spot.rest.model.OrderListOtoResponse;
import com.binance.connector.client.spot.rest.model.OrderListOtocoRequest;
import com.binance.connector.client.spot.rest.model.OrderListOtocoResponse;
import com.binance.connector.client.spot.rest.model.OrderOcoRequest;
import com.binance.connector.client.spot.rest.model.OrderOcoResponse;
import com.binance.connector.client.spot.rest.model.OrderTestRequest;
import com.binance.connector.client.spot.rest.model.OrderTestResponse;
import com.binance.connector.client.spot.rest.model.SorOrderRequest;
import com.binance.connector.client.spot.rest.model.SorOrderResponse;
import com.binance.connector.client.spot.rest.model.SorOrderTestRequest;
import com.binance.connector.client.spot.rest.model.SorOrderTestResponse;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Valid;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import okhttp3.Call;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class TradeApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;
    private static final String USER_AGENT = String.format("binance-spot/6.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private static final boolean HAS_TIME_UNIT = true;

    public TradeApi(ClientConfiguration clientConfiguration) {
        this(new ApiClient(clientConfiguration));
    }

    public TradeApi(ApiClient apiClient) {
        apiClient.setUserAgent(USER_AGENT);
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call deleteOpenOrdersCall(String symbol, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/openOrders";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call deleteOpenOrdersValidateBeforeCall(String symbol, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, recvWindow};
            Method method = this.getClass().getMethod("deleteOpenOrders", String.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.deleteOpenOrdersCall(symbol, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<DeleteOpenOrdersResponse> deleteOpenOrders(@NotNull String symbol, Long recvWindow) throws ApiException {
        Call localVarCall = this.deleteOpenOrdersValidateBeforeCall(symbol, recvWindow);
        Type localVarReturnType = new TypeToken<DeleteOpenOrdersResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteOrderCall(String symbol, Long orderId, String origClientOrderId, String newClientOrderId, CancelRestrictions cancelRestrictions, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (orderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderId", (Object)orderId));
        }
        if (origClientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("origClientOrderId", (Object)origClientOrderId));
        }
        if (newClientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("newClientOrderId", (Object)newClientOrderId));
        }
        if (cancelRestrictions != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("cancelRestrictions", (Object)cancelRestrictions));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call deleteOrderValidateBeforeCall(String symbol, Long orderId, String origClientOrderId, String newClientOrderId, CancelRestrictions cancelRestrictions, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, orderId, origClientOrderId, newClientOrderId, cancelRestrictions, recvWindow};
            Method method = this.getClass().getMethod("deleteOrder", String.class, Long.class, String.class, String.class, CancelRestrictions.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.deleteOrderCall(symbol, orderId, origClientOrderId, newClientOrderId, cancelRestrictions, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<DeleteOrderResponse> deleteOrder(@NotNull String symbol, Long orderId, String origClientOrderId, String newClientOrderId, CancelRestrictions cancelRestrictions, Long recvWindow) throws ApiException {
        Call localVarCall = this.deleteOrderValidateBeforeCall(symbol, orderId, origClientOrderId, newClientOrderId, cancelRestrictions, recvWindow);
        Type localVarReturnType = new TypeToken<DeleteOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call deleteOrderListCall(String symbol, Long orderListId, String listClientOrderId, String newClientOrderId, Long recvWindow) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/orderList";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (orderListId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("orderListId", (Object)orderListId));
        }
        if (listClientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("listClientOrderId", (Object)listClientOrderId));
        }
        if (newClientOrderId != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("newClientOrderId", (Object)newClientOrderId));
        }
        if (recvWindow != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("recvWindow", (Object)recvWindow));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "DELETE", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call deleteOrderListValidateBeforeCall(String symbol, Long orderListId, String listClientOrderId, String newClientOrderId, Long recvWindow) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, orderListId, listClientOrderId, newClientOrderId, recvWindow};
            Method method = this.getClass().getMethod("deleteOrderList", String.class, Long.class, String.class, String.class, Long.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.deleteOrderListCall(symbol, orderListId, listClientOrderId, newClientOrderId, recvWindow);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<DeleteOrderListResponse> deleteOrderList(@NotNull String symbol, Long orderListId, String listClientOrderId, String newClientOrderId, Long recvWindow) throws ApiException {
        Call localVarCall = this.deleteOrderListValidateBeforeCall(symbol, orderListId, listClientOrderId, newClientOrderId, recvWindow);
        Type localVarReturnType = new TypeToken<DeleteOrderListResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call newOrderCall(NewOrderRequest newOrderRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (newOrderRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", newOrderRequest.getSymbol());
        }
        if (newOrderRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)newOrderRequest.getSide());
        }
        if (newOrderRequest.getType() != null) {
            localVarFormParams.put("type", (Object)newOrderRequest.getType());
        }
        if (newOrderRequest.getTimeInForce() != null) {
            localVarFormParams.put("timeInForce", (Object)newOrderRequest.getTimeInForce());
        }
        if (newOrderRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(newOrderRequest.getQuantity()));
        }
        if (newOrderRequest.getQuoteOrderQty() != null) {
            localVarFormParams.put("quoteOrderQty", DecimalFormatter.getFormatter().format(newOrderRequest.getQuoteOrderQty()));
        }
        if (newOrderRequest.getPrice() != null) {
            localVarFormParams.put("price", DecimalFormatter.getFormatter().format(newOrderRequest.getPrice()));
        }
        if (newOrderRequest.getNewClientOrderId() != null) {
            localVarFormParams.put("newClientOrderId", newOrderRequest.getNewClientOrderId());
        }
        if (newOrderRequest.getStrategyId() != null) {
            localVarFormParams.put("strategyId", newOrderRequest.getStrategyId());
        }
        if (newOrderRequest.getStrategyType() != null) {
            localVarFormParams.put("strategyType", newOrderRequest.getStrategyType());
        }
        if (newOrderRequest.getStopPrice() != null) {
            localVarFormParams.put("stopPrice", DecimalFormatter.getFormatter().format(newOrderRequest.getStopPrice()));
        }
        if (newOrderRequest.getTrailingDelta() != null) {
            localVarFormParams.put("trailingDelta", newOrderRequest.getTrailingDelta());
        }
        if (newOrderRequest.getIcebergQty() != null) {
            localVarFormParams.put("icebergQty", DecimalFormatter.getFormatter().format(newOrderRequest.getIcebergQty()));
        }
        if (newOrderRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)newOrderRequest.getNewOrderRespType());
        }
        if (newOrderRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)newOrderRequest.getSelfTradePreventionMode());
        }
        if (newOrderRequest.getPegPriceType() != null) {
            localVarFormParams.put("pegPriceType", (Object)newOrderRequest.getPegPriceType());
        }
        if (newOrderRequest.getPegOffsetValue() != null) {
            localVarFormParams.put("pegOffsetValue", newOrderRequest.getPegOffsetValue());
        }
        if (newOrderRequest.getPegOffsetType() != null) {
            localVarFormParams.put("pegOffsetType", (Object)newOrderRequest.getPegOffsetType());
        }
        if (newOrderRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", newOrderRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call newOrderValidateBeforeCall(NewOrderRequest newOrderRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{newOrderRequest};
            Method method = this.getClass().getMethod("newOrder", NewOrderRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.newOrderCall(newOrderRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<NewOrderResponse> newOrder(@Valid @NotNull NewOrderRequest newOrderRequest) throws ApiException {
        Call localVarCall = this.newOrderValidateBeforeCall(newOrderRequest);
        Type localVarReturnType = new TypeToken<NewOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderAmendKeepPriorityCall(OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order/amend/keepPriority";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderAmendKeepPriorityRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderAmendKeepPriorityRequest.getSymbol());
        }
        if (orderAmendKeepPriorityRequest.getOrderId() != null) {
            localVarFormParams.put("orderId", orderAmendKeepPriorityRequest.getOrderId());
        }
        if (orderAmendKeepPriorityRequest.getOrigClientOrderId() != null) {
            localVarFormParams.put("origClientOrderId", orderAmendKeepPriorityRequest.getOrigClientOrderId());
        }
        if (orderAmendKeepPriorityRequest.getNewClientOrderId() != null) {
            localVarFormParams.put("newClientOrderId", orderAmendKeepPriorityRequest.getNewClientOrderId());
        }
        if (orderAmendKeepPriorityRequest.getNewQty() != null) {
            localVarFormParams.put("newQty", DecimalFormatter.getFormatter().format(orderAmendKeepPriorityRequest.getNewQty()));
        }
        if (orderAmendKeepPriorityRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderAmendKeepPriorityRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "PUT", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderAmendKeepPriorityValidateBeforeCall(OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderAmendKeepPriorityRequest};
            Method method = this.getClass().getMethod("orderAmendKeepPriority", OrderAmendKeepPriorityRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderAmendKeepPriorityCall(orderAmendKeepPriorityRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderAmendKeepPriorityResponse> orderAmendKeepPriority(@Valid @NotNull OrderAmendKeepPriorityRequest orderAmendKeepPriorityRequest) throws ApiException {
        Call localVarCall = this.orderAmendKeepPriorityValidateBeforeCall(orderAmendKeepPriorityRequest);
        Type localVarReturnType = new TypeToken<OrderAmendKeepPriorityResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderCancelReplaceCall(OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order/cancelReplace";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderCancelReplaceRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderCancelReplaceRequest.getSymbol());
        }
        if (orderCancelReplaceRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)orderCancelReplaceRequest.getSide());
        }
        if (orderCancelReplaceRequest.getType() != null) {
            localVarFormParams.put("type", (Object)orderCancelReplaceRequest.getType());
        }
        if (orderCancelReplaceRequest.getCancelReplaceMode() != null) {
            localVarFormParams.put("cancelReplaceMode", (Object)orderCancelReplaceRequest.getCancelReplaceMode());
        }
        if (orderCancelReplaceRequest.getTimeInForce() != null) {
            localVarFormParams.put("timeInForce", (Object)orderCancelReplaceRequest.getTimeInForce());
        }
        if (orderCancelReplaceRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(orderCancelReplaceRequest.getQuantity()));
        }
        if (orderCancelReplaceRequest.getQuoteOrderQty() != null) {
            localVarFormParams.put("quoteOrderQty", DecimalFormatter.getFormatter().format(orderCancelReplaceRequest.getQuoteOrderQty()));
        }
        if (orderCancelReplaceRequest.getPrice() != null) {
            localVarFormParams.put("price", DecimalFormatter.getFormatter().format(orderCancelReplaceRequest.getPrice()));
        }
        if (orderCancelReplaceRequest.getCancelNewClientOrderId() != null) {
            localVarFormParams.put("cancelNewClientOrderId", orderCancelReplaceRequest.getCancelNewClientOrderId());
        }
        if (orderCancelReplaceRequest.getCancelOrigClientOrderId() != null) {
            localVarFormParams.put("cancelOrigClientOrderId", orderCancelReplaceRequest.getCancelOrigClientOrderId());
        }
        if (orderCancelReplaceRequest.getCancelOrderId() != null) {
            localVarFormParams.put("cancelOrderId", orderCancelReplaceRequest.getCancelOrderId());
        }
        if (orderCancelReplaceRequest.getNewClientOrderId() != null) {
            localVarFormParams.put("newClientOrderId", orderCancelReplaceRequest.getNewClientOrderId());
        }
        if (orderCancelReplaceRequest.getStrategyId() != null) {
            localVarFormParams.put("strategyId", orderCancelReplaceRequest.getStrategyId());
        }
        if (orderCancelReplaceRequest.getStrategyType() != null) {
            localVarFormParams.put("strategyType", orderCancelReplaceRequest.getStrategyType());
        }
        if (orderCancelReplaceRequest.getStopPrice() != null) {
            localVarFormParams.put("stopPrice", DecimalFormatter.getFormatter().format(orderCancelReplaceRequest.getStopPrice()));
        }
        if (orderCancelReplaceRequest.getTrailingDelta() != null) {
            localVarFormParams.put("trailingDelta", orderCancelReplaceRequest.getTrailingDelta());
        }
        if (orderCancelReplaceRequest.getIcebergQty() != null) {
            localVarFormParams.put("icebergQty", DecimalFormatter.getFormatter().format(orderCancelReplaceRequest.getIcebergQty()));
        }
        if (orderCancelReplaceRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)orderCancelReplaceRequest.getNewOrderRespType());
        }
        if (orderCancelReplaceRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)orderCancelReplaceRequest.getSelfTradePreventionMode());
        }
        if (orderCancelReplaceRequest.getCancelRestrictions() != null) {
            localVarFormParams.put("cancelRestrictions", (Object)orderCancelReplaceRequest.getCancelRestrictions());
        }
        if (orderCancelReplaceRequest.getOrderRateLimitExceededMode() != null) {
            localVarFormParams.put("orderRateLimitExceededMode", (Object)orderCancelReplaceRequest.getOrderRateLimitExceededMode());
        }
        if (orderCancelReplaceRequest.getPegPriceType() != null) {
            localVarFormParams.put("pegPriceType", (Object)orderCancelReplaceRequest.getPegPriceType());
        }
        if (orderCancelReplaceRequest.getPegOffsetValue() != null) {
            localVarFormParams.put("pegOffsetValue", orderCancelReplaceRequest.getPegOffsetValue());
        }
        if (orderCancelReplaceRequest.getPegOffsetType() != null) {
            localVarFormParams.put("pegOffsetType", (Object)orderCancelReplaceRequest.getPegOffsetType());
        }
        if (orderCancelReplaceRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderCancelReplaceRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderCancelReplaceValidateBeforeCall(OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderCancelReplaceRequest};
            Method method = this.getClass().getMethod("orderCancelReplace", OrderCancelReplaceRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderCancelReplaceCall(orderCancelReplaceRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderCancelReplaceResponse> orderCancelReplace(@Valid @NotNull OrderCancelReplaceRequest orderCancelReplaceRequest) throws ApiException {
        Call localVarCall = this.orderCancelReplaceValidateBeforeCall(orderCancelReplaceRequest);
        Type localVarReturnType = new TypeToken<OrderCancelReplaceResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderListOcoCall(OrderListOcoRequest orderListOcoRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/orderList/oco";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderListOcoRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderListOcoRequest.getSymbol());
        }
        if (orderListOcoRequest.getListClientOrderId() != null) {
            localVarFormParams.put("listClientOrderId", orderListOcoRequest.getListClientOrderId());
        }
        if (orderListOcoRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)orderListOcoRequest.getSide());
        }
        if (orderListOcoRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(orderListOcoRequest.getQuantity()));
        }
        if (orderListOcoRequest.getAboveType() != null) {
            localVarFormParams.put("aboveType", (Object)orderListOcoRequest.getAboveType());
        }
        if (orderListOcoRequest.getAboveClientOrderId() != null) {
            localVarFormParams.put("aboveClientOrderId", orderListOcoRequest.getAboveClientOrderId());
        }
        if (orderListOcoRequest.getAboveIcebergQty() != null) {
            localVarFormParams.put("aboveIcebergQty", orderListOcoRequest.getAboveIcebergQty());
        }
        if (orderListOcoRequest.getAbovePrice() != null) {
            localVarFormParams.put("abovePrice", DecimalFormatter.getFormatter().format(orderListOcoRequest.getAbovePrice()));
        }
        if (orderListOcoRequest.getAboveStopPrice() != null) {
            localVarFormParams.put("aboveStopPrice", DecimalFormatter.getFormatter().format(orderListOcoRequest.getAboveStopPrice()));
        }
        if (orderListOcoRequest.getAboveTrailingDelta() != null) {
            localVarFormParams.put("aboveTrailingDelta", orderListOcoRequest.getAboveTrailingDelta());
        }
        if (orderListOcoRequest.getAboveTimeInForce() != null) {
            localVarFormParams.put("aboveTimeInForce", DecimalFormatter.getFormatter().format(orderListOcoRequest.getAboveTimeInForce()));
        }
        if (orderListOcoRequest.getAboveStrategyId() != null) {
            localVarFormParams.put("aboveStrategyId", orderListOcoRequest.getAboveStrategyId());
        }
        if (orderListOcoRequest.getAboveStrategyType() != null) {
            localVarFormParams.put("aboveStrategyType", orderListOcoRequest.getAboveStrategyType());
        }
        if (orderListOcoRequest.getAbovePegPriceType() != null) {
            localVarFormParams.put("abovePegPriceType", (Object)orderListOcoRequest.getAbovePegPriceType());
        }
        if (orderListOcoRequest.getAbovePegOffsetType() != null) {
            localVarFormParams.put("abovePegOffsetType", (Object)orderListOcoRequest.getAbovePegOffsetType());
        }
        if (orderListOcoRequest.getAbovePegOffsetValue() != null) {
            localVarFormParams.put("abovePegOffsetValue", orderListOcoRequest.getAbovePegOffsetValue());
        }
        if (orderListOcoRequest.getBelowType() != null) {
            localVarFormParams.put("belowType", (Object)orderListOcoRequest.getBelowType());
        }
        if (orderListOcoRequest.getBelowClientOrderId() != null) {
            localVarFormParams.put("belowClientOrderId", orderListOcoRequest.getBelowClientOrderId());
        }
        if (orderListOcoRequest.getBelowIcebergQty() != null) {
            localVarFormParams.put("belowIcebergQty", orderListOcoRequest.getBelowIcebergQty());
        }
        if (orderListOcoRequest.getBelowPrice() != null) {
            localVarFormParams.put("belowPrice", DecimalFormatter.getFormatter().format(orderListOcoRequest.getBelowPrice()));
        }
        if (orderListOcoRequest.getBelowStopPrice() != null) {
            localVarFormParams.put("belowStopPrice", DecimalFormatter.getFormatter().format(orderListOcoRequest.getBelowStopPrice()));
        }
        if (orderListOcoRequest.getBelowTrailingDelta() != null) {
            localVarFormParams.put("belowTrailingDelta", orderListOcoRequest.getBelowTrailingDelta());
        }
        if (orderListOcoRequest.getBelowTimeInForce() != null) {
            localVarFormParams.put("belowTimeInForce", (Object)orderListOcoRequest.getBelowTimeInForce());
        }
        if (orderListOcoRequest.getBelowStrategyId() != null) {
            localVarFormParams.put("belowStrategyId", orderListOcoRequest.getBelowStrategyId());
        }
        if (orderListOcoRequest.getBelowStrategyType() != null) {
            localVarFormParams.put("belowStrategyType", orderListOcoRequest.getBelowStrategyType());
        }
        if (orderListOcoRequest.getBelowPegPriceType() != null) {
            localVarFormParams.put("belowPegPriceType", (Object)orderListOcoRequest.getBelowPegPriceType());
        }
        if (orderListOcoRequest.getBelowPegOffsetType() != null) {
            localVarFormParams.put("belowPegOffsetType", (Object)orderListOcoRequest.getBelowPegOffsetType());
        }
        if (orderListOcoRequest.getBelowPegOffsetValue() != null) {
            localVarFormParams.put("belowPegOffsetValue", orderListOcoRequest.getBelowPegOffsetValue());
        }
        if (orderListOcoRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)orderListOcoRequest.getNewOrderRespType());
        }
        if (orderListOcoRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)orderListOcoRequest.getSelfTradePreventionMode());
        }
        if (orderListOcoRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderListOcoRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderListOcoValidateBeforeCall(OrderListOcoRequest orderListOcoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderListOcoRequest};
            Method method = this.getClass().getMethod("orderListOco", OrderListOcoRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderListOcoCall(orderListOcoRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderListOcoResponse> orderListOco(@Valid @NotNull OrderListOcoRequest orderListOcoRequest) throws ApiException {
        Call localVarCall = this.orderListOcoValidateBeforeCall(orderListOcoRequest);
        Type localVarReturnType = new TypeToken<OrderListOcoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderListOtoCall(OrderListOtoRequest orderListOtoRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/orderList/oto";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderListOtoRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderListOtoRequest.getSymbol());
        }
        if (orderListOtoRequest.getListClientOrderId() != null) {
            localVarFormParams.put("listClientOrderId", orderListOtoRequest.getListClientOrderId());
        }
        if (orderListOtoRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)orderListOtoRequest.getNewOrderRespType());
        }
        if (orderListOtoRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)orderListOtoRequest.getSelfTradePreventionMode());
        }
        if (orderListOtoRequest.getWorkingType() != null) {
            localVarFormParams.put("workingType", (Object)orderListOtoRequest.getWorkingType());
        }
        if (orderListOtoRequest.getWorkingSide() != null) {
            localVarFormParams.put("workingSide", (Object)orderListOtoRequest.getWorkingSide());
        }
        if (orderListOtoRequest.getWorkingClientOrderId() != null) {
            localVarFormParams.put("workingClientOrderId", orderListOtoRequest.getWorkingClientOrderId());
        }
        if (orderListOtoRequest.getWorkingPrice() != null) {
            localVarFormParams.put("workingPrice", DecimalFormatter.getFormatter().format(orderListOtoRequest.getWorkingPrice()));
        }
        if (orderListOtoRequest.getWorkingQuantity() != null) {
            localVarFormParams.put("workingQuantity", DecimalFormatter.getFormatter().format(orderListOtoRequest.getWorkingQuantity()));
        }
        if (orderListOtoRequest.getWorkingIcebergQty() != null) {
            localVarFormParams.put("workingIcebergQty", DecimalFormatter.getFormatter().format(orderListOtoRequest.getWorkingIcebergQty()));
        }
        if (orderListOtoRequest.getWorkingTimeInForce() != null) {
            localVarFormParams.put("workingTimeInForce", (Object)orderListOtoRequest.getWorkingTimeInForce());
        }
        if (orderListOtoRequest.getWorkingStrategyId() != null) {
            localVarFormParams.put("workingStrategyId", orderListOtoRequest.getWorkingStrategyId());
        }
        if (orderListOtoRequest.getWorkingStrategyType() != null) {
            localVarFormParams.put("workingStrategyType", orderListOtoRequest.getWorkingStrategyType());
        }
        if (orderListOtoRequest.getWorkingPegPriceType() != null) {
            localVarFormParams.put("workingPegPriceType", (Object)orderListOtoRequest.getWorkingPegPriceType());
        }
        if (orderListOtoRequest.getWorkingPegOffsetType() != null) {
            localVarFormParams.put("workingPegOffsetType", (Object)orderListOtoRequest.getWorkingPegOffsetType());
        }
        if (orderListOtoRequest.getWorkingPegOffsetValue() != null) {
            localVarFormParams.put("workingPegOffsetValue", orderListOtoRequest.getWorkingPegOffsetValue());
        }
        if (orderListOtoRequest.getPendingType() != null) {
            localVarFormParams.put("pendingType", (Object)orderListOtoRequest.getPendingType());
        }
        if (orderListOtoRequest.getPendingSide() != null) {
            localVarFormParams.put("pendingSide", (Object)orderListOtoRequest.getPendingSide());
        }
        if (orderListOtoRequest.getPendingClientOrderId() != null) {
            localVarFormParams.put("pendingClientOrderId", orderListOtoRequest.getPendingClientOrderId());
        }
        if (orderListOtoRequest.getPendingPrice() != null) {
            localVarFormParams.put("pendingPrice", DecimalFormatter.getFormatter().format(orderListOtoRequest.getPendingPrice()));
        }
        if (orderListOtoRequest.getPendingStopPrice() != null) {
            localVarFormParams.put("pendingStopPrice", DecimalFormatter.getFormatter().format(orderListOtoRequest.getPendingStopPrice()));
        }
        if (orderListOtoRequest.getPendingTrailingDelta() != null) {
            localVarFormParams.put("pendingTrailingDelta", DecimalFormatter.getFormatter().format(orderListOtoRequest.getPendingTrailingDelta()));
        }
        if (orderListOtoRequest.getPendingQuantity() != null) {
            localVarFormParams.put("pendingQuantity", DecimalFormatter.getFormatter().format(orderListOtoRequest.getPendingQuantity()));
        }
        if (orderListOtoRequest.getPendingIcebergQty() != null) {
            localVarFormParams.put("pendingIcebergQty", DecimalFormatter.getFormatter().format(orderListOtoRequest.getPendingIcebergQty()));
        }
        if (orderListOtoRequest.getPendingTimeInForce() != null) {
            localVarFormParams.put("pendingTimeInForce", (Object)orderListOtoRequest.getPendingTimeInForce());
        }
        if (orderListOtoRequest.getPendingStrategyId() != null) {
            localVarFormParams.put("pendingStrategyId", orderListOtoRequest.getPendingStrategyId());
        }
        if (orderListOtoRequest.getPendingStrategyType() != null) {
            localVarFormParams.put("pendingStrategyType", orderListOtoRequest.getPendingStrategyType());
        }
        if (orderListOtoRequest.getPendingPegPriceType() != null) {
            localVarFormParams.put("pendingPegPriceType", (Object)orderListOtoRequest.getPendingPegPriceType());
        }
        if (orderListOtoRequest.getPendingPegOffsetType() != null) {
            localVarFormParams.put("pendingPegOffsetType", (Object)orderListOtoRequest.getPendingPegOffsetType());
        }
        if (orderListOtoRequest.getPendingPegOffsetValue() != null) {
            localVarFormParams.put("pendingPegOffsetValue", orderListOtoRequest.getPendingPegOffsetValue());
        }
        if (orderListOtoRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderListOtoRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderListOtoValidateBeforeCall(OrderListOtoRequest orderListOtoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderListOtoRequest};
            Method method = this.getClass().getMethod("orderListOto", OrderListOtoRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderListOtoCall(orderListOtoRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderListOtoResponse> orderListOto(@Valid @NotNull OrderListOtoRequest orderListOtoRequest) throws ApiException {
        Call localVarCall = this.orderListOtoValidateBeforeCall(orderListOtoRequest);
        Type localVarReturnType = new TypeToken<OrderListOtoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderListOtocoCall(OrderListOtocoRequest orderListOtocoRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/orderList/otoco";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderListOtocoRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderListOtocoRequest.getSymbol());
        }
        if (orderListOtocoRequest.getListClientOrderId() != null) {
            localVarFormParams.put("listClientOrderId", orderListOtocoRequest.getListClientOrderId());
        }
        if (orderListOtocoRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)orderListOtocoRequest.getNewOrderRespType());
        }
        if (orderListOtocoRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)orderListOtocoRequest.getSelfTradePreventionMode());
        }
        if (orderListOtocoRequest.getWorkingType() != null) {
            localVarFormParams.put("workingType", (Object)orderListOtocoRequest.getWorkingType());
        }
        if (orderListOtocoRequest.getWorkingSide() != null) {
            localVarFormParams.put("workingSide", (Object)orderListOtocoRequest.getWorkingSide());
        }
        if (orderListOtocoRequest.getWorkingClientOrderId() != null) {
            localVarFormParams.put("workingClientOrderId", orderListOtocoRequest.getWorkingClientOrderId());
        }
        if (orderListOtocoRequest.getWorkingPrice() != null) {
            localVarFormParams.put("workingPrice", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getWorkingPrice()));
        }
        if (orderListOtocoRequest.getWorkingQuantity() != null) {
            localVarFormParams.put("workingQuantity", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getWorkingQuantity()));
        }
        if (orderListOtocoRequest.getWorkingIcebergQty() != null) {
            localVarFormParams.put("workingIcebergQty", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getWorkingIcebergQty()));
        }
        if (orderListOtocoRequest.getWorkingTimeInForce() != null) {
            localVarFormParams.put("workingTimeInForce", (Object)orderListOtocoRequest.getWorkingTimeInForce());
        }
        if (orderListOtocoRequest.getWorkingStrategyId() != null) {
            localVarFormParams.put("workingStrategyId", orderListOtocoRequest.getWorkingStrategyId());
        }
        if (orderListOtocoRequest.getWorkingStrategyType() != null) {
            localVarFormParams.put("workingStrategyType", orderListOtocoRequest.getWorkingStrategyType());
        }
        if (orderListOtocoRequest.getWorkingPegPriceType() != null) {
            localVarFormParams.put("workingPegPriceType", (Object)orderListOtocoRequest.getWorkingPegPriceType());
        }
        if (orderListOtocoRequest.getWorkingPegOffsetType() != null) {
            localVarFormParams.put("workingPegOffsetType", (Object)orderListOtocoRequest.getWorkingPegOffsetType());
        }
        if (orderListOtocoRequest.getWorkingPegOffsetValue() != null) {
            localVarFormParams.put("workingPegOffsetValue", orderListOtocoRequest.getWorkingPegOffsetValue());
        }
        if (orderListOtocoRequest.getPendingSide() != null) {
            localVarFormParams.put("pendingSide", (Object)orderListOtocoRequest.getPendingSide());
        }
        if (orderListOtocoRequest.getPendingQuantity() != null) {
            localVarFormParams.put("pendingQuantity", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingQuantity()));
        }
        if (orderListOtocoRequest.getPendingAboveType() != null) {
            localVarFormParams.put("pendingAboveType", (Object)orderListOtocoRequest.getPendingAboveType());
        }
        if (orderListOtocoRequest.getPendingAboveClientOrderId() != null) {
            localVarFormParams.put("pendingAboveClientOrderId", orderListOtocoRequest.getPendingAboveClientOrderId());
        }
        if (orderListOtocoRequest.getPendingAbovePrice() != null) {
            localVarFormParams.put("pendingAbovePrice", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingAbovePrice()));
        }
        if (orderListOtocoRequest.getPendingAboveStopPrice() != null) {
            localVarFormParams.put("pendingAboveStopPrice", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingAboveStopPrice()));
        }
        if (orderListOtocoRequest.getPendingAboveTrailingDelta() != null) {
            localVarFormParams.put("pendingAboveTrailingDelta", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingAboveTrailingDelta()));
        }
        if (orderListOtocoRequest.getPendingAboveIcebergQty() != null) {
            localVarFormParams.put("pendingAboveIcebergQty", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingAboveIcebergQty()));
        }
        if (orderListOtocoRequest.getPendingAboveTimeInForce() != null) {
            localVarFormParams.put("pendingAboveTimeInForce", (Object)orderListOtocoRequest.getPendingAboveTimeInForce());
        }
        if (orderListOtocoRequest.getPendingAboveStrategyId() != null) {
            localVarFormParams.put("pendingAboveStrategyId", orderListOtocoRequest.getPendingAboveStrategyId());
        }
        if (orderListOtocoRequest.getPendingAboveStrategyType() != null) {
            localVarFormParams.put("pendingAboveStrategyType", orderListOtocoRequest.getPendingAboveStrategyType());
        }
        if (orderListOtocoRequest.getPendingAbovePegPriceType() != null) {
            localVarFormParams.put("pendingAbovePegPriceType", (Object)orderListOtocoRequest.getPendingAbovePegPriceType());
        }
        if (orderListOtocoRequest.getPendingAbovePegOffsetType() != null) {
            localVarFormParams.put("pendingAbovePegOffsetType", (Object)orderListOtocoRequest.getPendingAbovePegOffsetType());
        }
        if (orderListOtocoRequest.getPendingAbovePegOffsetValue() != null) {
            localVarFormParams.put("pendingAbovePegOffsetValue", orderListOtocoRequest.getPendingAbovePegOffsetValue());
        }
        if (orderListOtocoRequest.getPendingBelowType() != null) {
            localVarFormParams.put("pendingBelowType", (Object)orderListOtocoRequest.getPendingBelowType());
        }
        if (orderListOtocoRequest.getPendingBelowClientOrderId() != null) {
            localVarFormParams.put("pendingBelowClientOrderId", orderListOtocoRequest.getPendingBelowClientOrderId());
        }
        if (orderListOtocoRequest.getPendingBelowPrice() != null) {
            localVarFormParams.put("pendingBelowPrice", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingBelowPrice()));
        }
        if (orderListOtocoRequest.getPendingBelowStopPrice() != null) {
            localVarFormParams.put("pendingBelowStopPrice", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingBelowStopPrice()));
        }
        if (orderListOtocoRequest.getPendingBelowTrailingDelta() != null) {
            localVarFormParams.put("pendingBelowTrailingDelta", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingBelowTrailingDelta()));
        }
        if (orderListOtocoRequest.getPendingBelowIcebergQty() != null) {
            localVarFormParams.put("pendingBelowIcebergQty", DecimalFormatter.getFormatter().format(orderListOtocoRequest.getPendingBelowIcebergQty()));
        }
        if (orderListOtocoRequest.getPendingBelowTimeInForce() != null) {
            localVarFormParams.put("pendingBelowTimeInForce", (Object)orderListOtocoRequest.getPendingBelowTimeInForce());
        }
        if (orderListOtocoRequest.getPendingBelowStrategyId() != null) {
            localVarFormParams.put("pendingBelowStrategyId", orderListOtocoRequest.getPendingBelowStrategyId());
        }
        if (orderListOtocoRequest.getPendingBelowStrategyType() != null) {
            localVarFormParams.put("pendingBelowStrategyType", orderListOtocoRequest.getPendingBelowStrategyType());
        }
        if (orderListOtocoRequest.getPendingBelowPegPriceType() != null) {
            localVarFormParams.put("pendingBelowPegPriceType", (Object)orderListOtocoRequest.getPendingBelowPegPriceType());
        }
        if (orderListOtocoRequest.getPendingBelowPegOffsetType() != null) {
            localVarFormParams.put("pendingBelowPegOffsetType", (Object)orderListOtocoRequest.getPendingBelowPegOffsetType());
        }
        if (orderListOtocoRequest.getPendingBelowPegOffsetValue() != null) {
            localVarFormParams.put("pendingBelowPegOffsetValue", orderListOtocoRequest.getPendingBelowPegOffsetValue());
        }
        if (orderListOtocoRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderListOtocoRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderListOtocoValidateBeforeCall(OrderListOtocoRequest orderListOtocoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderListOtocoRequest};
            Method method = this.getClass().getMethod("orderListOtoco", OrderListOtocoRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderListOtocoCall(orderListOtocoRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderListOtocoResponse> orderListOtoco(@Valid @NotNull OrderListOtocoRequest orderListOtocoRequest) throws ApiException {
        Call localVarCall = this.orderListOtocoValidateBeforeCall(orderListOtocoRequest);
        Type localVarReturnType = new TypeToken<OrderListOtocoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderOcoCall(OrderOcoRequest orderOcoRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order/oco";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderOcoRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderOcoRequest.getSymbol());
        }
        if (orderOcoRequest.getListClientOrderId() != null) {
            localVarFormParams.put("listClientOrderId", orderOcoRequest.getListClientOrderId());
        }
        if (orderOcoRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)orderOcoRequest.getSide());
        }
        if (orderOcoRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(orderOcoRequest.getQuantity()));
        }
        if (orderOcoRequest.getLimitClientOrderId() != null) {
            localVarFormParams.put("limitClientOrderId", orderOcoRequest.getLimitClientOrderId());
        }
        if (orderOcoRequest.getPrice() != null) {
            localVarFormParams.put("price", DecimalFormatter.getFormatter().format(orderOcoRequest.getPrice()));
        }
        if (orderOcoRequest.getLimitStrategyId() != null) {
            localVarFormParams.put("limitStrategyId", orderOcoRequest.getLimitStrategyId());
        }
        if (orderOcoRequest.getLimitStrategyType() != null) {
            localVarFormParams.put("limitStrategyType", orderOcoRequest.getLimitStrategyType());
        }
        if (orderOcoRequest.getLimitIcebergQty() != null) {
            localVarFormParams.put("limitIcebergQty", DecimalFormatter.getFormatter().format(orderOcoRequest.getLimitIcebergQty()));
        }
        if (orderOcoRequest.getTrailingDelta() != null) {
            localVarFormParams.put("trailingDelta", orderOcoRequest.getTrailingDelta());
        }
        if (orderOcoRequest.getStopClientOrderId() != null) {
            localVarFormParams.put("stopClientOrderId", orderOcoRequest.getStopClientOrderId());
        }
        if (orderOcoRequest.getStopPrice() != null) {
            localVarFormParams.put("stopPrice", DecimalFormatter.getFormatter().format(orderOcoRequest.getStopPrice()));
        }
        if (orderOcoRequest.getStopStrategyId() != null) {
            localVarFormParams.put("stopStrategyId", orderOcoRequest.getStopStrategyId());
        }
        if (orderOcoRequest.getStopStrategyType() != null) {
            localVarFormParams.put("stopStrategyType", orderOcoRequest.getStopStrategyType());
        }
        if (orderOcoRequest.getStopLimitPrice() != null) {
            localVarFormParams.put("stopLimitPrice", DecimalFormatter.getFormatter().format(orderOcoRequest.getStopLimitPrice()));
        }
        if (orderOcoRequest.getStopIcebergQty() != null) {
            localVarFormParams.put("stopIcebergQty", DecimalFormatter.getFormatter().format(orderOcoRequest.getStopIcebergQty()));
        }
        if (orderOcoRequest.getStopLimitTimeInForce() != null) {
            localVarFormParams.put("stopLimitTimeInForce", (Object)orderOcoRequest.getStopLimitTimeInForce());
        }
        if (orderOcoRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)orderOcoRequest.getNewOrderRespType());
        }
        if (orderOcoRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)orderOcoRequest.getSelfTradePreventionMode());
        }
        if (orderOcoRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderOcoRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderOcoValidateBeforeCall(OrderOcoRequest orderOcoRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderOcoRequest};
            Method method = this.getClass().getMethod("orderOco", OrderOcoRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderOcoCall(orderOcoRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderOcoResponse> orderOco(@Valid @NotNull OrderOcoRequest orderOcoRequest) throws ApiException {
        Call localVarCall = this.orderOcoValidateBeforeCall(orderOcoRequest);
        Type localVarReturnType = new TypeToken<OrderOcoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call orderTestCall(OrderTestRequest orderTestRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/order/test";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (orderTestRequest.getComputeCommissionRates() != null) {
            localVarFormParams.put("computeCommissionRates", orderTestRequest.getComputeCommissionRates());
        }
        if (orderTestRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", orderTestRequest.getSymbol());
        }
        if (orderTestRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)orderTestRequest.getSide());
        }
        if (orderTestRequest.getType() != null) {
            localVarFormParams.put("type", (Object)orderTestRequest.getType());
        }
        if (orderTestRequest.getTimeInForce() != null) {
            localVarFormParams.put("timeInForce", (Object)orderTestRequest.getTimeInForce());
        }
        if (orderTestRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(orderTestRequest.getQuantity()));
        }
        if (orderTestRequest.getQuoteOrderQty() != null) {
            localVarFormParams.put("quoteOrderQty", DecimalFormatter.getFormatter().format(orderTestRequest.getQuoteOrderQty()));
        }
        if (orderTestRequest.getPrice() != null) {
            localVarFormParams.put("price", DecimalFormatter.getFormatter().format(orderTestRequest.getPrice()));
        }
        if (orderTestRequest.getNewClientOrderId() != null) {
            localVarFormParams.put("newClientOrderId", orderTestRequest.getNewClientOrderId());
        }
        if (orderTestRequest.getStrategyId() != null) {
            localVarFormParams.put("strategyId", orderTestRequest.getStrategyId());
        }
        if (orderTestRequest.getStrategyType() != null) {
            localVarFormParams.put("strategyType", orderTestRequest.getStrategyType());
        }
        if (orderTestRequest.getStopPrice() != null) {
            localVarFormParams.put("stopPrice", DecimalFormatter.getFormatter().format(orderTestRequest.getStopPrice()));
        }
        if (orderTestRequest.getTrailingDelta() != null) {
            localVarFormParams.put("trailingDelta", orderTestRequest.getTrailingDelta());
        }
        if (orderTestRequest.getIcebergQty() != null) {
            localVarFormParams.put("icebergQty", DecimalFormatter.getFormatter().format(orderTestRequest.getIcebergQty()));
        }
        if (orderTestRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)orderTestRequest.getNewOrderRespType());
        }
        if (orderTestRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)orderTestRequest.getSelfTradePreventionMode());
        }
        if (orderTestRequest.getPegPriceType() != null) {
            localVarFormParams.put("pegPriceType", (Object)orderTestRequest.getPegPriceType());
        }
        if (orderTestRequest.getPegOffsetValue() != null) {
            localVarFormParams.put("pegOffsetValue", orderTestRequest.getPegOffsetValue());
        }
        if (orderTestRequest.getPegOffsetType() != null) {
            localVarFormParams.put("pegOffsetType", (Object)orderTestRequest.getPegOffsetType());
        }
        if (orderTestRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", orderTestRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call orderTestValidateBeforeCall(OrderTestRequest orderTestRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{orderTestRequest};
            Method method = this.getClass().getMethod("orderTest", OrderTestRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.orderTestCall(orderTestRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<OrderTestResponse> orderTest(@Valid @NotNull OrderTestRequest orderTestRequest) throws ApiException {
        Call localVarCall = this.orderTestValidateBeforeCall(orderTestRequest);
        Type localVarReturnType = new TypeToken<OrderTestResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call sorOrderCall(SorOrderRequest sorOrderRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/sor/order";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sorOrderRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", sorOrderRequest.getSymbol());
        }
        if (sorOrderRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)sorOrderRequest.getSide());
        }
        if (sorOrderRequest.getType() != null) {
            localVarFormParams.put("type", (Object)sorOrderRequest.getType());
        }
        if (sorOrderRequest.getTimeInForce() != null) {
            localVarFormParams.put("timeInForce", (Object)sorOrderRequest.getTimeInForce());
        }
        if (sorOrderRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(sorOrderRequest.getQuantity()));
        }
        if (sorOrderRequest.getPrice() != null) {
            localVarFormParams.put("price", DecimalFormatter.getFormatter().format(sorOrderRequest.getPrice()));
        }
        if (sorOrderRequest.getNewClientOrderId() != null) {
            localVarFormParams.put("newClientOrderId", sorOrderRequest.getNewClientOrderId());
        }
        if (sorOrderRequest.getStrategyId() != null) {
            localVarFormParams.put("strategyId", sorOrderRequest.getStrategyId());
        }
        if (sorOrderRequest.getStrategyType() != null) {
            localVarFormParams.put("strategyType", sorOrderRequest.getStrategyType());
        }
        if (sorOrderRequest.getIcebergQty() != null) {
            localVarFormParams.put("icebergQty", DecimalFormatter.getFormatter().format(sorOrderRequest.getIcebergQty()));
        }
        if (sorOrderRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)sorOrderRequest.getNewOrderRespType());
        }
        if (sorOrderRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)sorOrderRequest.getSelfTradePreventionMode());
        }
        if (sorOrderRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", sorOrderRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call sorOrderValidateBeforeCall(SorOrderRequest sorOrderRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{sorOrderRequest};
            Method method = this.getClass().getMethod("sorOrder", SorOrderRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.sorOrderCall(sorOrderRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<SorOrderResponse> sorOrder(@Valid @NotNull SorOrderRequest sorOrderRequest) throws ApiException {
        Call localVarCall = this.sorOrderValidateBeforeCall(sorOrderRequest);
        Type localVarReturnType = new TypeToken<SorOrderResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call sorOrderTestCall(SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/sor/order/test";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (sorOrderTestRequest.getComputeCommissionRates() != null) {
            localVarFormParams.put("computeCommissionRates", sorOrderTestRequest.getComputeCommissionRates());
        }
        if (sorOrderTestRequest.getSymbol() != null) {
            localVarFormParams.put("symbol", sorOrderTestRequest.getSymbol());
        }
        if (sorOrderTestRequest.getSide() != null) {
            localVarFormParams.put("side", (Object)sorOrderTestRequest.getSide());
        }
        if (sorOrderTestRequest.getType() != null) {
            localVarFormParams.put("type", (Object)sorOrderTestRequest.getType());
        }
        if (sorOrderTestRequest.getTimeInForce() != null) {
            localVarFormParams.put("timeInForce", (Object)sorOrderTestRequest.getTimeInForce());
        }
        if (sorOrderTestRequest.getQuantity() != null) {
            localVarFormParams.put("quantity", DecimalFormatter.getFormatter().format(sorOrderTestRequest.getQuantity()));
        }
        if (sorOrderTestRequest.getPrice() != null) {
            localVarFormParams.put("price", DecimalFormatter.getFormatter().format(sorOrderTestRequest.getPrice()));
        }
        if (sorOrderTestRequest.getNewClientOrderId() != null) {
            localVarFormParams.put("newClientOrderId", sorOrderTestRequest.getNewClientOrderId());
        }
        if (sorOrderTestRequest.getStrategyId() != null) {
            localVarFormParams.put("strategyId", sorOrderTestRequest.getStrategyId());
        }
        if (sorOrderTestRequest.getStrategyType() != null) {
            localVarFormParams.put("strategyType", sorOrderTestRequest.getStrategyType());
        }
        if (sorOrderTestRequest.getIcebergQty() != null) {
            localVarFormParams.put("icebergQty", DecimalFormatter.getFormatter().format(sorOrderTestRequest.getIcebergQty()));
        }
        if (sorOrderTestRequest.getNewOrderRespType() != null) {
            localVarFormParams.put("newOrderRespType", (Object)sorOrderTestRequest.getNewOrderRespType());
        }
        if (sorOrderTestRequest.getSelfTradePreventionMode() != null) {
            localVarFormParams.put("selfTradePreventionMode", (Object)sorOrderTestRequest.getSelfTradePreventionMode());
        }
        if (sorOrderTestRequest.getRecvWindow() != null) {
            localVarFormParams.put("recvWindow", sorOrderTestRequest.getRecvWindow());
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("binanceSignature");
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "POST", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call sorOrderTestValidateBeforeCall(SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{sorOrderTestRequest};
            Method method = this.getClass().getMethod("sorOrderTest", SorOrderTestRequest.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.sorOrderTestCall(sorOrderTestRequest);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<SorOrderTestResponse> sorOrderTest(@Valid @NotNull SorOrderTestRequest sorOrderTestRequest) throws ApiException {
        Call localVarCall = this.sorOrderTestValidateBeforeCall(sorOrderTestRequest);
        Type localVarReturnType = new TypeToken<SorOrderTestResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }
}

