/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.spot.rest.api;

import com.binance.connector.client.common.ApiClient;
import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.ApiResponse;
import com.binance.connector.client.common.JSON;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.configuration.ClientConfiguration;
import com.binance.connector.client.common.exception.ConstraintViolationException;
import com.binance.connector.client.spot.rest.model.ExchangeInfoResponse;
import com.binance.connector.client.spot.rest.model.Permissions;
import com.binance.connector.client.spot.rest.model.SymbolStatus;
import com.binance.connector.client.spot.rest.model.Symbols;
import com.binance.connector.client.spot.rest.model.TimeResponse;
import com.google.gson.reflect.TypeToken;
import jakarta.validation.MessageInterpolator;
import jakarta.validation.Validation;
import jakarta.validation.Validator;
import jakarta.validation.executable.ExecutableValidator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import okhttp3.Call;
import org.hibernate.validator.messageinterpolation.ParameterMessageInterpolator;

public class GeneralApi {
    private ApiClient localVarApiClient;
    private int localHostIndex;
    private String localCustomBaseUrl;
    private static final String USER_AGENT = String.format("binance-spot/6.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private static final boolean HAS_TIME_UNIT = true;

    public GeneralApi(ClientConfiguration clientConfiguration) {
        this(new ApiClient(clientConfiguration));
    }

    public GeneralApi(ApiClient apiClient) {
        apiClient.setUserAgent(USER_AGENT);
        this.localVarApiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.localVarApiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.localVarApiClient = apiClient;
    }

    public int getHostIndex() {
        return this.localHostIndex;
    }

    public void setHostIndex(int hostIndex) {
        this.localHostIndex = hostIndex;
    }

    public String getCustomBaseUrl() {
        return this.localCustomBaseUrl;
    }

    public void setCustomBaseUrl(String customBaseUrl) {
        this.localCustomBaseUrl = customBaseUrl;
    }

    private Call exchangeInfoCall(String symbol, Symbols symbols, Permissions permissions, Boolean showPermissionSets, SymbolStatus symbolStatus) throws ApiException {
        String[] localVarAccepts;
        String localVarAccept;
        String json;
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/exchangeInfo";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        if (symbol != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbol", (Object)symbol));
        }
        if (symbols != null) {
            json = JSON.getGson().toJson((Object)symbols);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbols", (Object)json));
        }
        if (permissions != null) {
            json = JSON.getGson().toJson((Object)permissions);
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("permissions", (Object)json));
        }
        if (showPermissionSets != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("showPermissionSets", (Object)showPermissionSets));
        }
        if (symbolStatus != null) {
            localVarQueryParams.addAll(this.localVarApiClient.parameterToPair("symbolStatus", (Object)symbolStatus));
        }
        if ((localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts = new String[]{"application/json"})) != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call exchangeInfoValidateBeforeCall(String symbol, Symbols symbols, Permissions permissions, Boolean showPermissionSets, SymbolStatus symbolStatus) throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{symbol, symbols, permissions, showPermissionSets, symbolStatus};
            Method method = this.getClass().getMethod("exchangeInfo", String.class, Symbols.class, Permissions.class, Boolean.class, SymbolStatus.class);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.exchangeInfoCall(symbol, symbols, permissions, showPermissionSets, symbolStatus);
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<ExchangeInfoResponse> exchangeInfo(String symbol, Symbols symbols, Permissions permissions, Boolean showPermissionSets, SymbolStatus symbolStatus) throws ApiException {
        Call localVarCall = this.exchangeInfoValidateBeforeCall(symbol, symbols, permissions, showPermissionSets, symbolStatus);
        Type localVarReturnType = new TypeToken<ExchangeInfoResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }

    private Call pingCall() throws ApiException {
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/ping";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call pingValidateBeforeCall() throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{};
            Method method = this.getClass().getMethod("ping", new Class[0]);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.pingCall();
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<Void> ping() throws ApiException {
        Call localVarCall = this.pingValidateBeforeCall();
        return this.localVarApiClient.execute(localVarCall);
    }

    private Call timeCall() throws ApiException {
        String basePath = null;
        String[] localBasePaths = new String[]{};
        basePath = this.localCustomBaseUrl != null ? this.localCustomBaseUrl : (localBasePaths.length > 0 ? localBasePaths[this.localHostIndex] : null);
        Object localVarPostBody = null;
        String localVarPath = "/api/v3/time";
        ArrayList localVarQueryParams = new ArrayList();
        ArrayList localVarCollectionQueryParams = new ArrayList();
        HashMap<String, String> localVarHeaderParams = new HashMap<String, String>();
        HashMap localVarCookieParams = new HashMap();
        HashMap localVarFormParams = new HashMap();
        String[] localVarAccepts = new String[]{"application/json"};
        String localVarAccept = this.localVarApiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) {
            localVarHeaderParams.put("Accept", localVarAccept);
        }
        String[] localVarContentTypes = new String[]{"application/x-www-form-urlencoded"};
        String localVarContentType = this.localVarApiClient.selectHeaderContentType(localVarContentTypes);
        if (!localVarFormParams.isEmpty() && localVarContentType != null) {
            localVarHeaderParams.put("Content-Type", localVarContentType);
        }
        HashSet<String> localVarAuthNames = new HashSet<String>();
        localVarAuthNames.add("timeUnit");
        return this.localVarApiClient.buildCall(basePath, localVarPath, "GET", localVarQueryParams, localVarCollectionQueryParams, localVarPostBody, localVarHeaderParams, localVarCookieParams, localVarFormParams, localVarAuthNames);
    }

    private Call timeValidateBeforeCall() throws ApiException {
        try {
            Validator validator = Validation.byDefaultProvider().configure().messageInterpolator((MessageInterpolator)new ParameterMessageInterpolator()).buildValidatorFactory().getValidator();
            ExecutableValidator executableValidator = validator.forExecutables();
            Object[] parameterValues = new Object[]{};
            Method method = this.getClass().getMethod("time", new Class[0]);
            Set violations = executableValidator.validateParameters((Object)this, method, parameterValues, new Class[0]);
            if (violations.size() == 0) {
                return this.timeCall();
            }
            throw new ConstraintViolationException(violations);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
        catch (SecurityException e) {
            e.printStackTrace();
            throw new ApiException(e.getMessage());
        }
    }

    public ApiResponse<TimeResponse> time() throws ApiException {
        Call localVarCall = this.timeValidateBeforeCall();
        Type localVarReturnType = new TypeToken<TimeResponse>(){}.getType();
        return this.localVarApiClient.execute(localVarCall, localVarReturnType);
    }
}

