/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class VIPLoans {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String ONGOING_ORDERS = "/sapi/v1/loan/vip/ongoing/orders";
    private final String REPAY = "/sapi/v1/loan/vip/repay";
    private final String REPAYMENT_HISTORY = "/sapi/v1/loan/vip/repay/history";
    private final String RENEW = "/sapi/v1/loan/vip/renew";
    private final String COLLATERAL_ACCOUNT = "/sapi/v1/loan/vip/collateral/account";
    private final String BORROW = "/sapi/v1/loan/vip/borrow";
    private final String LOANABLE_ASSETS = "/sapi/v1/loan/vip/loanable/data";
    private final String COLLATERAL_ASSET_DATA = "/sapi/v1/loan/vip/collateral/data";
    private final String ORDER_STATUS = "/sapi/v1/loan/vip/request/data";
    private final String BORROW_INTEREST_RATE = "/sapi/v1/loan/vip/request/interestRate";

    public VIPLoans(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public VIPLoans(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String ongoingOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/ongoing/orders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String repay(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "orderId", Long.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String repaymentHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/repay/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String renew(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "orderId", Long.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/renew", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String collateralAccount(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/collateral/account", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String borrow(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanAccountId", Long.class);
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "loanAmount");
        ParameterChecker.checkParameter(parameters, "collateralAccountId", String.class);
        ParameterChecker.checkParameter(parameters, "collateralCoin", String.class);
        ParameterChecker.checkParameter(parameters, "isFlexibleRate", Boolean.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/borrow", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String loanableAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/loanable/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String collateralAsset(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/collateral/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String orderStatus(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/request/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String borrowInterestRate(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/vip/request/interestRate", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

