/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.impl.spot;

import com.binance.connector.client.enums.HttpMethod;
import com.binance.connector.client.utils.ParameterChecker;
import com.binance.connector.client.utils.ProxyAuth;
import com.binance.connector.client.utils.RequestHandler;
import com.binance.connector.client.utils.signaturegenerator.HmacSignatureGenerator;
import com.binance.connector.client.utils.signaturegenerator.SignatureGenerator;
import java.util.Map;

public class CryptoLoans {
    private final String baseUrl;
    private final RequestHandler requestHandler;
    private final boolean showLimitUsage;
    private final String LOAN_INCOME = "/sapi/v1/loan/income";
    private final String LOAN_BORROW = "/sapi/v1/loan/borrow";
    private final String LOAN_BORROW_HISTORY = "/sapi/v1/loan/borrow/history";
    private final String LOAN_ONGOING_ORDERS = "/sapi/v1/loan/ongoing/orders";
    private final String LOAN_REPAY = "/sapi/v1/loan/repay";
    private final String LOAN_REPAY_HISTORY = "/sapi/v1/loan/repay/history";
    private final String LOAN_ADJUST_LTV = "/sapi/v1/loan/adjust/ltv";
    private final String LOAN_ADJUST_LTV_HISTORY = "/sapi/v1/loan/ltv/adjustment/history";
    private final String LOANABLE_ASSETS_DATA = "/sapi/v1/loan/loanable/data";
    private final String COLLATERAL_ASSETS_DATA = "/sapi/v1/loan/collateral/data";
    private final String COLLATERAL_REPAY_RATE = "/sapi/v1/loan/repay/collateral/rate";
    private final String CUSTOMIZE_MARGIN_CALL = "/sapi/v1/loan/customize/margin_call";
    private final String FLEXIBLE_LOAN_BORROW = "/sapi/v1/loan/flexible/borrow";
    private final String FLEXIBLE_LOAN_ONGOING_ORDERS = "/sapi/v1/loan/flexible/ongoing/orders";
    private final String FLEXIBLE_LOAN_BORROW_HISTORY = "/sapi/v1/loan/flexible/borrow/history";
    private final String FLEXIBLE_LOAN_REPAY = "/sapi/v1/loan/flexible/repay";
    private final String FLEXIBLE_LOAN_REPAY_HISTORY = "/sapi/v1/loan/flexible/repay/history";
    private final String FLEXIBLE_LOAN_ADJUST_LTV = "/sapi/v1/loan/flexible/adjust/ltv";
    private final String FLEXIBLE_LOAN_LTV_ADJUST_HISTORY = "/sapi/v1/loan/flexible/ltv/adjustment/history";
    private final String FLEXIBLE_LOAN_ASSETS = "/sapi/v1/loan/flexible/loanable/data";
    private final String FLEXIBLE_LOAN_COLLATERAL_ASSETS = "/sapi/v1/loan/flexible/collateral/data";

    public CryptoLoans(String baseUrl, String apiKey, String secretKey, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, new HmacSignatureGenerator(secretKey), proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public CryptoLoans(String baseUrl, String apiKey, SignatureGenerator signatureGenerator, boolean showLimitUsage, ProxyAuth proxy) {
        this.baseUrl = baseUrl;
        this.requestHandler = new RequestHandler(apiKey, signatureGenerator, proxy);
        this.showLimitUsage = showLimitUsage;
    }

    public String loanIncome(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "asset", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/income", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanBorrow(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        ParameterChecker.checkParameter(parameters, "collateralCoin", String.class);
        ParameterChecker.checkParameter(parameters, "loanTerm", Integer.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/borrow", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String loanBorrowHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/borrow/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanOngoingOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/ongoing/orders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanRepay(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "orderId", Long.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String loanRepayHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/repay/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanAdjustLTV(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "orderId", Long.class);
        ParameterChecker.checkRequiredParameter(parameters, "amount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/adjust/ltv", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String loanAdjustLTVHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/ltv/adjustment/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String loanAssetsData(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/loanable/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String collateralAssetsData(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/collateral/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String collateralRepayRate(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        ParameterChecker.checkParameter(parameters, "collateralCoin", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "repayAmount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/repay/collateral/rate", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String customizeMarginCall(Map<String, Object> parameters) {
        ParameterChecker.checkRequiredParameter(parameters, "marginCall");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/customize/margin_call", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexibleLoanBorrow(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        ParameterChecker.checkParameter(parameters, "collateralCoin", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/borrow", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexibleLoanOngoingOrders(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/ongoing/orders", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleLoanBorrowHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/borrow/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleLoanRepay(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        ParameterChecker.checkParameter(parameters, "collateralCoin", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "repayAmount");
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/repay", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexibleLoanRepayHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/repay/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleLoanAdjustLtv(Map<String, Object> parameters) {
        ParameterChecker.checkParameter(parameters, "loanCoin", String.class);
        ParameterChecker.checkParameter(parameters, "collateralCoin", String.class);
        ParameterChecker.checkRequiredParameter(parameters, "adjustmentAmount");
        ParameterChecker.checkParameter(parameters, "direction", String.class);
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/adjust/ltv", parameters, HttpMethod.POST, this.showLimitUsage);
    }

    public String flexibleLoanLtvAdjustHistory(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/ltv/adjustment/history", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleLoanAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/loanable/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }

    public String flexibleLoanCollateralAssets(Map<String, Object> parameters) {
        return this.requestHandler.sendSignedRequest(this.baseUrl, "/sapi/v1/loan/flexible/collateral/data", parameters, HttpMethod.GET, this.showLimitUsage);
    }
}

