/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.dtos;

import com.binance.connector.client.common.JSON;
import com.binance.connector.client.common.websocket.dtos.BaseDTO;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import jakarta.annotation.Nullable;
import jakarta.validation.Valid;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class SessionResponse
extends BaseDTO {
    private static final int DIFF_TILL_POSITION_INDEX = 1;
    private static final int MAX_DECIMAL_DIGITS = 30;
    private static DecimalFormat df;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    @Nullable
    private String id;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nullable
    private Integer status;
    public static final String SERIALIZED_NAME_RESULT = "result";
    @SerializedName(value="result")
    @Nullable
    private Object result;
    private static final HashSet<String> openapiFields;
    private static final HashSet<String> openapiRequiredFields;

    public SessionResponse id(@Nullable String id) {
        this.id = id;
        return this;
    }

    @Nullable
    public String getId() {
        return this.id;
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    public SessionResponse status(@Nullable Integer status) {
        this.status = status;
        return this;
    }

    @Nullable
    public Integer getStatus() {
        return this.status;
    }

    public void setStatus(@Nullable Integer status) {
        this.status = status;
    }

    public SessionResponse result(@Nullable Object result) {
        this.result = result;
        return this;
    }

    @Nullable
    @Valid
    public Object getResult() {
        return this.result;
    }

    public void setResult(@Nullable Object result) {
        this.result = result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SessionResponse sessionLogonResponse = (SessionResponse)o;
        return Objects.equals(this.id, sessionLogonResponse.id) && Objects.equals(this.status, sessionLogonResponse.status) && Objects.equals(this.result, sessionLogonResponse.result);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.status, this.result);
    }

    @Override
    public String toString() {
        String sb = "class SessionLogonResponse {\n\t\tid: " + this.toIndentedString(this.id) + "\n\t\tstatus: " + this.toIndentedString(this.status) + "\n\t\tresult: " + this.toIndentedString(this.result) + "\n}";
        return sb;
    }

    @Override
    public String toUrlQueryString() {
        Object resultValue;
        Integer statusValue;
        TreeMap<String, String> valMap = new TreeMap<String, String>();
        valMap.put("apiKey", this.getApiKey());
        String idValue = this.getId();
        if (idValue != null) {
            String idValueAsString = "";
            idValueAsString = idValue.toString();
            valMap.put(SERIALIZED_NAME_ID, SessionResponse.urlEncode(idValueAsString));
        }
        if ((statusValue = this.getStatus()) != null) {
            String statusValueAsString = "";
            statusValueAsString = ((Object)statusValue).toString();
            valMap.put(SERIALIZED_NAME_STATUS, SessionResponse.urlEncode(statusValueAsString));
        }
        if ((resultValue = this.getResult()) != null) {
            String resultValueAsString = "";
            resultValueAsString = resultValue.toString();
            valMap.put(SERIALIZED_NAME_RESULT, SessionResponse.urlEncode(resultValueAsString));
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap.keySet().stream().map(key -> key + "=" + (String)valMap.get(key)).collect(Collectors.joining("&"));
    }

    public Map<String, Object> toMap() {
        Object resultValue;
        Integer statusValue;
        TreeMap<String, Object> valMap = new TreeMap<String, Object>();
        valMap.put("apiKey", this.getApiKey());
        String idValue = this.getId();
        if (idValue != null) {
            valMap.put(SERIALIZED_NAME_ID, idValue);
        }
        if ((statusValue = this.getStatus()) != null) {
            valMap.put(SERIALIZED_NAME_STATUS, statusValue);
        }
        if ((resultValue = this.getResult()) != null) {
            valMap.put(SERIALIZED_NAME_RESULT, resultValue);
        }
        valMap.put("timestamp", this.getTimestamp());
        return valMap;
    }

    public static String urlEncode(String s) {
        return URLEncoder.encode(s, StandardCharsets.UTF_8);
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n\t\t");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SessionLogonResponse is not found in the empty JSON string", openapiRequiredFields));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SessionLogonResponse` properties. JSON: %s", entry.getKey(), jsonElement));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
    }

    public static SessionResponse fromJson(String jsonString) throws IOException {
        return (SessionResponse)JSON.getGson().fromJson(jsonString, SessionResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    private static DecimalFormat getFormatter() {
        if (null == df) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.ENGLISH);
            df = new DecimalFormat("#,##0.###", symbols);
            df.setMaximumFractionDigits(30);
            df.setGroupingUsed(false);
        }
        return df;
    }

    static {
        openapiFields = new HashSet();
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_RESULT);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SessionResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SessionResponse.class));
            return new TypeAdapter<SessionResponse>(this){
                final /* synthetic */ CustomTypeAdapterFactory this$0;
                {
                    this.this$0 = this$0;
                }

                public void write(JsonWriter out, SessionResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SessionResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    return (SessionResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

