/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.adapter;

import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.adapter.ConnectionWrapper;
import com.binance.connector.client.common.websocket.configuration.WebSocketClientConfiguration;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.RequestWrapperDTO;
import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;

public class PoolConnectionWrapper
implements ConnectionInterface {
    private final LinkedList<ConnectionWrapper> connectionList = new LinkedList();
    private ListIterator<ConnectionWrapper> pool;
    private boolean isConnected = false;
    private String userAgent = String.format("binance-connector-java/1.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());

    public PoolConnectionWrapper(WebSocketClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public PoolConnectionWrapper(WebSocketClientConfiguration clientConfiguration, Gson gson) {
        final Integer poolSize = clientConfiguration.getPoolSize();
        final Integer batchSize = clientConfiguration.getReconnectBatchSize();
        Integer reconnectAfter = clientConfiguration.getReconnectIntervalTime();
        for (int i = 0; i < poolSize; ++i) {
            ConnectionWrapper connectionWrapper = new ConnectionWrapper(clientConfiguration, gson);
            this.connectionList.add(connectionWrapper);
        }
        new Timer().scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ PoolConnectionWrapper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    for (int i = 0; i < batchSize; ++i) {
                        int currentBatchSize = poolSize / batchSize;
                        if (i == batchSize - 1) {
                            currentBatchSize += poolSize % batchSize;
                        }
                        for (int j = 0; j < currentBatchSize; ++j) {
                            int connectionIndex = poolSize / batchSize * i + j;
                            ConnectionWrapper connectionWrapper = this.this$0.connectionList.get(connectionIndex);
                            if (connectionWrapper.canReconnect()) {
                                connectionWrapper.connect();
                                continue;
                            }
                            connectionWrapper.setPendingReconnect(true);
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, reconnectAfter.intValue(), (long)reconnectAfter.intValue());
        this.pool = this.connectionList.listIterator();
    }

    @Override
    public void connect() {
        for (ConnectionWrapper connectionWrapper : this.connectionList) {
            connectionWrapper.setUserAgent(this.userAgent);
            connectionWrapper.connect();
        }
        this.isConnected = true;
    }

    @Override
    public void send(ApiRequestWrapperDTO request) throws InterruptedException {
        this.getConnection().send(request);
    }

    @Override
    public void send(RequestWrapperDTO request) throws InterruptedException {
        this.getConnection().send(request);
    }

    @Override
    public BlockingQueue<String> sendForStream(ApiRequestWrapperDTO request) throws InterruptedException {
        return this.getConnection().sendForStream(request);
    }

    public ConnectionWrapper getConnection() {
        if (!this.pool.hasNext()) {
            this.pool = this.connectionList.listIterator();
        }
        ConnectionWrapper connection = this.pool.next();
        while (!connection.isReady()) {
            if (!this.pool.hasNext()) {
                this.pool = this.connectionList.listIterator();
                continue;
            }
            connection = this.pool.next();
        }
        return connection;
    }

    @Override
    public void setUserAgent(String userAgent) {
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }
}

