/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.adapter;

import com.binance.connector.client.common.ApiException;
import com.binance.connector.client.common.DecimalFormatter;
import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.auth.SignatureGeneratorFactory;
import com.binance.connector.client.common.sign.SignatureGenerator;
import com.binance.connector.client.common.websocket.SignatureUtil;
import com.binance.connector.client.common.websocket.adapter.ConnectionInterface;
import com.binance.connector.client.common.websocket.configuration.WebSocketClientConfiguration;
import com.binance.connector.client.common.websocket.dtos.ApiRequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.common.websocket.dtos.RequestWrapperDTO;
import com.binance.connector.client.common.websocket.dtos.SessionLogonResponse;
import com.binance.connector.client.common.websocket.service.DeserializeExclusionStrategy;
import com.binance.connector.client.common.websocket.service.SerializeExclusionStrategy;
import com.google.gson.ExclusionStrategy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.text.DecimalFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bouncycastle.crypto.CryptoException;
import org.eclipse.jetty.client.HttpClient;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.websocket.api.Session;
import org.eclipse.jetty.websocket.api.WebSocketListener;
import org.eclipse.jetty.websocket.api.WriteCallback;
import org.eclipse.jetty.websocket.client.ClientUpgradeRequest;
import org.eclipse.jetty.websocket.client.WebSocketClient;

public class ConnectionWrapper
implements WebSocketListener,
ConnectionInterface {
    private static final Logger log = Logger.getLogger(ConnectionWrapper.class.getName());
    public static final int WAIT_TIME = 5;
    private static final String QUERY_PARAM_TIME_UNIT = "timeUnit";
    private static final List<Integer> ERROR_CODE_WRONG_CREDENTIALS = Arrays.asList(-2015, -1022);
    private static final String LOGON_METHOD = "session.logon";
    private static final String LOGOUT_METHOD = "session.logout";
    protected Map<String, RequestWrapperDTO> pendingRequest = new HashMap<String, RequestWrapperDTO>();
    protected Session session;
    protected Session oldSession;
    private String userAgent = String.format("binance-connector-java/1.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private boolean isLoggedOn = false;
    private boolean isReady = false;
    private boolean canReconnect = true;
    private final WebSocketClient webSocketClient;
    private final WebSocketClientConfiguration configuration;
    private final SignatureGeneratorFactory signatureGeneratorFactory = new SignatureGeneratorFactory();
    private Gson gson;
    private SignatureGenerator signatureGenerator;
    private CountDownLatch countDownLatch;
    private boolean pendingReconnect = false;
    private List<BlockingQueue<String>> streamQueues = new ArrayList<BlockingQueue<String>>();

    public ConnectionWrapper(WebSocketClientConfiguration configuration, Gson gson) {
        this(configuration, null, gson);
    }

    public ConnectionWrapper(WebSocketClientConfiguration configuration) {
        this(configuration, null, null);
    }

    public ConnectionWrapper(WebSocketClientConfiguration configuration, WebSocketClient webSocketClient) {
        this(configuration, webSocketClient, null);
    }

    public ConnectionWrapper(WebSocketClientConfiguration configuration, WebSocketClient webSocketClient, Gson gson) {
        if (webSocketClient == null) {
            HttpClient httpClient = new HttpClient();
            httpClient.setUserAgentField(new HttpField(HttpHeader.USER_AGENT, this.userAgent));
            if (configuration.getConnectTimeout() != null) {
                httpClient.setConnectTimeout((long)configuration.getConnectTimeout().intValue());
            }
            if (configuration.getWebSocketProxy() != null) {
                httpClient.getProxyConfiguration().addProxy(configuration.getWebSocketProxy());
                if (configuration.getWebSocketProxyAuthentication() != null) {
                    httpClient.getAuthenticationStore().addAuthentication(configuration.getWebSocketProxyAuthentication());
                }
            }
            webSocketClient = new WebSocketClient(httpClient);
        }
        webSocketClient.setIdleTimeout(Duration.ZERO);
        if (configuration.getMessageMaxSize() != null) {
            webSocketClient.setMaxTextMessageSize(configuration.getMessageMaxSize().longValue());
        }
        if (!webSocketClient.isStarted() && !webSocketClient.isStarting()) {
            try {
                webSocketClient.start();
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        }
        this.configuration = configuration;
        this.webSocketClient = webSocketClient;
        this.gson = gson == null ? new GsonBuilder().registerTypeAdapter(Double.class, (src, typeOfSrc, context) -> {
            DecimalFormat df = DecimalFormatter.getFormatter();
            return new JsonPrimitive(df.format(src));
        }).addSerializationExclusionStrategy((ExclusionStrategy)new SerializeExclusionStrategy()).addDeserializationExclusionStrategy((ExclusionStrategy)new DeserializeExclusionStrategy()).create() : gson;
        Integer reconnectAfter = configuration.getReconnectIntervalTime();
        new Timer().scheduleAtFixedRate(new TimerTask(){

            @Override
            public void run() {
                try {
                    if (ConnectionWrapper.this.canReconnect()) {
                        ConnectionWrapper.this.connect();
                    } else {
                        ConnectionWrapper.this.pendingReconnect = true;
                    }
                }
                catch (Exception e) {
                    System.out.println(e);
                    throw new RuntimeException(e);
                }
            }
        }, reconnectAfter.intValue(), (long)reconnectAfter.intValue());
    }

    @Override
    public void connect() {
        try {
            this.connect(null);
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
    }

    public void connect(Consumer<Session> customCallback) throws IOException, URISyntaxException, InterruptedException {
        boolean await;
        this.pendingReconnect = false;
        boolean autoLogon = this.configuration.getAutoLogon();
        this.countDownLatch = new CountDownLatch(autoLogon ? 1 : 0);
        Consumer<Session> callback = autoLogon ? this.getLogonConsumer() : null;
        URI serverURI = null;
        serverURI = this.getUri(this.configuration.getUrl());
        if (this.configuration.getSignatureConfiguration() != null) {
            this.signatureGenerator = this.signatureGeneratorFactory.getSignatureGenerator(this.configuration.getSignatureConfiguration());
        }
        this.beforeConnect();
        ClientUpgradeRequest clientUpgradeRequest = null;
        if (this.configuration.getCompression().booleanValue()) {
            clientUpgradeRequest = new ClientUpgradeRequest();
            clientUpgradeRequest.addExtensions(new String[]{"permessage-deflate"});
        }
        CompletableFuture clientSessionPromise = this.webSocketClient.connect((Object)this, serverURI, clientUpgradeRequest);
        Session session = (Session)clientSessionPromise.join();
        if (callback != null) {
            callback.accept(session);
        }
        if (customCallback != null) {
            customCallback.accept(session);
        }
        if (!(await = this.countDownLatch.await(5L, TimeUnit.SECONDS))) {
            log.log(Level.WARNING, "countDownLatch wait timeout");
        }
        this.afterConnect(session);
    }

    public Consumer<Session> getLogonConsumer() {
        return session -> {
            try {
                this.logOn((Session)session);
            }
            catch (Exception e) {
                throw new ApiException(e);
            }
        };
    }

    public void onWebSocketPing(ByteBuffer payload) {
        this.session.getRemote().sendPong(payload, WriteCallback.NOOP);
    }

    public Map<String, RequestWrapperDTO> getPendingRequest() {
        return this.pendingRequest;
    }

    public boolean isPendingReconnect() {
        return this.pendingReconnect;
    }

    public void setPendingReconnect(boolean pendingReconnect) {
        this.pendingReconnect = pendingReconnect;
    }

    public boolean isReady() {
        return this.isReady && this.session.isOpen();
    }

    public void setReady(boolean ready) {
        this.isReady = ready;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(String userAgent) {
        if (this.webSocketClient != null) {
            this.webSocketClient.getHttpClient().setUserAgentField(new HttpField(HttpHeader.USER_AGENT, userAgent));
        }
    }

    public void onWebSocketError(Throwable cause) {
        if (cause instanceof ClosedChannelException) {
            log.info("channel was closed: " + cause.getMessage());
        } else {
            log.log(Level.SEVERE, "received webSocket error", cause);
        }
    }

    public void onWebSocketClose(int statusCode, String reason) {
        if (statusCode == 1000) {
            log.info("received websocket close, code: " + statusCode + " reason: " + reason);
            return;
        }
        if (statusCode == 1006) {
            Collection openSessions = this.webSocketClient.getOpenSessions();
            for (Session openSession : openSessions) {
                if (this.oldSession == null || this.oldSession.isOpen() || !openSession.equals((Object)this.oldSession)) continue;
                log.info("old session closing, code: " + statusCode + " reason: " + reason);
                return;
            }
        }
        log.log(Level.SEVERE, "received websocket close, code: " + statusCode + " reason: " + reason);
        if (this.canReconnect) {
            try {
                this.connect();
            }
            catch (Exception e) {
                log.log(Level.SEVERE, "Error while trying to reconnect", e);
            }
        }
    }

    @Override
    public void send(RequestWrapperDTO request) {
        this.send(request, this.session);
    }

    @Override
    public void send(ApiRequestWrapperDTO request) {
        Object baseRequest = request.getParams();
        if (baseRequest == null) {
            baseRequest = new BaseRequestDTO();
        }
        if (request.isApiKeyOnly() && ((BaseRequestDTO)baseRequest).getApiKey() == null) {
            ((BaseRequestDTO)baseRequest).setApiKey(this.configuration.getSignatureConfiguration().getApiKey());
        }
        if (request.isSigned()) {
            ((BaseRequestDTO)baseRequest).setTimestamp(this.getTimestamp().toString());
            if (!this.isLoggedOn) {
                if (((BaseRequestDTO)baseRequest).getApiKey() == null) {
                    ((BaseRequestDTO)baseRequest).setApiKey(this.configuration.getSignatureConfiguration().getApiKey());
                }
                try {
                    ((BaseRequestDTO)baseRequest).setSignature(this.signatureGenerator.signAsString(((BaseRequestDTO)baseRequest).toUrlQueryString()));
                }
                catch (CryptoException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        this.innerSend(request);
    }

    @Override
    public BlockingQueue<String> sendForStream(ApiRequestWrapperDTO request) throws InterruptedException {
        LinkedBlockingDeque<String> streamQueue = new LinkedBlockingDeque<String>();
        this.streamQueues.add(streamQueue);
        this.send(request);
        return streamQueue;
    }

    public void innerSend(RequestWrapperDTO requestWrapperDTO) {
        this.send(requestWrapperDTO);
    }

    public void send(final RequestWrapperDTO request, Session session) {
        session.getRemote().sendString(this.gson.toJson((Object)request), new WriteCallback(){
            final /* synthetic */ ConnectionWrapper this$0;
            {
                this.this$0 = this$0;
            }

            public void writeFailed(Throwable x) {
                throw new ApiException(x);
            }

            public void writeSuccess() {
                this.this$0.pendingRequest.put(request.getId(), request);
            }
        });
    }

    public Long getTimestamp() {
        return System.currentTimeMillis();
    }

    public void logOn(Session session) throws CryptoException {
        SignatureUtil signatureUtil = new SignatureUtil();
        String timestamp = signatureUtil.buildTimestamp();
        BaseRequestDTO build = new BaseRequestDTO.Builder().apiKey(this.configuration.getSignatureConfiguration().getApiKey()).timestamp(timestamp).build();
        build.setSignature(this.signatureGenerator.signAsString(build.toString()));
        RequestWrapperDTO request = new RequestWrapperDTO.Builder().id(UUID.randomUUID().toString()).method(LOGON_METHOD).params(build).responseType((Type)((Object)SessionLogonResponse.class)).build();
        request.getResponseCallback().handle((resp, error) -> {
            if (error != null) {
                log.log(Level.SEVERE, "Logon request failed", (Throwable)error);
            }
            if (resp.getError() != null) {
                if (ERROR_CODE_WRONG_CREDENTIALS.contains(resp.getError().getCode())) {
                    this.canReconnect = false;
                }
                log.log(Level.SEVERE, "Logon request failed", new ApiException(resp.getError().getCode(), resp.getError().getMsg()));
            }
            this.countDownLatch.countDown();
            return resp;
        });
        this.send(request, session);
    }

    public void onWebSocketConnect(Session session) {
        this.session = session;
    }

    public void onWebSocketText(String message) {
        try {
            JsonElement root = JsonParser.parseString((String)message);
            JsonObject obj = root.getAsJsonObject();
            JsonElement idElem = obj.get("id");
            String id = idElem == null ? null : idElem.getAsString();
            RequestWrapperDTO requestWrapperDTO = null;
            if (id != null) {
                requestWrapperDTO = this.pendingRequest.get(id);
            }
            if (requestWrapperDTO == null) {
                for (BlockingQueue<String> streamQueue : this.streamQueues) {
                    JsonElement eventElem = obj.get("event");
                    streamQueue.offer(eventElem != null ? eventElem.toString() : message);
                }
                return;
            }
            Type responseType = requestWrapperDTO.getResponseType();
            Object responseResult = this.gson.fromJson(root, responseType);
            this.pendingRequest.remove(id);
            if (LOGON_METHOD.equals(requestWrapperDTO.getMethod()) && obj.get("status").getAsInt() == 200) {
                this.isLoggedOn = true;
            }
            if (LOGOUT_METHOD.equals(requestWrapperDTO.getMethod()) && obj.get("status").getAsInt() == 200) {
                this.isLoggedOn = false;
            }
            requestWrapperDTO.getResponseCallback().complete(responseResult);
            if (this.isPendingReconnect() && this.pendingRequest.isEmpty()) {
                this.connect();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Exception while receiving message from WS connection", e);
            throw new RuntimeException(e);
        }
    }

    public boolean canReconnect() {
        return this.isReady && this.pendingRequest.isEmpty();
    }

    protected void beforeConnect() {
        if (this.session != null && this.session.isOpen()) {
            this.oldSession = this.session;
        }
    }

    protected void afterConnect(Session session) {
        this.session = session;
        if (this.oldSession != null) {
            this.oldSession.close(1000, "close after reconnect", WriteCallback.NOOP);
        }
        this.setReady(true);
    }

    @Override
    public boolean isConnected() {
        return this.session != null && this.session.isOpen();
    }

    public URI getUri(String uri) throws URISyntaxException {
        URI oldUri = new URI(uri);
        if (this.configuration.getTimeUnit() == null || oldUri.getQuery() != null && oldUri.getQuery().contains("timeUnit=")) {
            return oldUri;
        }
        Object newQuery = oldUri.getQuery();
        String appendQuery = "timeUnit=" + String.valueOf((Object)this.configuration.getTimeUnit());
        newQuery = newQuery == null ? appendQuery : (String)newQuery + "&" + appendQuery;
        return new URI(oldUri.getScheme(), oldUri.getAuthority(), oldUri.getPath(), (String)newQuery, oldUri.getFragment());
    }
}

