/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.dtos;

import com.binance.connector.client.common.websocket.dtos.BaseRequestDTO;
import com.binance.connector.client.common.websocket.dtos.RequestWrapperDTO;
import java.lang.reflect.Type;

public class ApiRequestWrapperDTO<T extends BaseRequestDTO, U>
extends RequestWrapperDTO<T, U> {
    private transient boolean signed = true;
    private transient boolean apiKeyOnly = false;

    public boolean isApiKeyOnly() {
        return this.apiKeyOnly;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public void setSigned(boolean signed) {
        this.signed = signed;
    }

    public ApiRequestWrapperDTO(String id, T params, String method, boolean signed) {
        super(id, params, method);
        this.signed = signed;
    }

    @Override
    public T getParams() {
        return (T)((BaseRequestDTO)this.params);
    }

    private ApiRequestWrapperDTO(Builder<T, U> builder) {
        this.id = builder.id;
        this.params = builder.params;
        this.method = builder.method;
        this.responseType = builder.responseType;
        this.signed = builder.signed;
        this.apiKeyOnly = builder.apiKeyOnly;
    }

    public static final class Builder<T extends BaseRequestDTO, U> {
        private String id;
        private T params;
        private String method;
        private Type responseType;
        private boolean signed = true;
        private boolean apiKeyOnly = false;

        public Builder<T, U> id(String val) {
            this.id = val;
            return this;
        }

        public Builder<T, U> params(T val) {
            this.params = val;
            return this;
        }

        public Builder<T, U> method(String val) {
            this.method = val;
            return this;
        }

        public Builder<T, U> responseType(Type val) {
            this.responseType = val;
            return this;
        }

        public Builder<T, U> signed(Boolean val) {
            this.signed = val;
            return this;
        }

        public Builder<T, U> apiKeyOnly(Boolean val) {
            this.apiKeyOnly = val;
            return this;
        }

        public ApiRequestWrapperDTO<T, U> build() {
            return new ApiRequestWrapperDTO(this);
        }
    }
}

