/*
 * Decompiled with CFR 0.152.
 */
package com.binance.connector.client.common.websocket.adapter.stream;

import com.binance.connector.client.common.SystemUtil;
import com.binance.connector.client.common.websocket.adapter.ConnectionWrapper;
import com.binance.connector.client.common.websocket.adapter.stream.StreamConnectionInterface;
import com.binance.connector.client.common.websocket.adapter.stream.StreamConnectionWrapper;
import com.binance.connector.client.common.websocket.configuration.WebSocketClientConfiguration;
import com.binance.connector.client.common.websocket.dtos.RequestWrapperDTO;
import com.binance.connector.client.common.websocket.service.StreamBlockingQueue;
import com.binance.connector.client.common.websocket.service.StreamBlockingQueueWrapper;
import com.google.gson.Gson;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;

public class StreamConnectionPoolWrapper
implements StreamConnectionInterface {
    private final LinkedList<StreamConnectionWrapper> connectionList = new LinkedList();
    private ListIterator<StreamConnectionWrapper> pool;
    private Boolean isConnected = false;
    private String userAgent = String.format("binance-connector-java/1.0.0 (Java/%s; %s; %s)", SystemUtil.getJavaVersion(), SystemUtil.getOs(), SystemUtil.getArch());
    private final Map<String, StreamConnectionWrapper> connectionStreamMap = new HashMap<String, StreamConnectionWrapper>();

    public StreamConnectionPoolWrapper(WebSocketClientConfiguration clientConfiguration) {
        this(clientConfiguration, null);
    }

    public StreamConnectionPoolWrapper(WebSocketClientConfiguration clientConfiguration, Gson gson) {
        final Integer poolSize = clientConfiguration.getPoolSize();
        final Integer batchSize = clientConfiguration.getReconnectBatchSize();
        Integer reconnectAfter = clientConfiguration.getReconnectIntervalTime();
        for (int i = 0; i < poolSize; ++i) {
            StreamConnectionWrapper connectionWrapper = new StreamConnectionWrapper(clientConfiguration, gson);
            this.connectionList.add(connectionWrapper);
        }
        new Timer().scheduleAtFixedRate(new TimerTask(this){
            final /* synthetic */ StreamConnectionPoolWrapper this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void run() {
                try {
                    for (int i = 0; i < batchSize; ++i) {
                        int currentBatchSize = poolSize / batchSize;
                        if (i == batchSize - 1) {
                            currentBatchSize += poolSize % batchSize;
                        }
                        for (int j = 0; j < currentBatchSize; ++j) {
                            int connectionIndex = poolSize / batchSize * i + j;
                            ConnectionWrapper connectionWrapper = this.this$0.connectionList.get(connectionIndex);
                            if (!connectionWrapper.canReconnect()) continue;
                            connectionWrapper.connect();
                        }
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }, reconnectAfter.intValue(), (long)reconnectAfter.intValue());
        this.pool = this.connectionList.listIterator();
    }

    @Override
    public void connect() {
        for (ConnectionWrapper connectionWrapper : this.connectionList) {
            connectionWrapper.setUserAgent(this.userAgent);
            connectionWrapper.connect();
        }
        this.isConnected = true;
    }

    @Override
    public Map<String, StreamBlockingQueue<String>> subscribe(RequestWrapperDTO<Set<String>, Object> requestWrapperDTO) {
        Set<String> params = requestWrapperDTO.getParams();
        HashMap<String, StreamBlockingQueue<String>> queueMap = new HashMap<String, StreamBlockingQueue<String>>();
        for (String identifier : params) {
            StreamConnectionWrapper connection = this.getConnection(identifier);
            queueMap.putAll(connection.subscribe(requestWrapperDTO));
        }
        return queueMap;
    }

    @Override
    public void unsubscribe(StreamBlockingQueueWrapper queue) {
        this.unsubscribe(queue.getInnerQueue());
    }

    @Override
    public void unsubscribe(StreamBlockingQueue queue) {
        StreamConnectionWrapper connection = this.getConnection(queue.getOperationId());
        connection.unsubscribe(queue);
        this.connectionStreamMap.remove(queue.getOperationId());
    }

    public StreamConnectionWrapper getConnection(String identifier) {
        if (this.connectionStreamMap.containsKey(identifier)) {
            return this.connectionStreamMap.get(identifier);
        }
        StreamConnectionWrapper connection = this.getConnection();
        this.connectionStreamMap.put(identifier, connection);
        return connection;
    }

    public StreamConnectionWrapper getConnection() {
        if (!this.pool.hasNext()) {
            this.pool = this.connectionList.listIterator();
        }
        StreamConnectionWrapper connection = this.pool.next();
        while (!connection.isReady()) {
            if (!this.pool.hasNext()) {
                this.pool = this.connectionList.listIterator();
                continue;
            }
            connection = this.pool.next();
        }
        return connection;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }
}

