/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.regexp;

import com.jn.langx.annotation.Nullable;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.regexp.Regexp;
import com.jn.langx.util.regexp.Regexps;

public class RegexpPatterns {
    public static final String CHINESE_CHAR_PATTERN = "[\\x{4E00}-\\x{9FFF}\\x{2E80}-\\x{2EFF}\\x{2F00}-\\x{2FDF}\\x{3000}-\\x{303F}\\x{31C0}-\\x{31EF}\\x{3400}-\\x{4DBF}\\x{F900}-\\x{FAFF}\\x{FE30}-\\x{FE4F}\\x{20000}-\\x{2A6DF}\\x{2A700}-\\x{2EBEF}\\x{2F800}\u2014\\x{2FA1F}\\x{30000}\u2014\\x{3134F}]";
    public static final Regexp CHINESE_CHAR = Regexps.createRegexp("[\\x{4E00}-\\x{9FFF}\\x{2E80}-\\x{2EFF}\\x{2F00}-\\x{2FDF}\\x{3000}-\\x{303F}\\x{31C0}-\\x{31EF}\\x{3400}-\\x{4DBF}\\x{F900}-\\x{FAFF}\\x{FE30}-\\x{FE4F}\\x{20000}-\\x{2A6DF}\\x{2A700}-\\x{2EBEF}\\x{2F800}\u2014\\x{2FA1F}\\x{30000}\u2014\\x{3134F}]");
    public static final Regexp CHINESE_CHARS = Regexps.createRegexp("[\\x{4E00}-\\x{9FFF}\\x{2E80}-\\x{2EFF}\\x{2F00}-\\x{2FDF}\\x{3000}-\\x{303F}\\x{31C0}-\\x{31EF}\\x{3400}-\\x{4DBF}\\x{F900}-\\x{FAFF}\\x{FE30}-\\x{FE4F}\\x{20000}-\\x{2A6DF}\\x{2A700}-\\x{2EBEF}\\x{2F800}\u2014\\x{2FA1F}\\x{30000}\u2014\\x{3134F}]+");
    public static final Regexp COMMA_SPLIT_PATTERN = Regexps.createRegexp("\\s*[,]+\\s*");
    public static final Regexp PATTERN_HEX = Regexps.createRegexp("^[a-f0-9]+$", 2);
    public static final Regexp PATTERN_ZIP_CODE = Regexps.createRegexp("[1-9]\\d{5}(?!\\d)");
    public static final Regexp PATTERN_MOBILE = Regexps.createRegexp("(?:0|86|\\+86)?1[3-9]\\d{9}");
    public static final Regexp PATTERN_IDENTITY = Regexps.createRegexp("[1-9]\\d{5}[1-2]\\d{3}((0\\d)|(1[0-2]))(([012]\\d)|3[0-1])\\d{3}(\\d|X|x)");
    public static final Regexp PATTERN_PLATE_NUMBER = Regexps.createRegexp("^(([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z](([0-9]{5}[ABCDEFGHJK])|([ABCDEFGHJK]([A-HJ-NP-Z0-9])[0-9]{4})))|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886]\\d{3}\\d{1,3}[\u9886])|([\u4eac\u6d25\u6caa\u6e1d\u5180\u8c6b\u4e91\u8fbd\u9ed1\u6e58\u7696\u9c81\u65b0\u82cf\u6d59\u8d63\u9102\u6842\u7518\u664b\u8499\u9655\u5409\u95fd\u8d35\u7ca4\u9752\u85cf\u5ddd\u5b81\u743c\u4f7f\u9886][A-Z][A-HJ-NP-Z0-9]{4}[A-HJ-NP-Z0-9\u6302\u5b66\u8b66\u6e2f\u6fb3\u4f7f\u9886]))$");
    public static final Regexp PATTERN_SOCIAL_CREDIT_CODE = Regexps.createRegexp("^[0-9A-HJ-NPQRTUWXY]{2}\\d{6}[0-9A-HJ-NPQRTUWXY]{10}$");
    public static final Regexp PATTERN_EMAIL = Regexps.createRegexp("(?:[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\\.[a-z0-9!#$%&'*+/=?^_`{|}~-]+)*|\"(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21\\x23-\\x5b\\x5d-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])*\")@(?:(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?|\\[(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?|[a-z0-9-]*[a-z0-9]:(?:[\\x01-\\x08\\x0b\\x0c\\x0e-\\x1f\\x21-\\x5a\\x53-\\x7f]|\\\\[\\x01-\\x09\\x0b\\x0c\\x0e-\\x7f])+)])", 2);
    public static Regexp PATTERN_IP = Regexps.createRegexp("(?:(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)\\\\.){3}(?:25[0-5]|2[0-4][0-9]|[01]?[0-9][0-9]?)");
    public static Regexp PATTERN_URL = Regexps.createRegexp("^(https?|ftp|file)://[-a-zA-Z0-9+&@#/%?=~_|!:,.;]*[-a-zA-Z0-9+&@#/%=~_|]");
    public static Regexp PATTERN_QQ = Regexps.createRegexp("[1-9]\\d{4,9}");

    private RegexpPatterns() {
    }

    public static boolean test(String pattern, String string) {
        return RegexpPatterns.test(Regexps.createRegexp(pattern), string);
    }

    public static boolean test(@Nullable Regexp pattern, @Nullable String string) {
        if (pattern == null) {
            return Emptys.isEmpty(string);
        }
        if (Emptys.isEmpty(string)) {
            return false;
        }
        return pattern.matcher(string).matches();
    }

    public static boolean contains(@Nullable String text, @Nullable Regexp pattern) {
        if (pattern == null) {
            return Emptys.isEmpty(text);
        }
        if (Emptys.isEmpty(text)) {
            return false;
        }
        return pattern.matcher(text).find();
    }
}

