/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.os;

import com.jn.langx.util.Strings;
import java.util.Locale;

public final class OS {
    private static final String FAMILY_OS_400 = "os/400";
    private static final String FAMILY_Z_OS = "z/os";
    private static final String FAMILY_WIN9X = "win9x";
    private static final String FAMILY_OPENVMS = "openvms";
    private static final String FAMILY_UNIX = "unix";
    private static final String FAMILY_TANDEM = "tandem";
    private static final String FAMILY_MAC = "mac";
    private static final String FAMILY_DOS = "dos";
    private static final String FAMILY_NETWARE = "netware";
    private static final String FAMILY_OS_2 = "os/2";
    private static final String FAMILY_WINDOWS = "windows";
    private static final String FAMILY_LINUX = "linux";
    private static final String OS_NAME = System.getProperty("os.name").toLowerCase(Locale.US);
    private static final String OS_ARCH = System.getProperty("os.arch").toLowerCase(Locale.US);
    private static final String OS_VERSION = System.getProperty("os.version").toLowerCase(Locale.US);
    private static final String PATH_SEP = System.getProperty("path.separator");

    private OS() {
    }

    private static boolean isFamily(String family) {
        return OS.isOs(family, null, null, null);
    }

    public static boolean isFamilyAIX() {
        return OS.isFamily("aix");
    }

    public static boolean isFamilySolaris() {
        return OS.isFamily("solaris");
    }

    public static boolean isFamilySunOs() {
        return OS.isFamily("sunos");
    }

    public static boolean isFamilyDOS() {
        return OS.isFamily(FAMILY_DOS);
    }

    public static boolean isFamilyMac() {
        return OS.isFamily(FAMILY_MAC);
    }

    public static boolean isMaxOSX() {
        return OS.isFamilyMac() && OS.isOs(null, "mac os x", null, null);
    }

    public static boolean isFamilyHP_UX() {
        return OS.isFamily("hp-ux");
    }

    public static boolean isFamilyIrix() {
        return OS.isFamily("irix");
    }

    public static boolean isFamilyNetware() {
        return OS.isFamily(FAMILY_NETWARE);
    }

    public static boolean isFamilyOS2() {
        return OS.isFamily(FAMILY_OS_2);
    }

    public static boolean isFamilyTandem() {
        return OS.isFamily(FAMILY_TANDEM);
    }

    public static boolean isFamilyUnix() {
        return OS.isFamily(FAMILY_UNIX);
    }

    public static boolean isFamilyWindows() {
        return OS.isFamily(FAMILY_WINDOWS);
    }

    public static boolean isFamilyWin9x() {
        return OS.isFamily(FAMILY_WIN9X);
    }

    public static boolean isWindows95() {
        return OS.isOs(FAMILY_WINDOWS, "windows 9", null, "4.0");
    }

    public static boolean isWindows98() {
        return OS.isOs(FAMILY_WINDOWS, "windows 9", null, "4.1");
    }

    public static boolean isWindowsME() {
        return OS.isOs(FAMILY_WINDOWS, null, null, "4.9");
    }

    public static boolean isWindowsNT() {
        return OS.isOs(FAMILY_WINDOWS, "windows nt", null, "4.9");
    }

    public static boolean isWindows2000() {
        return OS.isOs(FAMILY_WINDOWS, null, null, "5.0");
    }

    public static boolean isWindowsXP() {
        return OS.isOs(FAMILY_WINDOWS, null, null, "5.1");
    }

    public static boolean isWindowsVista() {
        return OS.isOs(FAMILY_WINDOWS, null, null, "6.0");
    }

    public static boolean isWindows7() {
        return OS.isOs(FAMILY_WINDOWS, null, null, "6.1");
    }

    public static boolean isFamilyZOS() {
        return OS.isFamily(FAMILY_Z_OS);
    }

    public static boolean isFamilyOS400() {
        return OS.isFamily(FAMILY_OS_400);
    }

    public static boolean isFamilyOpenVms() {
        return OS.isFamily(FAMILY_OPENVMS);
    }

    public static boolean isFamilyLinux() {
        return OS.isFamily(FAMILY_LINUX);
    }

    public static boolean isLinux() {
        return OS.isFamilyLinux();
    }

    public static boolean isName(String name) {
        return OS.isOs(null, name, null, null);
    }

    public static boolean isArch(String arch) {
        return OS.isOs(null, null, arch, null);
    }

    public static boolean isVersion(String version) {
        return OS.isOs(null, null, null, version);
    }

    public static boolean isOs(String familyFlag, String nameFlag, String archFlag, String versionFlag) {
        boolean retValue = false;
        if (familyFlag != null || nameFlag != null || archFlag != null || versionFlag != null) {
            boolean isFamily = true;
            boolean isName = true;
            boolean isArch = true;
            boolean isVersion = true;
            if (familyFlag != null) {
                isFamily = familyFlag.equals(FAMILY_WINDOWS) ? OS_NAME.contains(FAMILY_WINDOWS) : (familyFlag.equals(FAMILY_OS_2) ? OS_NAME.contains(FAMILY_OS_2) : (familyFlag.equals(FAMILY_NETWARE) ? OS_NAME.contains(FAMILY_NETWARE) : (familyFlag.equals(FAMILY_DOS) ? PATH_SEP.equals(";") && !OS.isFamily(FAMILY_NETWARE) : (familyFlag.equals(FAMILY_MAC) ? OS_NAME.contains(FAMILY_MAC) : (familyFlag.equals(FAMILY_TANDEM) ? OS_NAME.contains("nonstop_kernel") : (familyFlag.equals(FAMILY_UNIX) ? PATH_SEP.equals(":") && !OS.isFamily(FAMILY_OPENVMS) && (!OS.isFamily(FAMILY_MAC) || OS_NAME.endsWith("x")) : (familyFlag.equals(FAMILY_WIN9X) ? OS.isFamily(FAMILY_WINDOWS) && (OS_NAME.contains("95") || OS_NAME.contains("98") || OS_NAME.contains("me") || OS_NAME.contains("ce")) : (familyFlag.equals(FAMILY_Z_OS) ? OS_NAME.contains(FAMILY_Z_OS) || OS_NAME.contains("os/390") : (familyFlag.equals(FAMILY_OS_400) ? OS_NAME.contains(FAMILY_OS_400) : (familyFlag.equals(FAMILY_OPENVMS) ? OS_NAME.contains(FAMILY_OPENVMS) : (familyFlag.equals(FAMILY_LINUX) ? OS_NAME.contains("nux") : OS_NAME.contains(familyFlag))))))))))));
            }
            if (nameFlag != null) {
                isName = Strings.startsWith(OS_NAME, nameFlag);
            }
            if (archFlag != null) {
                isArch = archFlag.equals(OS_ARCH);
            }
            if (versionFlag != null) {
                isVersion = Strings.startsWith(OS_VERSION, versionFlag);
            }
            retValue = isFamily && isName && isArch && isVersion;
        }
        return retValue;
    }
}

