/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.net.ipv6;

import com.jn.langx.util.net.ipv6.IPv6Address;
import com.jn.langx.util.net.ipv6.IPv6AddressRange;
import com.jn.langx.util.net.ipv6.IPv6NetworkHelpers;
import com.jn.langx.util.net.ipv6.IPv6NetworkMask;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.NoSuchElementException;

public final class IPv6Network
extends IPv6AddressRange {
    public static final IPv6Network MULTICAST_NETWORK = IPv6Network.fromString("ff00::/8");
    public static final IPv6Network SITE_LOCAL_NETWORK = IPv6Network.fromString("fec0::/48");
    public static final IPv6Network LINK_LOCAL_NETWORK = IPv6Network.fromString("fe80::/64");
    private final IPv6Address address;
    private final IPv6NetworkMask networkMask;

    private IPv6Network(IPv6Address address, IPv6NetworkMask networkMask) {
        super(address.maskWithNetworkMask(networkMask), address.maximumAddressWithNetworkMask(networkMask));
        this.address = address.maskWithNetworkMask(networkMask);
        this.networkMask = networkMask;
    }

    public static IPv6Network fromAddressAndMask(IPv6Address address, IPv6NetworkMask networkMask) {
        return new IPv6Network(address, networkMask);
    }

    public static IPv6Network fromTwoAddresses(IPv6Address one, IPv6Address two) {
        IPv6NetworkMask longestPrefixLength = IPv6NetworkMask.fromPrefixLength(IPv6NetworkHelpers.longestPrefixLength(one, two));
        return new IPv6Network(one.maskWithNetworkMask(longestPrefixLength), longestPrefixLength);
    }

    public static IPv6Network fromString(String string) {
        if (string.indexOf(47) == -1) {
            throw new IllegalArgumentException("Expected format is network-address/prefix-length");
        }
        String networkAddressString = IPv6Network.parseNetworkAddress(string);
        int prefixLength = IPv6Network.parsePrefixLength(string);
        IPv6Address networkAddress = IPv6Address.fromString(networkAddressString);
        return IPv6Network.fromAddressAndMask(networkAddress, new IPv6NetworkMask(prefixLength));
    }

    private static String parseNetworkAddress(String string) {
        return string.substring(0, string.indexOf(47));
    }

    private static int parsePrefixLength(String string) {
        try {
            return Integer.parseInt(string.substring(string.indexOf(47) + 1));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Prefix length should be a positive integer");
        }
    }

    public Iterator<IPv6Network> split(IPv6NetworkMask size) {
        if (size.asPrefixLength() < this.getNetmask().asPrefixLength()) {
            throw new IllegalArgumentException(String.format("Can not split a network of size %s in subnets of larger size %s", this.getNetmask().asPrefixLength(), size.asPrefixLength()));
        }
        return new IPv6NetworkSplitsIterator(size);
    }

    @Override
    public String toString() {
        return this.address.toString() + "/" + this.networkMask.asPrefixLength();
    }

    @Override
    public String toLongString() {
        return this.address.toLongString() + "/" + this.networkMask.asPrefixLength();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IPv6Network that = (IPv6Network)o;
        if (this.address != null ? !this.address.equals(that.address) : that.address != null) {
            return false;
        }
        return !(this.networkMask != null ? !this.networkMask.equals(that.networkMask) : that.networkMask != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.address != null ? this.address.hashCode() : 0);
        result = 31 * result + (this.networkMask != null ? this.networkMask.hashCode() : 0);
        return result;
    }

    public IPv6NetworkMask getNetmask() {
        return this.networkMask;
    }

    private final class IPv6NetworkSplitsIterator
    implements Iterator<IPv6Network> {
        private final IPv6NetworkMask size;
        private IPv6Network current;
        private BigInteger nbrAddressesPerSplit;

        public IPv6NetworkSplitsIterator(IPv6NetworkMask size) {
            this.size = size;
            this.nbrAddressesPerSplit = BigInteger.ONE.shiftLeft(128 - size.asPrefixLength());
            this.current = IPv6Network.fromAddressAndMask(IPv6Network.this.address, size);
        }

        @Override
        public boolean hasNext() {
            return this.current.getLast().compareTo(IPv6Network.this.getLast()) <= 0;
        }

        @Override
        public IPv6Network next() {
            if (this.hasNext()) {
                IPv6Network result = this.current;
                this.current = this.calculateNext(this.current);
                return result;
            }
            throw new NoSuchElementException();
        }

        private IPv6Network calculateNext(IPv6Network current) {
            BigInteger next = current.address.toBigInteger().add(this.nbrAddressesPerSplit);
            return IPv6Network.fromAddressAndMask(IPv6Address.fromBigInteger(next), this.size);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("This iterator provides read only access");
        }
    }
}

