/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.logging;

import com.jn.langx.annotation.NonNull;
import com.jn.langx.annotation.Nullable;
import com.jn.langx.text.StringTemplates;
import com.jn.langx.util.Emptys;
import com.jn.langx.util.Preconditions;
import com.jn.langx.util.Throwables;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Supplier;
import com.jn.langx.util.logging.Level;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Loggers {
    public static void log(@NonNull Throwable ex) {
        Loggers.log(1, null, null, ex, (Supplier<Object[], String>)null, new Object[0]);
    }

    public static void log(@Nullable Logger logger, @Nullable Level level, @Nullable Throwable ex, String message, Object ... args) {
        Loggers.log(1, logger, level, ex, Loggers.buildPlaceholderMessageSupplierOrNull(message, args), args);
    }

    public static void log(int count, @Nullable Logger logger, @Nullable Level level, @Nullable Throwable ex, @Nullable String message, Object ... args) {
        Loggers.log(count, logger, level, ex, Loggers.buildPlaceholderMessageSupplierOrNull(message, args), args);
    }

    public static void log(int count, @Nullable Logger logger, @Nullable Level level, final @Nullable Throwable ex, Supplier<Object[], String> messageSupplier, Object ... args) {
        Preconditions.checkNotNull(messageSupplier, "the message supplier is null");
        if (logger == null) {
            logger = ex == null ? Loggers.getLogger(Loggers.class) : Loggers.getLogger(Throwables.class);
        }
        if (level == null) {
            level = ex == null ? Level.INFO : Level.ERROR;
        }
        if (count < 1) {
            count = 1;
        }
        if (count > 3) {
            count = 3;
        }
        final String message = messageSupplier.get(args);
        final Logger lgr = logger;
        switch (level) {
            case TRACE: {
                if (!logger.isTraceEnabled()) break;
                Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                    @Override
                    public void accept(Integer index) {
                        if (ex != null) {
                            lgr.trace(message, ex);
                        } else {
                            lgr.trace(message);
                        }
                    }
                });
                break;
            }
            case DEBUG: {
                if (!logger.isDebugEnabled()) break;
                Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                    @Override
                    public void accept(Integer index) {
                        if (ex != null) {
                            lgr.debug(message, ex);
                        } else {
                            lgr.debug(message);
                        }
                    }
                });
                break;
            }
            case INFO: {
                if (!logger.isInfoEnabled()) break;
                Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                    @Override
                    public void accept(Integer index) {
                        if (ex != null) {
                            lgr.info(message, ex);
                        } else {
                            lgr.info(message);
                        }
                    }
                });
                break;
            }
            case WARN: {
                if (!logger.isWarnEnabled()) break;
                Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                    @Override
                    public void accept(Integer index) {
                        if (ex != null) {
                            lgr.warn(message, ex);
                        } else {
                            lgr.warn(message);
                        }
                    }
                });
                break;
            }
            case ERROR: {
                if (!logger.isErrorEnabled()) break;
                Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                    @Override
                    public void accept(Integer index) {
                        if (ex != null) {
                            lgr.error(message, ex);
                        } else {
                            lgr.error(message);
                        }
                    }
                });
                break;
            }
            default: {
                Collects.forEach(Arrs.range(count), new Consumer<Integer>(){

                    @Override
                    public void accept(Integer index) {
                        if (ex != null) {
                            lgr.warn(message, ex);
                        } else {
                            lgr.warn(message);
                        }
                    }
                });
            }
        }
    }

    private static Supplier<Object[], String> buildPlaceholderMessageSupplierOrNull(final String message, Object args) {
        Supplier<Object[], String> supplier = null;
        if (Emptys.isNotEmpty(message)) {
            supplier = Emptys.isEmpty(args) ? new Supplier<Object[], String>(){

                @Override
                public String get(Object[] input) {
                    return message;
                }
            } : new Supplier<Object[], String>(){

                @Override
                public String get(Object[] input) {
                    return StringTemplates.formatWithPlaceholder(message, input);
                }
            };
        }
        return supplier;
    }

    public static Logger getLogger(String loggerName) {
        return LoggerFactory.getLogger((String)loggerName);
    }

    public static Logger getLogger(Class clazz) {
        return LoggerFactory.getLogger((Class)clazz);
    }

    public static boolean isEnabled(@NonNull Logger logger, @NonNull Level level) {
        Preconditions.checkNotNull(level);
        Preconditions.checkNotNull(logger);
        boolean enabled = false;
        switch (level) {
            case TRACE: {
                enabled = logger.isTraceEnabled();
                break;
            }
            case DEBUG: {
                enabled = logger.isDebugEnabled();
                break;
            }
            case INFO: {
                enabled = logger.isInfoEnabled();
                break;
            }
            case WARN: {
                enabled = logger.isWarnEnabled();
                break;
            }
            default: {
                enabled = logger.isErrorEnabled();
            }
        }
        return enabled;
    }

    private static Logger doGetLogger(Object logger) {
        Logger lg = null;
        if (logger != null) {
            if (logger instanceof Logger) {
                lg = (Logger)logger;
            } else if (logger instanceof String) {
                lg = Loggers.getLogger((String)logger);
            } else if (logger instanceof Class) {
                lg = Loggers.getLogger((Class)logger);
            }
        }
        if (lg == null) {
            lg = Loggers.getLogger(Loggers.class);
        }
        return lg;
    }

    public static void debug(Object logger, String message, Object ... parameters) {
        Logger lg = Loggers.doGetLogger(logger);
        if (lg.isDebugEnabled()) {
            lg.debug(message, parameters);
        }
    }

    public static void info(Object logger, String message, Object ... parameters) {
        Logger lg = Loggers.doGetLogger(logger);
        if (lg.isInfoEnabled()) {
            lg.info(message, parameters);
        }
    }

    public static void warn(Object logger, String message, Object ... parameters) {
        Logger lg = Loggers.doGetLogger(logger);
        if (lg.isWarnEnabled()) {
            lg.warn(message, parameters);
        }
    }

    public static void error(Object logger, String message, Object ... parameters) {
        Logger lg = Loggers.doGetLogger(logger);
        if (lg.isErrorEnabled()) {
            lg.error(message, parameters);
        }
    }
}

