/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.jni;

import com.jn.langx.util.SystemPropertys;
import com.jn.langx.util.jni.NativeLibraryUtil;
import com.jn.langx.util.logging.Loggers;
import com.jn.langx.util.os.Platform;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;
import org.slf4j.Logger;

public final class NativeLibraryLoader {
    private static final String NATIVE_RESOURCE_HOME = "META-INF/native/";
    private static final File WORKDIR;
    private static final boolean DELETE_NATIVE_LIB_AFTER_LOADING;
    private static final String NATIVE_LIBRARY_KEY_PREFIX = "com.jn.langx.native";
    private static final String NATIVE_LIBRARY_WORK_DIR_KEY = "com.jn.langx.native.workdir";
    private static final String NATIVE_LIBRARY_DELETE_AFTER_LOADING_KEY = "com.jn.langx.native.deleteLibAfterLoading";

    private static File tmpdir() {
        File f;
        try {
            f = NativeLibraryLoader.toDirectory(SystemPropertys.get("java.io.tmpdir"));
            if (f != null) {
                return f;
            }
            if (Platform.isWindows) {
                f = NativeLibraryLoader.toDirectory(System.getenv("TEMP"));
                if (f != null) {
                    return f;
                }
                String userprofile = System.getenv("USERPROFILE");
                if (userprofile != null) {
                    f = NativeLibraryLoader.toDirectory(userprofile + "\\AppData\\Local\\Temp");
                    if (f != null) {
                        return f;
                    }
                    f = NativeLibraryLoader.toDirectory(userprofile + "\\Local Settings\\Temp");
                    if (f != null) {
                        return f;
                    }
                }
            } else {
                f = NativeLibraryLoader.toDirectory(System.getenv("TMPDIR"));
                if (f != null) {
                    return f;
                }
            }
        }
        catch (Exception userprofile) {
            // empty catch block
        }
        f = Platform.isWindows ? new File("C:\\Windows\\Temp") : new File("/tmp");
        Logger logger = Loggers.getLogger(NativeLibraryLoader.class);
        logger.warn("Failed to get the temporary directory; falling back to: " + f);
        return f;
    }

    private static File toDirectory(String path) {
        if (path == null) {
            return null;
        }
        File f = new File(path);
        f.mkdirs();
        if (!f.isDirectory()) {
            return null;
        }
        try {
            return f.getAbsoluteFile();
        }
        catch (Exception ignored) {
            return f;
        }
    }

    public static void loadFirstAvailable(ClassLoader loader, String ... names) {
        Logger logger = Loggers.getLogger(NativeLibraryLoader.class);
        for (String name : names) {
            try {
                NativeLibraryLoader.load(name, loader);
                logger.debug("Successfully loaded the library: {}", (Object)name);
                return;
            }
            catch (Throwable t) {
                logger.debug("Unable to load the library '{}', trying next name...", (Object)name, (Object)t);
            }
        }
        throw new IllegalArgumentException("Failed to load any of the given libraries: " + Arrays.toString(names));
    }

    private static String calculatePackagePrefix() {
        String expected;
        String maybeShaded = NativeLibraryLoader.class.getName();
        if (!maybeShaded.endsWith(expected = NativeLibraryLoader.class.getName())) {
            throw new UnsatisfiedLinkError(String.format("Could not find prefix added to %s to get %s. When shading, only adding a package prefix is supported", expected, maybeShaded));
        }
        return maybeShaded.substring(0, maybeShaded.length() - expected.length());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void load(String originalName, ClassLoader loader) {
        String implicitPackagePrefix = NativeLibraryLoader.calculatePackagePrefix();
        String packagePrefix = SystemPropertys.get("com.jn.langx.packagePrefix", implicitPackagePrefix);
        String name = packagePrefix.replace('.', '-') + originalName;
        String libname = System.mapLibraryName(name);
        String path = NATIVE_RESOURCE_HOME + libname;
        URL url = loader.getResource(path);
        if (url == null && Platform.isOSX) {
            url = path.endsWith(".jnilib") ? loader.getResource("META-INF/native/lib" + name + ".dynlib") : loader.getResource("META-INF/native/lib" + name + ".jnilib");
        }
        if (url == null) {
            NativeLibraryLoader.loadLibrary(loader, name, false);
            return;
        }
        int index = libname.lastIndexOf(46);
        String prefix = libname.substring(0, index);
        String suffix = libname.substring(index, libname.length());
        InputStream in = null;
        FileOutputStream out = null;
        File tmpFile = null;
        Logger logger = Loggers.getLogger(NativeLibraryLoader.class);
        try {
            int length;
            tmpFile = File.createTempFile(prefix, suffix, WORKDIR);
            in = url.openStream();
            out = new FileOutputStream(tmpFile);
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            out.flush();
            NativeLibraryLoader.closeQuietly(out);
            out = null;
            NativeLibraryLoader.loadLibrary(loader, tmpFile.getPath(), true);
        }
        catch (UnsatisfiedLinkError e) {
            try {
                try {
                    if (tmpFile == null) throw e;
                    if (!tmpFile.isFile()) throw e;
                    if (!tmpFile.canRead()) throw e;
                    if (NoexecVolumeDetector.canExecuteExecutable(tmpFile)) throw e;
                    logger.info("{} exists but cannot be executed even when execute permissions set; check volume for \"noexec\" flag; use -D{}=[path] to set native working directory separately.", (Object)tmpFile.getPath(), (Object)NATIVE_LIBRARY_WORK_DIR_KEY);
                    throw e;
                }
                catch (Throwable t) {
                    logger.debug("Error checking if {} is on a file store mounted with noexec", (Object)tmpFile, (Object)t);
                }
                throw e;
                catch (Exception e2) {
                    throw (UnsatisfiedLinkError)new UnsatisfiedLinkError("could not load a native library: " + name).initCause(e2);
                }
            }
            catch (Throwable throwable) {
                NativeLibraryLoader.closeQuietly(in);
                NativeLibraryLoader.closeQuietly(out);
                if (tmpFile == null) throw throwable;
                if (DELETE_NATIVE_LIB_AFTER_LOADING) {
                    if (tmpFile.delete()) throw throwable;
                }
                tmpFile.deleteOnExit();
                throw throwable;
            }
        }
        NativeLibraryLoader.closeQuietly(in);
        NativeLibraryLoader.closeQuietly(out);
        if (tmpFile == null) return;
        if (DELETE_NATIVE_LIB_AFTER_LOADING) {
            if (tmpFile.delete()) return;
        }
        tmpFile.deleteOnExit();
    }

    private static void loadLibrary(ClassLoader loader, String name, boolean absolute) {
        Logger logger = Loggers.getLogger(NativeLibraryLoader.class);
        try {
            Class<?> newHelper = NativeLibraryLoader.tryToLoadClass(loader, NativeLibraryUtil.class);
            NativeLibraryLoader.loadLibraryByHelper(newHelper, name, absolute);
            return;
        }
        catch (UnsatisfiedLinkError e) {
            logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)name, (Object)e);
        }
        catch (Exception e) {
            logger.debug("Unable to load the library '{}', trying other loading mechanism.", (Object)name, (Object)e);
        }
        NativeLibraryUtil.loadLibrary(name, absolute);
    }

    private static void loadLibraryByHelper(final Class<?> helper, final String name, final boolean absolute) throws UnsatisfiedLinkError {
        Object ret = AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                try {
                    Method method = helper.getMethod("loadLibrary", String.class, Boolean.TYPE);
                    method.setAccessible(true);
                    return method.invoke(null, name, absolute);
                }
                catch (Exception e) {
                    return e;
                }
            }
        });
        if (ret instanceof Throwable) {
            Throwable error = (Throwable)ret;
            Throwable cause = error.getCause();
            if (cause != null) {
                if (cause instanceof UnsatisfiedLinkError) {
                    throw (UnsatisfiedLinkError)cause;
                }
                throw new UnsatisfiedLinkError(cause.getMessage());
            }
            throw new UnsatisfiedLinkError(error.getMessage());
        }
    }

    private static Class<?> tryToLoadClass(final ClassLoader loader, final Class<?> helper) throws ClassNotFoundException {
        try {
            return loader.loadClass(helper.getName());
        }
        catch (ClassNotFoundException e) {
            final byte[] classBinary = NativeLibraryLoader.classToByteArray(helper);
            return (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

                @Override
                public Class<?> run() {
                    try {
                        Method defineClass = ClassLoader.class.getDeclaredMethod("defineClass", String.class, byte[].class, Integer.TYPE, Integer.TYPE);
                        defineClass.setAccessible(true);
                        return (Class)defineClass.invoke((Object)loader, helper.getName(), classBinary, 0, classBinary.length);
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Define class failed!", e);
                    }
                }
            });
        }
    }

    private static byte[] classToByteArray(Class<?> clazz) throws ClassNotFoundException {
        URL classUrl;
        String fileName = clazz.getName();
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot > 0) {
            fileName = fileName.substring(lastDot + 1);
        }
        if ((classUrl = clazz.getResource(fileName + ".class")) == null) {
            throw new ClassNotFoundException(clazz.getName());
        }
        byte[] buf = new byte[1024];
        ByteArrayOutputStream out = new ByteArrayOutputStream(4096);
        InputStream in = null;
        try {
            int r22;
            in = classUrl.openStream();
            while ((r22 = in.read(buf)) != -1) {
                out.write(buf, 0, r22);
            }
            byte[] r22 = out.toByteArray();
            return r22;
        }
        catch (IOException ex) {
            throw new ClassNotFoundException(clazz.getName(), ex);
        }
        finally {
            NativeLibraryLoader.closeQuietly(in);
            NativeLibraryLoader.closeQuietly(out);
        }
    }

    private static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private NativeLibraryLoader() {
    }

    static {
        String workdir = SystemPropertys.get(NATIVE_LIBRARY_WORK_DIR_KEY);
        Logger logger = Loggers.getLogger(NativeLibraryLoader.class);
        if (workdir != null) {
            File f = new File(workdir);
            f.mkdirs();
            try {
                f = f.getAbsoluteFile();
            }
            catch (Exception exception) {
                // empty catch block
            }
            WORKDIR = f;
            logger.debug("-D{}: {}", (Object)NATIVE_LIBRARY_WORK_DIR_KEY, (Object)WORKDIR);
        } else {
            WORKDIR = NativeLibraryLoader.tmpdir();
            logger.debug("-D{}: {} ", (Object)NATIVE_LIBRARY_WORK_DIR_KEY, (Object)WORKDIR);
        }
        DELETE_NATIVE_LIB_AFTER_LOADING = SystemPropertys.getAccessor().getBoolean(NATIVE_LIBRARY_DELETE_AFTER_LOADING_KEY, true);
    }

    private static final class NoexecVolumeDetector {
        private static boolean canExecuteExecutable(File file) throws IOException {
            if (Platform.JAVA_VERSION_INT < 7) {
                return true;
            }
            if (file.canExecute()) {
                return true;
            }
            return true;
        }

        private NoexecVolumeDetector() {
        }
    }
}

