/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.io.file;

import com.jn.langx.exception.RuntimeIOException;
import com.jn.langx.util.io.IOs;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import org.slf4j.Logger;

public final class DirectoryLock {
    public static final String FILE_NAME = "lock";
    private final File dir;
    private final FileChannel channel;
    private final FileLock lock;
    private final Logger logger;

    private DirectoryLock(File dir, FileChannel channel, FileLock lock, Logger logger) {
        this.dir = dir;
        this.channel = channel;
        this.lock = lock;
        this.logger = logger;
    }

    public File getDir() {
        return this.dir;
    }

    FileLock getLock() {
        return this.lock;
    }

    public void release() {
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Releasing lock on " + this.lockFile().getAbsolutePath());
        }
        try {
            this.lock.release();
        }
        catch (ClosedChannelException closedChannelException) {
        }
        catch (IOException e) {
            this.logger.error("Problem while releasing the lock on " + this.lockFile(), (Throwable)e);
        }
        try {
            this.channel.close();
        }
        catch (IOException e) {
            this.logger.error("Problem while closing the channel " + this.lockFile(), (Throwable)e);
        }
    }

    private File lockFile() {
        return new File(this.dir, FILE_NAME);
    }

    public static DirectoryLock lockForDirectory(File dir, Logger logger) {
        File lockFile = new File(dir, FILE_NAME);
        FileChannel channel = DirectoryLock.openChannel(lockFile);
        FileLock lock = DirectoryLock.acquireLock(lockFile, channel);
        if (logger.isInfoEnabled()) {
            logger.info("Acquired lock on " + lockFile.getAbsolutePath());
        }
        return new DirectoryLock(dir, channel, lock, logger);
    }

    private static FileChannel openChannel(File lockFile) {
        try {
            return new RandomAccessFile(lockFile, "rw").getChannel();
        }
        catch (IOException e) {
            throw new RuntimeIOException("Cannot create lock file " + lockFile.getAbsolutePath(), e);
        }
    }

    private static FileLock acquireLock(File lockFile, FileChannel channel) {
        FileLock fileLock = null;
        try {
            fileLock = channel.tryLock();
            if (fileLock == null) {
                throw new RuntimeIOException("Cannot acquire lock on " + lockFile.getAbsolutePath() + ". Directory is already being used by another member.");
            }
            FileLock fileLock2 = fileLock;
            return fileLock2;
        }
        catch (OverlappingFileLockException e) {
            throw new RuntimeException("Cannot acquire lock on " + lockFile.getAbsolutePath() + ". Directory is already being used by another member.", e);
        }
        catch (IOException e) {
            throw new RuntimeIOException("Unknown failure while acquiring lock on " + lockFile.getAbsolutePath(), e);
        }
        finally {
            if (fileLock == null) {
                IOs.close(channel);
            }
        }
    }
}

