/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.concurrent.async;

import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.concurrent.CommonTask;
import com.jn.langx.util.concurrent.async.AbstractFuture;
import com.jn.langx.util.concurrent.async.GenericFuture;
import com.jn.langx.util.concurrent.async.GenericFutureListener;
import com.jn.langx.util.function.Consumer;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DefaultFuture<V>
extends AbstractFuture<V>
implements Callable<V>,
Runnable {
    private CommonTask<V> task;
    private Future<V> future;
    private final List<GenericFutureListener<? extends GenericFuture<? super V>>> listeners = Collects.emptyArrayList();
    private boolean cancelable = true;
    private Throwable cause;
    private boolean success = false;
    private V expectedResult = null;

    public DefaultFuture(Callable task) {
        this.task = new CommonTask(task);
    }

    public DefaultFuture(Runnable task) {
        this.task = new CommonTask(task);
    }

    public void with(Future<V> future) {
        this.future = future;
    }

    public void setCancelable(boolean cancelable) {
        this.cancelable = cancelable;
    }

    @Override
    public GenericFuture<V> addListener(GenericFutureListener<? extends GenericFuture<? super V>> listener) {
        this.listeners.add(listener);
        return this;
    }

    @Override
    public GenericFuture<V> addListeners(GenericFutureListener<? extends GenericFuture<? super V>> ... listeners) {
        Collects.addAll(this.listeners, listeners);
        return this;
    }

    @Override
    public GenericFuture<V> removeListener(GenericFutureListener<? extends GenericFuture<? super V>> listener) {
        this.listeners.remove(listener);
        return this;
    }

    @Override
    public GenericFuture<V> removeListeners(GenericFutureListener<? extends GenericFuture<? super V>> ... listeners) {
        Collects.removeAll(this.listeners, Collects.asList(listeners));
        return this;
    }

    @Override
    public GenericFuture<V> sync() throws InterruptedException {
        try {
            return this.await();
        }
        catch (InterruptedException ite) {
            throw ite;
        }
        catch (Throwable ex) {
            this.cause = ex;
            throw new RuntimeException(this.cause);
        }
    }

    @Override
    public GenericFuture<V> syncUninterruptibly() {
        try {
            return this.awaitUninterruptibly();
        }
        catch (Throwable ex) {
            this.cause = ex;
            throw new RuntimeException(this.cause);
        }
    }

    @Override
    public GenericFuture<V> await() throws InterruptedException {
        this.await(-1L);
        return this;
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.await(unit.toMillis(timeout));
    }

    @Override
    public boolean await(long timeoutMillis) throws InterruptedException {
        this.await(timeoutMillis, false);
        return this.isDone();
    }

    @Override
    public GenericFuture<V> awaitUninterruptibly() {
        this.awaitUninterruptibly(-1L);
        return this;
    }

    @Override
    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.awaitUninterruptibly(unit.toMillis(timeout));
    }

    @Override
    public boolean awaitUninterruptibly(long timeoutMillis) {
        try {
            this.await(timeoutMillis, true);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.isDone();
    }

    private boolean await(long timeoutMillis, boolean uninterruptible) throws InterruptedException {
        boolean completed;
        if (!this.isDone()) {
            long deadline;
            long start = System.currentTimeMillis();
            long l = deadline = timeoutMillis < 0L ? Long.MAX_VALUE : start + timeoutMillis;
            while (!this.isDone() && System.currentTimeMillis() < deadline) {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ite) {
                    if (!uninterruptible) continue;
                    throw ite;
                }
            }
        }
        if (completed = this.isDone()) {
            final DefaultFuture _this = this;
            Pipeline.of(this.listeners).forEach(new Consumer<GenericFutureListener>(){

                @Override
                public void accept(GenericFutureListener listener) {
                    listener.operationComplete(_this);
                }
            });
        }
        return completed;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.cancelable) {
            this.future.cancel(mayInterruptIfRunning);
            return this.future.isCancelled();
        }
        return false;
    }

    @Override
    public V call() {
        try {
            V r = this.task.call();
            this.success = true;
            return r;
        }
        catch (Throwable e) {
            this.cause = e;
            return null;
        }
    }

    @Override
    public void run() {
        try {
            this.task.run();
            this.success = true;
        }
        catch (Throwable e) {
            this.cause = e;
        }
    }

    @Override
    public V getNow() {
        if (this.isDone()) {
            try {
                return this.future.get(0L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable throwable) {
            }
        } else if (this.expectedResult != null) {
            return this.expectedResult;
        }
        return null;
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public boolean isCancellable() {
        return this.cancelable;
    }

    @Override
    public Throwable cause() {
        return this.cause;
    }

    public void setExpectedResult(V expectedResult) {
        this.expectedResult = expectedResult;
    }

    public static <V> GenericFuture<V> submit(ExecutorService executorService, Runnable runnable, boolean cancelable, V result) {
        DefaultFuture<V> future = new DefaultFuture<V>(runnable);
        future.setExpectedResult(result);
        future.setCancelable(cancelable);
        Future<V> f = executorService.submit(future, result);
        future.with(f);
        return future;
    }

    public static <V> GenericFuture<V> submit(ExecutorService executorService, Runnable runnable) {
        return DefaultFuture.submit(executorService, runnable, true);
    }

    public static <V> GenericFuture<V> submit(ExecutorService executorService, Runnable runnable, boolean cancelable) {
        return DefaultFuture.submit(executorService, runnable, cancelable, null);
    }

    public static <V> GenericFuture<V> submit(ExecutorService executorService, Callable<V> callable) {
        return DefaultFuture.submit(executorService, callable, true);
    }

    public static <V> GenericFuture<V> submit(ExecutorService executorService, Callable<V> callable, boolean cancelable) {
        DefaultFuture<V> future = new DefaultFuture<V>(callable);
        future.setCancelable(cancelable);
        Future<V> f = executorService.submit(future);
        future.with(f);
        return future;
    }
}

