/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.stack;

import com.jn.langx.util.Emptys;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.stack.Stack;
import java.util.Collection;
import java.util.EmptyStackException;
import java.util.Iterator;
import java.util.concurrent.LinkedBlockingDeque;

public class ThreadSafeStack<E>
implements Stack<E> {
    private LinkedBlockingDeque<E> deque = new LinkedBlockingDeque();

    public ThreadSafeStack() {
    }

    public ThreadSafeStack(Collection<E> c) {
        this();
        if (Emptys.isNotEmpty(c)) {
            this.deque.addAll(c);
        }
    }

    @Override
    public E push(E item) {
        this.deque.addLast(item);
        return item;
    }

    @Override
    public E pop() {
        if (this.deque.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.deque.pollLast();
    }

    @Override
    public E peek() {
        if (this.deque.isEmpty()) {
            throw new EmptyStackException();
        }
        return this.deque.peekLast();
    }

    @Override
    public int search(Object o) {
        return Collects.firstOccurrence(this, o);
    }

    @Override
    public int size() {
        return this.deque.size();
    }

    @Override
    public boolean isEmpty() {
        return this.deque.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.deque.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.deque.descendingIterator();
    }

    @Override
    public Object[] toArray() {
        return this.deque.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.deque.toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.push(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.deque.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.deque.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.deque.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.deque.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.deque.retainAll(c);
    }

    @Override
    public void clear() {
        this.deque.clear();
    }
}

