/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.sequence;

import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Tuple;
import com.jn.langx.util.collection.sequence.Sequence;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class TupleSequence
implements Sequence<Object> {
    private Tuple tuple;

    public TupleSequence(Tuple tuple) {
        this.tuple = tuple;
    }

    @Override
    public Object first() {
        return this.tuple.get(0);
    }

    @Override
    public Object last() {
        return this.tuple.get(this.size() - 1);
    }

    @Override
    public boolean isNull() {
        return this.tuple == null;
    }

    @Override
    public int size() {
        return this.tuple.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.tuple.contains(o);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.tuple.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.tuple.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.tuple.toArray(a);
    }

    @Override
    public boolean add(Object o) {
        if (this.size() < this.tuple.capacity()) {
            this.tuple.getTarget().add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<?> c) {
        if (this.size() + c.size() <= this.tuple.capacity()) {
            return this.tuple.getTarget().addAll(c);
        }
        return false;
    }

    @Override
    public boolean addAll(int index, Collection<?> c) {
        if (this.size() + c.size() <= this.tuple.capacity()) {
            return this.tuple.getTarget().addAll(index, c);
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.tuple.getTarget().containsAll(c);
    }

    @Override
    public Object get(int index) {
        return this.tuple.get(index);
    }

    @Override
    public Object set(int index, Object element) {
        return this.tuple.getTarget().set(index, element);
    }

    @Override
    public void add(int index, Object element) {
        if (this.size() < this.tuple.capacity()) {
            this.tuple.getTarget().add(index, element);
        }
    }

    @Override
    public Object remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int indexOf(Object o) {
        return this.tuple.getTarget().indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.tuple.getTarget().lastIndexOf(o);
    }

    @Override
    public ListIterator<Object> listIterator() {
        return this.tuple.getTarget().listIterator();
    }

    @Override
    public ListIterator<Object> listIterator(int index) {
        return this.tuple.getTarget().listIterator(index);
    }

    @Override
    public List<Object> subList(int fromIndex, int toIndex) {
        int[] validIndexes = Arrs.toPositiveIndexes(this.size(), fromIndex, toIndex);
        return this.tuple.getTarget().subList(validIndexes[0], validIndexes[1]);
    }

    @Override
    public TupleSequence subSequence(int fromIndex, int toIndex) {
        return new TupleSequence(new Tuple(this.subList(fromIndex, toIndex)));
    }

    @Override
    public List<Object> asList() {
        return Collects.newArrayList(this.tuple.getTarget());
    }

    @Override
    public String toString() {
        return this.tuple.toString();
    }
}

