/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.sequence;

import com.jn.langx.util.Objs;
import com.jn.langx.util.Strings;
import com.jn.langx.util.collection.Arrs;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.sequence.Sequence;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedSet;
import java.util.TreeSet;

public class SortedSetSequence<E>
implements Sequence<E> {
    private SortedSet<E> set;

    public SortedSetSequence(SortedSet<E> set) {
        this.set = set;
    }

    @Override
    public E first() {
        return this.set.first();
    }

    @Override
    public E last() {
        return this.set.last();
    }

    @Override
    public boolean isNull() {
        return false;
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return Objs.isEmpty(this.set);
    }

    @Override
    public boolean contains(Object o) {
        return this.set.contains(o);
    }

    @Override
    public Iterator<E> iterator() {
        return this.set.iterator();
    }

    @Override
    public Object[] toArray() {
        return this.set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.set.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.set.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.set.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.set.containsAll(c);
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.set.addAll(c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.set.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.set.retainAll(c);
    }

    @Override
    public void clear() {
        this.set.clear();
    }

    @Override
    public E get(int index) {
        return Collects.asList(this.set).get(index);
    }

    @Override
    public E set(int index, E element) {
        E old = this.remove(index);
        this.add(element);
        return old;
    }

    @Override
    public void add(int index, E element) {
        this.add(element);
    }

    @Override
    public E remove(int index) {
        E old = this.get(index);
        if (old != null) {
            this.set.remove(old);
        }
        return old;
    }

    @Override
    public int indexOf(Object o) {
        return Collects.indexOf(Collects.asList(this.set), o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return Collects.lastIndexOf(Collects.asList(this.set), o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return Collects.asList(this.set).listIterator();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return Collects.asList(this.set).listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        int[] validIndexes = Arrs.toPositiveIndexes(this.size(), fromIndex, toIndex);
        return Collects.asList(this.set).subList(validIndexes[0], validIndexes[1]);
    }

    @Override
    public SortedSetSequence<E> subSequence(int fromIndex, int toIndex) {
        List<E> list = this.subList(fromIndex, toIndex);
        TreeSet<E> set = new TreeSet<E>(this.set.comparator());
        set.addAll(list);
        return new SortedSetSequence<E>(set);
    }

    @Override
    public List<E> asList() {
        return Collects.newArrayList(this.set);
    }

    @Override
    public String toString() {
        return Strings.join(",", "{", "}", false, this.set.iterator());
    }
}

