/*
 * Decompiled with CFR 0.152.
 */
package com.jn.langx.util.collection.graph;

import com.jn.langx.util.StringJoiner;
import com.jn.langx.util.collection.Collects;
import com.jn.langx.util.collection.Pipeline;
import com.jn.langx.util.collection.graph.Edge;
import com.jn.langx.util.collection.graph.Graphs;
import com.jn.langx.util.collection.graph.Vertex;
import com.jn.langx.util.function.Consumer;
import com.jn.langx.util.function.Function;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Graph<T> {
    public static final int VISIT_COLOR_WHITE = 1;
    public static final int VISIT_COLOR_GREY = 2;
    public static final int VISIT_COLOR_BLACK = 3;
    protected Map<String, Vertex<T>> vertices = new LinkedHashMap<String, Vertex<T>>();
    protected List<Edge<T>> edges = new ArrayList<Edge<T>>();
    protected Vertex<T> rootVertex;

    public boolean isEmpty() {
        return this.vertices.size() == 0;
    }

    public int size() {
        return this.vertices.size();
    }

    public Vertex<T> getRootVertex() {
        return this.rootVertex;
    }

    public void setRootVertex(Vertex<T> vertex) {
        this.rootVertex = vertex;
        this.addVertex(vertex);
    }

    public boolean addVertex(String name, T data) {
        return this.addVertex(new Vertex<T>(name, data));
    }

    public boolean addVertex(Vertex<T> v) {
        if (!this.hasVertex(v.getName())) {
            this.vertices.put(v.getName(), v);
            return true;
        }
        return false;
    }

    public boolean removeVertex(String name) {
        Vertex<T> vertex = this.getVertex(name);
        if (vertex != null) {
            return this.removeVertex(vertex);
        }
        return false;
    }

    public boolean removeVertex(Vertex<T> v) {
        Edge<T> e;
        if (!this.hasVertex(v.getName())) {
            return false;
        }
        this.vertices.remove(v.getName());
        if (v == this.rootVertex) {
            this.rootVertex = null;
        }
        int n = 0;
        while (n < v.getOutgoingEdgeCount()) {
            e = v.getOutgoingEdge(0);
            v.remove(e);
            Vertex<T> to = e.getTo();
            to.remove(e);
            this.edges.remove(e);
        }
        n = 0;
        while (n < v.getIncomingEdgeCount()) {
            e = v.getIncomingEdge(0);
            v.remove(e);
            Vertex<T> from = e.getFrom();
            from.remove(e);
            this.edges.remove(e);
        }
        return true;
    }

    public boolean removeVertex(String vertexName, boolean removeUnsharedOutgoing) {
        Vertex<T> vertex = this.getVertex(vertexName);
        if (vertex != null) {
            return this.removeVertex(vertex, removeUnsharedOutgoing);
        }
        return false;
    }

    public boolean removeVertex(Vertex<T> v, boolean removeUnsharedOutgoing) {
        if (!removeUnsharedOutgoing) {
            this.removeVertex(v);
        }
        if (!this.hasVertex(v.getName())) {
            return false;
        }
        v = this.getVertex(v.getName());
        List outgoingVertices = Graphs.tdfsSort(this, v.getName());
        final ArrayList<Vertex<T>> willRemovedVertices = new ArrayList<Vertex<T>>();
        willRemovedVertices.add(v);
        Collects.forEach(outgoingVertices, new Consumer<Vertex<T>>(){

            @Override
            public void accept(Vertex<T> vertex) {
                ArrayList incomings = Collects.newArrayList(vertex.getIncomingVertices());
                incomings.removeAll(willRemovedVertices);
                if (incomings.isEmpty()) {
                    willRemovedVertices.add(vertex);
                }
            }
        });
        Pipeline.of(willRemovedVertices).reverse(true).forEach(new Consumer<Vertex<T>>(){

            @Override
            public void accept(Vertex<T> vertex) {
                Graph.this.removeVertex(vertex);
            }
        });
        return true;
    }

    public List<Vertex<T>> getVertices() {
        return new ArrayList<Vertex<T>>(this.vertices.values());
    }

    public List<String> getVertexNames() {
        return Pipeline.of(this.getVertices()).map(new Function<Vertex<T>, String>(){

            @Override
            public String apply(Vertex<T> vertex) {
                return vertex.getName();
            }
        }).asList();
    }

    public Vertex<T> getVertex(int n) {
        return this.getVertices().get(n);
    }

    public Vertex<T> getVertex(String name) {
        return this.vertices.get(name);
    }

    public boolean hasVertex(String name) {
        return this.getVertex(name) != null;
    }

    public Vertex<T> findVertexByData(T data, Comparator<T> compare) {
        Vertex<T> match = null;
        for (Vertex<T> v : this.vertices.values()) {
            if (compare.compare(data, v.getData()) != 0) continue;
            match = v;
            break;
        }
        return match;
    }

    public boolean addEdge(String from, String to) throws IllegalArgumentException {
        return this.addEdge(from, to, 0);
    }

    public boolean addEdge(String from, String to, int weight) throws IllegalArgumentException {
        return this.addEdge(from, to, null, weight);
    }

    public boolean addEdge(String from, String to, String label, int weight) throws IllegalArgumentException {
        if (!this.hasVertex(from)) {
            throw new IllegalArgumentException("from vertex " + from + " is not in graph");
        }
        if (!this.hasVertex(to)) {
            throw new IllegalArgumentException("to vertex " + to + " is not in graph");
        }
        return this.addEdge(this.getVertex(from), this.getVertex(to), label, weight);
    }

    public boolean addEdge(Vertex<T> from, Vertex<T> to) {
        return this.addEdge(from, to, 0);
    }

    public boolean addEdge(Vertex<T> from, Vertex<T> to, int weight) {
        return this.addEdge(from, to, null, weight);
    }

    public boolean addEdge(Vertex<T> from, Vertex<T> to, String label, int weight) {
        if (!this.hasVertex(from.getName())) {
            this.addVertex(from);
        }
        if (!this.hasVertex(to.getName())) {
            this.addVertex(to);
        }
        Edge<T> e = new Edge<T>(from, to, label, weight);
        if (from.findEdge(to) != null) {
            return false;
        }
        from.addEdge(e);
        to.addEdge(e);
        this.edges.add(e);
        return true;
    }

    public boolean addBiEdge(Vertex<T> from, Vertex<T> to, int weight) {
        return this.addEdge(from, to, weight) && this.addEdge(to, from, weight);
    }

    public List<Edge<T>> getEdges() {
        return Collects.newArrayList(this.edges);
    }

    public boolean removeEdge(String from, String to) {
        if (this.hasVertex(from) && this.hasVertex(to)) {
            return this.removeEdge(this.getVertex(from), this.getVertex(to));
        }
        return false;
    }

    public boolean removeEdge(Vertex<T> from, Vertex<T> to) {
        Edge<T> e = from.findEdge(to);
        if (e == null) {
            return false;
        }
        from.remove(e);
        to.remove(e);
        this.edges.remove(e);
        return true;
    }

    public boolean hasEdge(String from, String to) {
        Vertex<T> fromVertex = this.getVertex(from);
        Vertex<T> toVertex = this.getVertex(to);
        if (fromVertex == null || toVertex == null) {
            return false;
        }
        return fromVertex.getOutgoingVertices().contains(toVertex);
    }

    public boolean hasBiEdge(String from, String to) {
        return this.hasEdge(from, to) && this.hasEdge(to, from);
    }

    public String toString() {
        StringJoiner joiner = new StringJoiner(",", "Graph[", "]");
        for (Vertex<T> v : this.vertices.values()) {
            joiner.add(v.toString());
        }
        return joiner.toString();
    }
}

